/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.config;

import java.util.Objects;
import org.eclipse.hono.config.AbstractConfig;
import org.eclipse.hono.config.ServerOptions;

public class ServerConfig
extends AbstractConfig {
    private int port = -1;
    private String bindAddress = "127.0.0.1";
    private boolean nativeTlsRequired = false;
    private boolean insecurePortEnabled = false;
    private String insecurePortBindAddress = "127.0.0.1";
    private int insecurePort = -1;
    private boolean sni = false;

    public ServerConfig() {
    }

    public ServerConfig(ServerOptions options) {
        super(options.genericOptions());
        this.bindAddress = options.bindAddress();
        if (options.insecurePort() > -1) {
            this.setInsecurePort(options.insecurePort());
        }
        this.insecurePortBindAddress = options.insecurePortBindAddress();
        this.insecurePortEnabled = options.insecurePortEnabled();
        this.nativeTlsRequired = options.nativeTlsRequired();
        if (options.port() > -1) {
            this.setPort(options.port());
        }
        this.sni = options.sni();
    }

    public final boolean isSubstrateVm() {
        return System.getProperty("java.vm.name", "unknown").startsWith("Substrate");
    }

    public final String getBindAddress() {
        return this.bindAddress;
    }

    public final void setBindAddress(String address) {
        this.bindAddress = Objects.requireNonNull(address);
    }

    public final int getPort() {
        return this.port;
    }

    public final int getPort(int defaultPort) {
        return this.port == -1 ? defaultPort : this.port;
    }

    public final void setPort(int port) {
        if (!this.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.port = port;
    }

    public boolean isSecurePortEnabled() {
        return this.getKeyCertOptions() != null;
    }

    public final boolean isNativeTlsRequired() {
        return this.nativeTlsRequired;
    }

    public final void setNativeTlsRequired(boolean nativeTlsRequired) {
        this.nativeTlsRequired = nativeTlsRequired;
    }

    public boolean isInsecurePortEnabled() {
        return this.insecurePortEnabled || this.insecurePort > -1;
    }

    public final void setInsecurePortEnabled(boolean insecurePortEnabled) {
        this.insecurePortEnabled = insecurePortEnabled;
    }

    public final String getInsecurePortBindAddress() {
        return this.insecurePortBindAddress;
    }

    public final void setInsecurePortBindAddress(String address) {
        this.insecurePortBindAddress = Objects.requireNonNull(address);
    }

    public final int getInsecurePort() {
        return this.insecurePort;
    }

    public final int getInsecurePort(int defaultPort) {
        return this.insecurePort == -1 ? defaultPort : this.insecurePort;
    }

    public final void setInsecurePort(int port) {
        if (!this.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port number");
        }
        this.insecurePort = port;
        this.setInsecurePortEnabled(true);
    }

    public final void setSni(boolean sni) {
        this.sni = sni;
    }

    public final boolean isSni() {
        return this.sni;
    }
}

