/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.tracing;

import io.opentracing.propagation.TextMap;
import io.vertx.kafka.client.producer.KafkaHeader;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class KafkaHeadersExtractAdapter
implements TextMap {
    private final List<KafkaHeader> headers;

    public KafkaHeadersExtractAdapter(List<KafkaHeader> headers) {
        this.headers = Objects.requireNonNull(headers);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        if (this.headers.isEmpty()) {
            return Collections.emptyIterator();
        }
        final Iterator<KafkaHeader> headersIterator = this.headers.iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return headersIterator.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                KafkaHeader header = (KafkaHeader)headersIterator.next();
                return new AbstractMap.SimpleEntry<String, String>(header.key(), header.value().toString());
            }
        };
    }

    @Override
    public void put(String key, String value) {
        throw new UnsupportedOperationException();
    }
}

