/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.auth;

import io.jsonwebtoken.Claims;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthoritiesImpl
implements Authorities {
    public static final String PREFIX_RESOURCE = "r:";
    public static final String PREFIX_OPERATION = "o:";
    private static final Logger LOG = LoggerFactory.getLogger(AuthoritiesImpl.class);
    private static final String TEMPLATE_OP = "o:%s:%s";
    private static final String TEMPLATE_RESOURCE = "r:%s";
    private final Map<String, String> authorities = new HashMap<String, String>();

    public static Authorities from(Claims claims) {
        Objects.requireNonNull(claims);
        AuthoritiesImpl result = new AuthoritiesImpl();
        claims.forEach((key, value) -> {
            if ((key.startsWith(PREFIX_OPERATION) || key.startsWith(PREFIX_RESOURCE)) && value instanceof String) {
                LOG.trace("adding claim [key: {}, value: {}]", key, value);
                result.authorities.put((String)key, (String)value);
            } else {
                LOG.trace("ignoring unsupported claim [key: {}]", key);
            }
        });
        return result;
    }

    private static String getOperationKey(String endpoint, String tenant, String operation) {
        if (tenant == null) {
            return String.format(TEMPLATE_OP, endpoint, operation);
        }
        return String.format(TEMPLATE_OP, endpoint + "/" + tenant, operation);
    }

    private static String getResourceKey(String endpoint, String tenant) {
        if (tenant == null) {
            return String.format(TEMPLATE_RESOURCE, endpoint);
        }
        return String.format(TEMPLATE_RESOURCE, endpoint + "/" + tenant);
    }

    public AuthoritiesImpl addOperation(String resource, String operation) {
        return this.addOperation(resource, null, operation);
    }

    public AuthoritiesImpl addOperation(String endpoint, String tenant, String operation) {
        this.authorities.put(AuthoritiesImpl.getOperationKey(endpoint, tenant, operation), String.valueOf(Activity.EXECUTE.getCode()));
        return this;
    }

    public AuthoritiesImpl addResource(String resource, Activity ... activities) {
        return this.addResource(resource, (String)null, activities);
    }

    public AuthoritiesImpl addResource(String endpoint, String tenant, Activity ... activities) {
        StringBuilder b = new StringBuilder();
        for (Activity a : activities) {
            b.append(a.getCode());
        }
        this.authorities.put(AuthoritiesImpl.getResourceKey(endpoint, tenant), b.toString());
        return this;
    }

    public AuthoritiesImpl addAll(Authorities authoritiesToAdd) {
        authoritiesToAdd.asMap().entrySet().stream().filter(entry -> entry.getValue() instanceof String).forEach(entry -> {
            String value = (String)entry.getValue();
            LOG.trace("adding authority [key: {}, activities: {}]", entry.getKey(), (Object)value);
            this.authorities.put((String)entry.getKey(), value);
        });
        return this;
    }

    @Override
    public boolean isAuthorized(ResourceIdentifier resource, Activity intent) {
        boolean allowed = false;
        if (resource.getResourceId() != null) {
            allowed = this.isAuthorized(String.format(TEMPLATE_RESOURCE, resource.toString()), intent);
        }
        if (!allowed && resource.getTenantId() != null) {
            boolean bl = allowed = this.isAuthorized(String.format(TEMPLATE_RESOURCE, resource.getEndpoint() + "/" + resource.getTenantId()), intent) || this.isAuthorized(String.format(TEMPLATE_RESOURCE, resource.getEndpoint() + "/*"), intent);
        }
        if (!allowed) {
            allowed = this.isAuthorized(String.format(TEMPLATE_RESOURCE, resource.getEndpoint()), intent) || this.isAuthorized(String.format(TEMPLATE_RESOURCE, "*"), intent);
        }
        return allowed;
    }

    @Override
    public boolean isAuthorized(ResourceIdentifier resource, String operation) {
        boolean allowed = false;
        if (resource.getResourceId() != null) {
            boolean bl = allowed = this.isAuthorized(String.format(TEMPLATE_OP, resource.toString(), operation), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, resource.toString(), "*"), Activity.EXECUTE);
        }
        if (!allowed && resource.getTenantId() != null) {
            boolean bl = allowed = this.isAuthorized(String.format(TEMPLATE_OP, resource.getEndpoint() + "/" + resource.getTenantId(), operation), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, resource.getEndpoint() + "/" + resource.getTenantId(), "*"), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, resource.getEndpoint() + "/*", operation), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, resource.getEndpoint() + "/*", "*"), Activity.EXECUTE);
        }
        if (!allowed) {
            allowed = this.isAuthorized(String.format(TEMPLATE_OP, resource.getEndpoint(), operation), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, resource.getEndpoint(), "*"), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, "*", operation), Activity.EXECUTE) || this.isAuthorized(String.format(TEMPLATE_OP, "*", "*"), Activity.EXECUTE);
        }
        return allowed;
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.authorities);
        return result;
    }

    boolean isAuthorized(String key, Activity intent) {
        boolean result = false;
        String grantedActivities = this.authorities.get(key);
        if (grantedActivities == null) {
            LOG.trace("no claim for key [{}]", (Object)key);
        } else {
            result = grantedActivities.contains(String.valueOf(intent.getCode())) || grantedActivities.equals("*");
            LOG.trace("found claim [key: {}, activities: {}] {}matching intent [{}]", key, grantedActivities, result ? "" : "not ", intent.name());
        }
        return result;
    }
}

