/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.annotation;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

class Deserializer
extends FromStringDeserializer<Instant> {
    private static final long serialVersionUID = 1L;

    protected Deserializer() {
        super(Instant.class);
    }

    @Override
    protected Instant _deserialize(String value, DeserializationContext ctxt) throws IOException {
        try {
            OffsetDateTime dateTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)value, OffsetDateTime::from);
            return dateTime.toInstant();
        }
        catch (DateTimeParseException e) {
            throw new IOException(e);
        }
    }
}

