/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressBackendFluent<A extends IngressBackendFluent<A>>
extends BaseFluent<A> {
    private TypedLocalObjectReference resource;
    private String serviceName;
    private IntOrStringBuilder servicePort;
    private Map<String, Object> additionalProperties;

    public IngressBackendFluent() {
    }

    public IngressBackendFluent(IngressBackend instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressBackend instance) {
        IngressBackend ingressBackend = instance = instance != null ? instance : new IngressBackend();
        if (instance != null) {
            this.withResource(instance.getResource());
            this.withServiceName(instance.getServiceName());
            this.withServicePort(instance.getServicePort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    public boolean hasServiceName() {
        return this.serviceName != null;
    }

    public IntOrString buildServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    public A withServicePort(IntOrString servicePort) {
        this._visitables.remove("servicePort");
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.get("servicePort").add(this.servicePort);
        } else {
            this.servicePort = null;
            this._visitables.get("servicePort").remove(this.servicePort);
        }
        return (A)this;
    }

    public boolean hasServicePort() {
        return this.servicePort != null;
    }

    public A withNewServicePort(Object value) {
        return this.withServicePort(new IntOrString(value));
    }

    public ServicePortNested<A> withNewServicePort() {
        return new ServicePortNested(null);
    }

    public ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNested(item);
    }

    public ServicePortNested<A> editServicePort() {
        return this.withNewServicePortLike(Optional.ofNullable(this.buildServicePort()).orElse(null));
    }

    public ServicePortNested<A> editOrNewServicePort() {
        return this.withNewServicePortLike(Optional.ofNullable(this.buildServicePort()).orElse(new IntOrStringBuilder().build()));
    }

    public ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
        return this.withNewServicePortLike(Optional.ofNullable(this.buildServicePort()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendFluent that = (IngressBackendFluent)o;
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.serviceName, that.serviceName)) {
            return false;
        }
        if (!Objects.equals(this.servicePort, that.servicePort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resource, this.serviceName, this.servicePort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName + ",");
        }
        if (this.servicePort != null) {
            sb.append("servicePort:");
            sb.append(this.servicePort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServicePortNested<N>
    extends IntOrStringFluent<ServicePortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ServicePortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluent.this.withServicePort(this.builder.build());
        }

        public N endServicePort() {
            return this.and();
        }
    }
}

