/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Integer targetCPUUtilizationPercentage;
    private Map<String, Object> additionalProperties;

    public HorizontalPodAutoscalerSpecFluent() {
    }

    public HorizontalPodAutoscalerSpecFluent(HorizontalPodAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HorizontalPodAutoscalerSpec instance) {
        HorizontalPodAutoscalerSpec horizontalPodAutoscalerSpec = instance = instance != null ? instance : new HorizontalPodAutoscalerSpec();
        if (instance != null) {
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove("scaleTargetRef");
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)this;
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new CrossVersionObjectReferenceBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return (A)this;
    }

    public boolean hasTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluent that = (HorizontalPodAutoscalerSpecFluent)o;
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals(this.scaleTargetRef, that.scaleTargetRef)) {
            return false;
        }
        if (!Objects.equals(this.targetCPUUtilizationPercentage, that.targetCPUUtilizationPercentage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.minReplicas, this.scaleTargetRef, this.targetCPUUtilizationPercentage, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef + ",");
        }
        if (this.targetCPUUtilizationPercentage != null) {
            sb.append("targetCPUUtilizationPercentage:");
            sb.append(this.targetCPUUtilizationPercentage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends CrossVersionObjectReferenceFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNested(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

