/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.CovariantTypes;
import io.quarkus.arc.impl.TypeCachePollutionUtils;
import io.quarkus.arc.impl.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;

class BeanTypeAssignabilityRules {
    private static final BeanTypeAssignabilityRules INSTANCE = new BeanTypeAssignabilityRules();

    public static BeanTypeAssignabilityRules instance() {
        return INSTANCE;
    }

    protected BeanTypeAssignabilityRules() {
    }

    public boolean matches(Type requiredType, Set<? extends Type> beanTypes) {
        for (Type type : beanTypes) {
            if (!this.matches(requiredType, type)) continue;
            return true;
        }
        return false;
    }

    protected boolean matches(Type requiredType, Type beanType) {
        return this.matchesNoBoxing(Types.boxedType(requiredType), Types.boxedType(beanType));
    }

    private boolean matchesNoBoxing(Type requiredType, Type beanType) {
        if (Types.isArray(requiredType) && Types.isArray(beanType)) {
            return this.matchesNoBoxing(Types.getArrayComponentType(requiredType), Types.getArrayComponentType(beanType));
        }
        if (requiredType instanceof Class) {
            if (beanType instanceof Class) {
                return this.matches((Class)requiredType, (Class)beanType);
            }
            if (TypeCachePollutionUtils.isParameterizedType(beanType)) {
                return this.matches((Class)requiredType, TypeCachePollutionUtils.asParameterizedType(beanType));
            }
        } else if (TypeCachePollutionUtils.isParameterizedType(requiredType)) {
            if (beanType instanceof Class) {
                return this.matches((Class)beanType, TypeCachePollutionUtils.asParameterizedType(requiredType));
            }
            if (TypeCachePollutionUtils.isParameterizedType(beanType)) {
                return this.matches(TypeCachePollutionUtils.asParameterizedType(requiredType), TypeCachePollutionUtils.asParameterizedType(beanType));
            }
        }
        return false;
    }

    private boolean matches(Class<?> requiredType, Class<?> beanType) {
        return requiredType.equals(beanType);
    }

    private boolean matches(Class<?> type1, ParameterizedType type2) {
        if (!type1.equals(Types.getRawType(type2))) {
            return false;
        }
        return Types.isArrayOfUnboundedTypeVariablesOrObjects(type2.getActualTypeArguments());
    }

    private boolean matches(ParameterizedType requiredType, ParameterizedType beanType) {
        if (!requiredType.getRawType().equals(beanType.getRawType())) {
            return false;
        }
        if (requiredType.getActualTypeArguments().length != beanType.getActualTypeArguments().length) {
            throw new IllegalArgumentException("Invalid argument combination " + requiredType + "; " + beanType);
        }
        for (int i = 0; i < requiredType.getActualTypeArguments().length; ++i) {
            if (this.parametersMatch(requiredType.getActualTypeArguments()[i], beanType.getActualTypeArguments()[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean parametersMatch(Type requiredParameter, Type beanParameter) {
        if (Types.isActualType(requiredParameter) && Types.isActualType(beanParameter)) {
            return this.matches(requiredParameter, beanParameter);
        }
        if (requiredParameter instanceof WildcardType && Types.isActualType(beanParameter)) {
            return this.parametersMatch((WildcardType)requiredParameter, beanParameter);
        }
        if (requiredParameter instanceof WildcardType && beanParameter instanceof TypeVariable) {
            return this.parametersMatch((WildcardType)requiredParameter, (TypeVariable)beanParameter);
        }
        if (Types.isActualType(requiredParameter) && beanParameter instanceof TypeVariable) {
            return this.parametersMatch(requiredParameter, (TypeVariable)beanParameter);
        }
        if (requiredParameter instanceof TypeVariable && beanParameter instanceof TypeVariable) {
            return this.parametersMatch((TypeVariable)requiredParameter, (TypeVariable)beanParameter);
        }
        return false;
    }

    private boolean parametersMatch(WildcardType requiredParameter, Type beanParameter) {
        return this.lowerBoundsOfWildcardMatch(beanParameter, requiredParameter) && this.upperBoundsOfWildcardMatch(requiredParameter, beanParameter);
    }

    protected boolean parametersMatch(WildcardType requiredParameter, TypeVariable<?> beanParameter) {
        Type[] beanParameterBounds = BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(beanParameter);
        if (!this.lowerBoundsOfWildcardMatch(beanParameterBounds, requiredParameter)) {
            return false;
        }
        Type[] requiredUpperBounds = requiredParameter.getUpperBounds();
        return this.boundsMatch(requiredUpperBounds, beanParameterBounds) || this.boundsMatch(beanParameterBounds, requiredUpperBounds);
    }

    private boolean parametersMatch(Type requiredParameter, TypeVariable<?> beanParameter) {
        for (Type bound : BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(beanParameter)) {
            if (CovariantTypes.isAssignableFrom(bound, requiredParameter)) continue;
            return false;
        }
        return true;
    }

    protected boolean parametersMatch(TypeVariable<?> requiredParameter, TypeVariable<?> beanParameter) {
        return this.boundsMatch(BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(beanParameter), BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(requiredParameter));
    }

    static Type[] getUppermostTypeVariableBounds(TypeVariable<?> bound) {
        if (bound.getBounds()[0] instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.getUppermostTypeVariableBounds((TypeVariable)bound.getBounds()[0]);
        }
        return bound.getBounds();
    }

    private Type[] getUppermostBounds(Type[] bounds) {
        if (bounds[0] instanceof TypeVariable) {
            return BeanTypeAssignabilityRules.getUppermostTypeVariableBounds((TypeVariable)bounds[0]);
        }
        return bounds;
    }

    protected boolean boundsMatch(Type[] upperBounds, Type[] stricterUpperBounds) {
        upperBounds = this.getUppermostBounds(upperBounds);
        stricterUpperBounds = this.getUppermostBounds(stricterUpperBounds);
        for (Type upperBound : upperBounds) {
            if (CovariantTypes.isAssignableFromAtLeastOne(upperBound, stricterUpperBounds)) continue;
            return false;
        }
        return true;
    }

    boolean lowerBoundsOfWildcardMatch(Type parameter, WildcardType requiredParameter) {
        return this.lowerBoundsOfWildcardMatch(new Type[]{parameter}, requiredParameter);
    }

    boolean lowerBoundsOfWildcardMatch(Type[] beanParameterBounds, WildcardType requiredParameter) {
        Type[] lowerBounds;
        return requiredParameter.getLowerBounds().length <= 0 || this.boundsMatch(beanParameterBounds, lowerBounds = requiredParameter.getLowerBounds());
    }

    boolean upperBoundsOfWildcardMatch(WildcardType requiredParameter, Type parameter) {
        return this.boundsMatch(requiredParameter.getUpperBounds(), new Type[]{parameter});
    }
}

