/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.util.ResourceLimitsPeriod;

public abstract class LimitedResource {
    private final Instant effectiveSince;
    private final ResourceLimitsPeriod period;

    protected LimitedResource(Instant effectiveSince, ResourceLimitsPeriod period) {
        this.effectiveSince = Objects.requireNonNull(effectiveSince);
        this.period = Optional.ofNullable(period).orElse(ResourceLimitsPeriod.DEFAULT_PERIOD);
    }

    @JsonProperty(value="effective-since")
    @HonoTimestamp
    public final Instant getEffectiveSince() {
        return this.effectiveSince;
    }

    @JsonProperty(value="period")
    public final ResourceLimitsPeriod getPeriod() {
        return this.period;
    }

    public final Duration getElapsedAccountingPeriodDuration(Instant end) {
        return this.period.getElapsedAccountingPeriodDuration(this.effectiveSince, Optional.ofNullable(end).orElse(Instant.now()));
    }
}

