/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

public abstract class StandardHttpClient<C extends HttpClient, F extends HttpClient.Factory, T extends StandardHttpClientBuilder<C, F, ?>>
implements HttpClient {
    protected StandardHttpClientBuilder<C, F, T> builder;

    protected StandardHttpClient(StandardHttpClientBuilder<C, F, T> builder) {
        this.builder = builder;
    }

    public abstract CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder var1, WebSocket.Listener var2);

    public abstract CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest var1, AsyncBody.Consumer<List<ByteBuffer>> var2);

    @Override
    public HttpClient.DerivedClientBuilder newBuilder() {
        return this.builder.copy(this);
    }

    @Override
    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        StandardHttpRequest standardHttpRequest = (StandardHttpRequest)request;
        StandardHttpRequest.Builder copy = standardHttpRequest.newBuilder();
        for (Interceptor interceptor : this.builder.interceptors.values()) {
            ((Interceptor)Interceptor.useConfig(this.builder.requestConfig).apply(interceptor)).before(copy, standardHttpRequest);
            standardHttpRequest = copy.build();
        }
        CompletionStage<HttpResponse<AsyncBody>> cf = this.consumeBytesDirect(standardHttpRequest, consumer);
        for (Interceptor interceptor : this.builder.interceptors.values()) {
            cf = cf.thenCompose(response -> {
                if (!HttpResponse.isSuccessful(response.code())) {
                    return ((Interceptor)Interceptor.useConfig(this.builder.requestConfig).apply(interceptor)).afterFailure(copy, (HttpResponse<?>)response).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            return this.consumeBytesDirect(copy.build(), consumer);
                        }
                        return CompletableFuture.completedFuture(response);
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        return cf;
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return new StandardWebSocketBuilder(this);
    }

    @Override
    public HttpRequest.Builder newHttpRequestBuilder() {
        return new StandardHttpRequest.Builder();
    }

    final CompletableFuture<WebSocket> buildWebSocket(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        StandardWebSocketBuilder copy = standardWebSocketBuilder.newBuilder();
        this.builder.getInterceptors().values().stream().map(Interceptor.useConfig(this.builder.requestConfig)).forEach(i -> i.before(copy, copy.asHttpRequest()));
        CompletionStage<WebSocketResponse> cf = this.buildWebSocketDirect(copy, listener);
        for (Interceptor interceptor : this.builder.getInterceptors().values()) {
            cf = cf.thenCompose(response -> {
                if (response.wshse != null && response.wshse.getResponse() != null) {
                    return ((Interceptor)Interceptor.useConfig(this.builder.requestConfig).apply(interceptor)).afterFailure(copy, response.wshse.getResponse()).thenCompose(b -> {
                        if (Boolean.TRUE.equals(b)) {
                            return this.buildWebSocketDirect(copy, listener);
                        }
                        return CompletableFuture.completedFuture(response);
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        CompletableFuture<WebSocket> result = new CompletableFuture<WebSocket>();
        cf.whenComplete((BiConsumer)StandardHttpClient.onWebSocketComplete(result));
        return result;
    }

    private static BiConsumer<WebSocketResponse, Throwable> onWebSocketComplete(CompletableFuture<WebSocket> result) {
        return (r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else if (r != null) {
                if (r.wshse != null) {
                    result.completeExceptionally(r.wshse);
                } else {
                    result.complete(r.webSocket);
                }
            } else {
                result.complete(null);
            }
        };
    }
}

