/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RBDPersistentVolumeSourceFluentImpl<A extends RBDPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements RBDPersistentVolumeSourceFluent<A> {
    private String fsType;
    private String image;
    private String keyring;
    private List<String> monitors = new ArrayList<String>();
    private String pool;
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private String user;
    private Map<String, Object> additionalProperties;

    public RBDPersistentVolumeSourceFluentImpl() {
    }

    public RBDPersistentVolumeSourceFluentImpl(RBDPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withImage(instance.getImage());
        this.withKeyring(instance.getKeyring());
        this.withMonitors(instance.getMonitors());
        this.withPool(instance.getPool());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getKeyring() {
        return this.keyring;
    }

    @Override
    public A withKeyring(String keyring) {
        this.keyring = keyring;
        return (A)this;
    }

    @Override
    public Boolean hasKeyring() {
        return this.keyring != null;
    }

    @Override
    public A addToMonitors(Integer index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMonitors(Integer index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMonitors(String ... items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public String getMonitor(Integer index) {
        return this.monitors.get(index);
    }

    @Override
    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    @Override
    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    @Override
    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMonitors(List<String> monitors) {
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)this;
    }

    @Override
    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public A withPool(String pool) {
        this.pool = pool;
        return (A)this;
    }

    @Override
    public Boolean hasPool() {
        return this.pool != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RBDPersistentVolumeSourceFluentImpl that = (RBDPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.keyring != null ? !this.keyring.equals(that.keyring) : that.keyring != null) {
            return false;
        }
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.pool != null ? !this.pool.equals(that.pool) : that.pool != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fsType, this.image, this.keyring, this.monitors, this.pool, this.readOnly, this.secretRef, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.keyring != null) {
            sb.append("keyring:");
            sb.append(this.keyring + ",");
        }
        if (this.monitors != null && !this.monitors.isEmpty()) {
            sb.append("monitors:");
            sb.append(this.monitors + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<RBDPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements RBDPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RBDPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

