/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceFluentImpl;

public class NamespaceBuilder
extends NamespaceFluentImpl<NamespaceBuilder>
implements VisitableBuilder<Namespace, NamespaceBuilder> {
    NamespaceFluent<?> fluent;
    Boolean validationEnabled;

    public NamespaceBuilder() {
        this(false);
    }

    public NamespaceBuilder(Boolean validationEnabled) {
        this(new Namespace(), validationEnabled);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Namespace(), validationEnabled);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent, Namespace instance) {
        this(fluent, instance, false);
    }

    public NamespaceBuilder(NamespaceFluent<?> fluent, Namespace instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NamespaceBuilder(Namespace instance) {
        this(instance, (Boolean)false);
    }

    public NamespaceBuilder(Namespace instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Namespace build() {
        Namespace buildable = new Namespace(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

