/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.app;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.MessageContext;
import org.eclipse.hono.cli.app.Receiver;
import org.eclipse.hono.cli.app.ReceiverStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"statistic"})
public class ReceiverStatistics {
    private static final Logger LOG_STATISTIC = LoggerFactory.getLogger(ReceiverStatistics.class);
    private static final long INTERVAL_MILLIS = 10000L;
    @Value(value="${statistic.interval}")
    protected long interval = 10000L;
    @Value(value="${statistic.autoreset}")
    protected boolean autoReset;
    private final Receiver receiver;
    private final Vertx vertx;
    private Statistic total;
    private Statistic current;

    @Autowired
    public ReceiverStatistics(Receiver receiver, Vertx vertx) {
        this.receiver = Objects.requireNonNull(receiver);
        this.vertx = Objects.requireNonNull(vertx);
    }

    @PostConstruct
    Future<CompositeFuture> start() {
        this.vertx.setPeriodic(this.interval, arg_0 -> this.statistic(arg_0));
        this.receiver.setMessageHandler((endpoint, msg) -> this.handleMessage(endpoint, msg));
        LOG_STATISTIC.info("Statistics [interval: {} ms, autoreset: {}]", (Object)this.interval, (Object)this.autoReset);
        return Future.succeededFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(String endpoint, DownstreamMessage<? extends MessageContext> msg) {
        String deviceId = msg.getDeviceId();
        Buffer payload = msg.getPayload();
        if (LOG_STATISTIC.isInfoEnabled()) {
            Statistic current;
            Statistic total;
            long now = System.nanoTime();
            ReceiverStatistics receiverStatistics = this;
            synchronized (receiverStatistics) {
                if (this.total == null) {
                    this.total = new Statistic(now);
                }
                total = this.total;
                if (this.current == null) {
                    this.current = new PeriodStatistic(now, this.interval);
                }
                current = this.current;
            }
            total.increment(now);
            if (!current.increment(now)) {
                if (current.isPrinting()) {
                    LOG_STATISTIC.info("statistic: total {}, last {}", (Object)total, (Object)current);
                }
                receiverStatistics = this;
                synchronized (receiverStatistics) {
                    if (this.current == current) {
                        this.current = new PeriodStatistic(now, this.interval);
                    }
                    current = this.current;
                }
                current.increment(now);
            }
        }
        LOG_STATISTIC.trace("received {} message [device: {}, content-type: {}]: {}", new Object[]{endpoint, deviceId, msg.getContentType(), payload});
        LOG_STATISTIC.trace("... with properties: {}", (Object)msg.getProperties().getPropertiesMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statistic(Long id) {
        Statistic current;
        Statistic total;
        ReceiverStatistics receiverStatistics = this;
        synchronized (receiverStatistics) {
            total = this.total;
            current = this.current;
        }
        if (total != null) {
            long now = System.nanoTime();
            if (current == null || current.finished(now)) {
                if (current == null) {
                    LOG_STATISTIC.info("statistic: total {}", (Object)total);
                } else {
                    LOG_STATISTIC.info("statistic: total {}, last {}", (Object)total, (Object)current);
                }
                ReceiverStatistics receiverStatistics2 = this;
                synchronized (receiverStatistics2) {
                    if (this.total == total && this.current == current) {
                        if (current == null) {
                            if (this.autoReset) {
                                this.total = null;
                            }
                        } else {
                            this.current = null;
                        }
                    }
                }
            }
        }
    }
}

