/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.contextful;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.contextful.AllOf;
import org.eclipse.hawk.epsilon.emc.contextful.MemoizedSupplier;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;

public class DerivedAllOf
implements AllOf {
    private static final String DEDGE_PREFIX = "allof_";
    private final IModelIndexer indexer;
    private final EOLQueryEngine engine;
    private final List<String> rplist;
    private final String subtreeRootPath;
    private final MemoizedSupplier<Set<ModelElementNode>> roots = new MemoizedSupplier<Set>(this::computeRoots);

    public DerivedAllOf(IModelIndexer indexer, EOLQueryEngine engine, List<String> rplist, String subtreeRootPath) {
        this.rplist = rplist;
        this.subtreeRootPath = subtreeRootPath;
        this.indexer = indexer;
        this.engine = engine;
    }

    @Override
    public void addAllOf(IGraphNode typeNode, String typeorkind, Collection<Object> nodes) {
        TypeNode tn = new TypeNode(typeNode);
        String dedgeName = DEDGE_PREFIX + tn.getTypeName();
        Slot slot = tn.getSlot(dedgeName);
        if (slot == null) {
            boolean isMany = true;
            boolean isOrdered = false;
            boolean isUnique = true;
            this.indexer.addDerivedAttribute(tn.getMetamodelURI(), tn.getTypeName(), dedgeName, tn.getTypeName(), true, false, true, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.closure(e|e.eContainers);");
        }
        for (ModelElementNode root : this.roots.get()) {
            for (IGraphEdge e : root.getNode().getIncomingWithType("de" + dedgeName)) {
                IGraphNode derivedFeatureNode = e.getStartNode();
                IGraphNode sourceElementNode = ((IGraphEdge)derivedFeatureNode.getIncoming().iterator().next()).getStartNode();
                nodes.add(this.engine.wrap(sourceElementNode));
            }
        }
    }

    private Set<ModelElementNode> computeRoots() {
        GraphWrapper gw = new GraphWrapper(this.indexer.getGraph());
        Set allRootFileNodes = gw.getFileNodes(this.rplist, Collections.singletonList(this.subtreeRootPath));
        HashSet<ModelElementNode> rootNodes = new HashSet<ModelElementNode>();
        for (FileNode fn : allRootFileNodes) {
            Iterator itElems = fn.getModelElements().iterator();
            if (!itElems.hasNext()) continue;
            ModelElementNode first = (ModelElementNode)itElems.next();
            rootNodes.add(first.getLocalRoot());
        }
        return rootNodes;
    }
}

