/*
 * Decompiled with CFR 0.152.
 */
package com.github.peterwippermann.junit4.parameterizedsuite;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterContext;
import com.github.peterwippermann.junit4.parameterizedsuite.SuiteForSingleParameter;
import com.github.peterwippermann.junit4.parameterizedsuite.parameter.Parameter;
import com.github.peterwippermann.junit4.parameterizedsuite.util.BlockJUnit4ClassRunnerWithParametersUtil;
import com.github.peterwippermann.junit4.parameterizedsuite.util.ParameterizedUtil;
import com.github.peterwippermann.junit4.parameterizedsuite.util.SuiteUtil;
import java.util.LinkedList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;

public class ParameterizedSuite
extends ParentRunner<Runner> {
    public static final Class<Object[]> PARAMETER_TYPE = Object[].class;
    private final List<Runner> runners;
    private final Object[] currentlyActiveParameter;
    private final Mode mode;

    public ParameterizedSuite(Class<?> suiteTestClass, RunnerBuilder runnerBuilder) throws Throwable {
        super(suiteTestClass);
        Class<?>[] childTestClasses = SuiteUtil.getSuiteClasses(suiteTestClass);
        this.mode = ParameterizedSuite.determineRuntimeMode();
        if (Mode.ROOT.equals((Object)this.mode)) {
            Iterable<Object> parametersOfSuiteClass = ParameterizedUtil.getParameters(this.getTestClass());
            String parametersNamePattern = ParameterizedUtil.getNamePatternForParameters(this.getTestClass());
            this.currentlyActiveParameter = null;
            this.runners = this.createSuiteRunnersPerParameter(suiteTestClass, runnerBuilder, childTestClasses, parametersOfSuiteClass, parametersNamePattern);
        } else {
            this.currentlyActiveParameter = ParameterContext.getParameterAsArray();
            this.runners = this.createRunnersForChildTestClasses(suiteTestClass, runnerBuilder, childTestClasses);
        }
    }

    private static Mode determineRuntimeMode() {
        if (ParameterContext.isParameterSet()) {
            return Mode.NESTED;
        }
        return Mode.ROOT;
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statementWithChildren = this.childrenInvoker(notifier);
        if (Mode.ROOT.equals((Object)this.mode)) {
            return statementWithChildren;
        }
        return BlockJUnit4ClassRunnerWithParametersUtil.buildStatementWithTestRules(statementWithChildren, this.getTestClass(), this.getDescription(), this.getCurrentlyActiveParameter());
    }

    protected Object[] getCurrentlyActiveParameter() {
        return this.currentlyActiveParameter;
    }

    protected List<Runner> createRunnersForChildTestClasses(Class<?> suiteTestClass, RunnerBuilder runnerBuilder, Class<?>[] suiteChildClasses) throws InitializationError {
        return runnerBuilder.runners(suiteTestClass, (Class[])suiteChildClasses);
    }

    protected List<Runner> createSuiteRunnersPerParameter(Class<?> suiteTestClass, RunnerBuilder runnerBuilder, Class<?>[] suiteChildClasses, Iterable<Object> parameters, String parametersNamePattern) throws InitializationError {
        LinkedList<Runner> runners = new LinkedList<Runner>();
        int parameterIndex = 0;
        for (Object singleParameterRaw : parameters) {
            Parameter parameter = Parameter.from(singleParameterRaw);
            String nameForSingleParameterSuite = ParameterizedUtil.buildTestName(parametersNamePattern, parameterIndex++, parameter.asNormalized());
            runners.add((Runner)this.setContextAndBuildSuiteForSingleParameter(suiteTestClass, runnerBuilder, suiteChildClasses, parameter, nameForSingleParameterSuite));
        }
        return runners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuiteForSingleParameter setContextAndBuildSuiteForSingleParameter(Class<?> suiteTestClass, RunnerBuilder runnerBuilder, Class<?>[] suiteChildClasses, Parameter parameter, String suiteName) throws InitializationError {
        try {
            ParameterContext.setParameter(parameter);
            SuiteForSingleParameter suiteForSingleParameter = new SuiteForSingleParameter(runnerBuilder, suiteTestClass, suiteChildClasses, suiteName, parameter.asNormalized());
            return suiteForSingleParameter;
        }
        finally {
            ParameterContext.removeParameter();
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        runner.run(notifier);
    }

    private static enum Mode {
        ROOT,
        NESTED;

    }
}

