/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.query.IAccessListener;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineEOLQueryEngine
implements IQueryEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimelineEOLQueryEngine.class);
    private String defaultNamespaces;

    public IAccessListener calculateDerivedAttributes(IModelIndexer m, Iterable<IGraphNode> nodes) throws InvalidQueryException, QueryExecutionException {
        throw new QueryExecutionException("Derived attributes are not supported by this engine");
    }

    public List<String> validate(String derivationlogic) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TimeAwareEOLQueryEngine qEngine = new TimeAwareEOLQueryEngine();){
            return qEngine.validate(derivationlogic);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setDefaultNamespaces(String defaultNamespaces) {
        this.defaultNamespaces = defaultNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(IModelIndexer m, String query, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        IStateListener.HawkState currentState = m.getCompositeStateListener().getCurrentState();
        if (currentState != IStateListener.HawkState.RUNNING) {
            throw new QueryExecutionException(String.format("Cannot run the query, as the indexer is not in the RUNNING state: it is %s instead.", currentState));
        }
        if (!(m.getGraph() instanceof ITimeAwareGraphDatabase)) {
            throw new QueryExecutionException(String.valueOf(this.getClass().getName()) + " can only be used with time-aware databases");
        }
        ITimeAwareGraphDatabase taDB = (ITimeAwareGraphDatabase)m.getGraph();
        if (this.defaultNamespaces != null) {
            if (context == null) {
                context = new HashMap<String, Object>();
            }
            if (!context.containsKey("DEFAULTNAMESPACES")) {
                context.put("DEFAULTNAMESPACES", this.defaultNamespaces);
            }
        }
        TreeSet instants = new TreeSet();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (IGraphTransaction tx = taDB.beginTransaction();){
                GraphWrapper gW = new GraphWrapper((IGraphDatabase)taDB);
                for (MetamodelNode mm : gW.getMetamodelNodes()) {
                    for (TypeNode tn : mm.getTypes()) {
                        ITimeAwareGraphNode taTypeNode = (ITimeAwareGraphNode)tn.getNode();
                        instants.addAll(taTypeNode.getAllInstants());
                    }
                }
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new QueryExecutionException((Throwable)e);
        }
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        try {
            int executed = 0;
            Iterator iterator = instants.iterator();
            while (iterator.hasNext()) {
                long instant = (Long)iterator.next();
                if (executed % 10 == 0) {
                    LOGGER.info("Ran {}/{} instants", (Object)executed, (Object)instants.size());
                }
                ++executed;
                ITimeAwareGraphDatabase iTimeAwareGraphDatabase = taDB;
                synchronized (iTimeAwareGraphDatabase) {
                    taDB.setTime(instant);
                    TimeAwareEOLQueryEngine q = new TimeAwareEOLQueryEngine();
                    Object result = q.query(m, query, context);
                    results.add(Arrays.asList(instant, result));
                }
            }
        }
        catch (Throwable throwable) {
            ITimeAwareGraphDatabase iTimeAwareGraphDatabase = taDB;
            synchronized (iTimeAwareGraphDatabase) {
                taDB.setTime(0L);
            }
            throw throwable;
        }
        ITimeAwareGraphDatabase iTimeAwareGraphDatabase = taDB;
        synchronized (iTimeAwareGraphDatabase) {
            taDB.setTime(0L);
        }
        return results;
    }

    public String getHumanReadableName() {
        return "Timeline EOL query engine";
    }
}

