/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.queries;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.hawk.sqlite.queries.IQueries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareQueries
implements IQueries {
    public static final String TYPE_BLOB_BASE64 = "blobBase64";
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareQueries.class);
    private final Connection connection;
    private final Supplier<Long> defaultTimeProvider;
    private PreparedStatement stmtInsertNode;
    private PreparedStatement stmtDeleteNode;
    private PreparedStatement stmtNodeIDsByLabel;
    private PreparedStatement stmtNodeCountByLabel;
    private PreparedStatement stmtFirstNodeIDByLabel;
    private PreparedStatement stmtNodePropKeys;
    private PreparedStatement stmtNodePropValue;
    private PreparedStatement stmtUpsertNodeProp;
    private PreparedStatement stmtDeleteNodeProp;
    private PreparedStatement stmtDeleteNodeProps;
    private PreparedStatement stmtInsertEdge;
    private PreparedStatement stmtDeleteEdge;
    private PreparedStatement stmtOutgoingEdgesWithType;
    private PreparedStatement stmtOutgoingEdgesWithTypeAndNode;
    private PreparedStatement stmtOutgoingEdges;
    private PreparedStatement stmtIncomingEdgesWithType;
    private PreparedStatement stmtIncomingEdges;
    private PreparedStatement stmtEdges;
    private PreparedStatement stmtEdgesWithType;
    private PreparedStatement stmtEdgePropKeys;
    private PreparedStatement stmtEdgePropValue;
    private PreparedStatement stmtUpsertEdgeProp;
    private PreparedStatement stmtDeleteEdgeProp;
    private PreparedStatement stmtDeleteEdgeProps;
    private PreparedStatement stmtDeleteEdgePropsForNode;
    private PreparedStatement stmtDeleteEdgesForNode;
    private PreparedStatement stmtAllInstantsForNode;
    private PreparedStatement stmtNextInstant;
    private PreparedStatement stmtLatestInstant;
    private PreparedStatement stmtPrevInstant;
    private PreparedStatement stmtEarliestInstant;
    private PreparedStatement stmtInstantsBetween;
    private PreparedStatement stmtInstantsFrom;
    private PreparedStatement stmtInstantsUpTo;
    private PreparedStatement stmtIsAlive;
    private PreparedStatement stmtOutgoingEdgesWithTypeBetween;
    private PreparedStatement stmtIncomingEdgesWithTypeBetween;
    private PreparedStatement stmtOutgoingEdgesWithTypeCreatedBetween;
    private PreparedStatement stmtIncomingEdgesWithTypeCreatedBetween;
    private PreparedStatement stmtUpsertNodeIndex;
    private PreparedStatement stmtDeleteNodeIndex;
    private PreparedStatement stmtAllNodeIndices;
    private Map<String, PreparedStatement> stmtAddNodeIndexEntry = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtAnnotateNodeIndexEntry = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeIndexEntry = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeFromIndex = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeFieldFromIndex = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtRemoveNodeValueFromIndex = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValuePattern = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValuePatternCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValuePatternSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueExact = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueExactCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueExactSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllValues = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllValuesCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllValuesSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllPairs = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllPairsCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexValueAllPairsSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexNumberRange = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexNumberRangeCount = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtQueryIndexNumberRangeSingle = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtIndexVersions = new HashMap<String, PreparedStatement>();
    private Map<String, PreparedStatement> stmtIndexEarliestVersionSince = new HashMap<String, PreparedStatement>();

    public TimeAwareQueries(Connection connection, Supplier<Long> defaultTimeProvider) {
        this.connection = connection;
        this.defaultTimeProvider = defaultTimeProvider;
    }

    public PreparedStatement getInsertNodeStatement(String label, long time) throws SQLException {
        if (this.stmtInsertNode == null) {
            this.stmtInsertNode = this.connection.prepareStatement("INSERT INTO nodes (label, validFrom) VALUES (?, ?);");
        }
        this.stmtInsertNode.setString(1, label);
        this.stmtInsertNode.setLong(2, time);
        return this.stmtInsertNode;
    }

    @Override
    public PreparedStatement getInsertNodeStatement(String label) throws SQLException {
        return this.getInsertNodeStatement(label, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteNodeStatement(int id, long time) throws SQLException {
        if (this.stmtDeleteNode == null) {
            this.stmtDeleteNode = this.connection.prepareStatement("UPDATE nodes SET validTo = ? WHERE rowid = ? AND validTo IS NULL;");
        }
        this.stmtDeleteNode.setLong(1, time);
        this.stmtDeleteNode.setInt(2, id);
        return this.stmtDeleteNode;
    }

    @Override
    public PreparedStatement getDeleteNodeStatement(int id) throws SQLException {
        return this.getDeleteNodeStatement(id, this.defaultTimeProvider.get());
    }

    public PreparedStatement getNodeIDsByLabelStatement(String label, long time) throws SQLException {
        if (this.stmtNodeIDsByLabel == null) {
            this.stmtNodeIDsByLabel = this.connection.prepareStatement("SELECT rowid FROM nodes WHERE label = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtNodeIDsByLabel.setString(1, label);
        this.stmtNodeIDsByLabel.setLong(2, time);
        this.stmtNodeIDsByLabel.setLong(3, time);
        return this.stmtNodeIDsByLabel;
    }

    @Override
    public PreparedStatement getNodeIDsByLabelStatement(String label) throws SQLException {
        return this.getNodeIDsByLabelStatement(label, this.defaultTimeProvider.get());
    }

    public PreparedStatement getNodeCountByLabelStatement(String label, long time) throws SQLException {
        if (this.stmtNodeCountByLabel == null) {
            this.stmtNodeCountByLabel = this.connection.prepareStatement("SELECT COUNT(1) FROM nodes WHERE label = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtNodeCountByLabel.setString(1, label);
        this.stmtNodeCountByLabel.setLong(2, time);
        this.stmtNodeCountByLabel.setLong(3, time);
        return this.stmtNodeCountByLabel;
    }

    @Override
    public PreparedStatement getNodeCountByLabelStatement(String label) throws SQLException {
        return this.getNodeCountByLabelStatement(label, this.defaultTimeProvider.get());
    }

    public PreparedStatement getFirstNodeIDByLabelStatement(String label, long time) throws SQLException {
        if (this.stmtFirstNodeIDByLabel == null) {
            this.stmtFirstNodeIDByLabel = this.connection.prepareStatement("SELECT rowid FROM nodes WHERE label = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?) LIMIT 1;");
        }
        this.stmtFirstNodeIDByLabel.setString(1, label);
        this.stmtFirstNodeIDByLabel.setLong(2, time);
        this.stmtFirstNodeIDByLabel.setLong(3, time);
        return this.stmtFirstNodeIDByLabel;
    }

    @Override
    public PreparedStatement getFirstNodeIDByLabelStatement(String label) throws SQLException {
        return this.getFirstNodeIDByLabelStatement(label, this.defaultTimeProvider.get());
    }

    public PreparedStatement getNodePropKeysStatement(int id, long time) throws SQLException {
        if (this.stmtNodePropKeys == null) {
            this.stmtNodePropKeys = this.connection.prepareStatement("SELECT DISTINCT key FROM ( SELECT nodeid, key, max(validAt) AS validAt FROM nodeprops WHERE nodeid = ? AND validAt <= ? GROUP BY nodeid, key ) JOIN nodeprops USING (nodeid, key, validAt) WHERE value IS NOT NULL;");
        }
        this.stmtNodePropKeys.setInt(1, id);
        this.stmtNodePropKeys.setLong(2, time);
        return this.stmtNodePropKeys;
    }

    @Override
    public PreparedStatement getNodePropKeysStatement(int id) throws SQLException {
        return this.getNodePropKeysStatement(id, this.defaultTimeProvider.get());
    }

    public PreparedStatement getNodePropValueStatement(int id, String name, long time) throws SQLException {
        if (this.stmtNodePropValue == null) {
            this.stmtNodePropValue = this.connection.prepareStatement("SELECT type, value FROM nodeprops WHERE nodeid = ? AND key = ? AND validAt <= ? ORDER BY validAt DESC LIMIT 1;");
        }
        this.stmtNodePropValue.setInt(1, id);
        this.stmtNodePropValue.setString(2, name);
        this.stmtNodePropValue.setLong(3, time);
        return this.stmtNodePropValue;
    }

    @Override
    public PreparedStatement getNodePropValueStatement(int id, String name) throws SQLException {
        return this.getNodePropValueStatement(id, name, this.defaultTimeProvider.get());
    }

    public PreparedStatement getUpsertNodePropStatement(int id, String key, Object value, long time) throws SQLException, IOException {
        if (this.stmtUpsertNodeProp == null) {
            this.stmtUpsertNodeProp = this.connection.prepareStatement("INSERT OR REPLACE INTO nodeprops (nodeid, key, type, value, validAt) VALUES (?, ?, ?, ?, ?);");
        }
        this.stmtUpsertNodeProp.setInt(1, id);
        this.stmtUpsertNodeProp.setString(2, key);
        this.stmtUpsertNodeProp.setString(3, this.getPropertyType(value));
        if (value instanceof Blob) {
            String value_base64 = this.base64(value);
            this.stmtUpsertNodeProp.setString(4, value_base64);
        } else {
            this.stmtUpsertNodeProp.setObject(4, value);
        }
        this.stmtUpsertNodeProp.setLong(5, time);
        return this.stmtUpsertNodeProp;
    }

    @Override
    public PreparedStatement getUpsertNodePropStatement(int id, String key, Object value) throws SQLException, IOException {
        return this.getUpsertNodePropStatement(id, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteNodePropStatement(int id, String name, long time) throws SQLException {
        if (this.stmtDeleteNodeProp == null) {
            this.stmtDeleteNodeProp = this.connection.prepareStatement("INSERT OR REPLACE INTO nodeprops (nodeid, key, type, value, validAt) SELECT ?, ?, 'deleted', NULL, ? WHERE EXISTS ( SELECT 1 FROM nodeprops WHERE nodeid = ? AND key = ? AND validAt = ( SELECT MAX(validAt) FROM nodeprops WHERE nodeid = ? AND key = ? AND validAt <= ? ) AND value IS NOT NULL );");
        }
        this.stmtDeleteNodeProp.setInt(1, id);
        this.stmtDeleteNodeProp.setInt(4, id);
        this.stmtDeleteNodeProp.setInt(6, id);
        this.stmtDeleteNodeProp.setString(2, name);
        this.stmtDeleteNodeProp.setString(5, name);
        this.stmtDeleteNodeProp.setString(7, name);
        this.stmtDeleteNodeProp.setLong(3, time);
        this.stmtDeleteNodeProp.setLong(8, time);
        return this.stmtDeleteNodeProp;
    }

    @Override
    public PreparedStatement getDeleteNodePropStatement(int id, String name) throws SQLException {
        return this.getDeleteNodePropStatement(id, name, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteNodePropsStatement(int id, long time) throws SQLException {
        if (this.stmtDeleteNodeProps == null) {
            this.stmtDeleteNodeProps = this.connection.prepareStatement("INSERT OR REPLACE INTO nodeprops (nodeid, key, type, value, validAt) SELECT p.nodeid, p.key, 'deleted', NULL, ? FROM (SELECT nodeid, key, max(validAt) AS validAt FROM nodeprops WHERE nodeid = ? AND validAt <= ? GROUP BY nodeid, key) JOIN nodeprops p USING (nodeid, key, validAt) WHERE p.value IS NOT NULL;");
        }
        this.stmtDeleteNodeProps.setLong(1, time);
        this.stmtDeleteNodeProps.setInt(2, id);
        this.stmtDeleteNodeProps.setLong(3, time);
        return this.stmtDeleteNodeProps;
    }

    @Override
    public PreparedStatement getDeleteNodePropsStatement(int id) throws SQLException {
        return this.getDeleteNodePropsStatement(id, this.defaultTimeProvider.get());
    }

    public PreparedStatement getInsertEdgeStatement(int startID, int endID, String label, long time) throws SQLException {
        if (this.stmtInsertEdge == null) {
            this.stmtInsertEdge = this.connection.prepareStatement("INSERT OR REPLACE INTO edges (startId, endId, label, validFrom, validTo) VALUES (?, ?, ?, ?, NULL) ON CONFLICT DO UPDATE SET validTo = NULL;");
        }
        this.stmtInsertEdge.setInt(1, startID);
        this.stmtInsertEdge.setInt(2, endID);
        this.stmtInsertEdge.setString(3, label);
        this.stmtInsertEdge.setLong(4, time);
        return this.stmtInsertEdge;
    }

    @Override
    public PreparedStatement getInsertEdgeStatement(int startID, int endID, String label) throws SQLException {
        return this.getInsertEdgeStatement(startID, endID, label, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteEdgeStatement(int id, long time) throws SQLException {
        if (this.stmtDeleteEdge == null) {
            this.stmtDeleteEdge = this.connection.prepareStatement("UPDATE edges SET validTo = ? WHERE rowid = ? AND validTo IS NULL;");
        }
        this.stmtDeleteEdge.setLong(1, time);
        this.stmtDeleteEdge.setInt(2, id);
        return this.stmtDeleteEdge;
    }

    @Override
    public PreparedStatement getDeleteEdgeStatement(int id) throws SQLException {
        return this.getDeleteEdgeStatement(id, this.defaultTimeProvider.get());
    }

    public PreparedStatement getOutgoingEdgesWithTypeStatement(String type, int fromID, long time) throws SQLException {
        if (this.stmtOutgoingEdgesWithType == null) {
            this.stmtOutgoingEdgesWithType = this.connection.prepareStatement("SELECT rowid, endId FROM edges WHERE label = ? AND startId = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtOutgoingEdgesWithType.setString(1, type);
        this.stmtOutgoingEdgesWithType.setInt(2, fromID);
        this.stmtOutgoingEdgesWithType.setLong(3, time);
        this.stmtOutgoingEdgesWithType.setLong(4, time);
        return this.stmtOutgoingEdgesWithType;
    }

    @Override
    public PreparedStatement getOutgoingEdgesWithTypeStatement(String type, int fromID) throws SQLException {
        return this.getOutgoingEdgesWithTypeStatement(type, fromID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getOutgoingEdgesWithTypeAndNodeStatement(String type, int fromID, int toID, long time) throws SQLException {
        if (this.stmtOutgoingEdgesWithTypeAndNode == null) {
            this.stmtOutgoingEdgesWithTypeAndNode = this.connection.prepareStatement("SELECT rowid, endId FROM edges WHERE label = ? AND startId = ? AND endId = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtOutgoingEdgesWithTypeAndNode.setString(1, type);
        this.stmtOutgoingEdgesWithTypeAndNode.setInt(2, fromID);
        this.stmtOutgoingEdgesWithTypeAndNode.setInt(3, toID);
        this.stmtOutgoingEdgesWithTypeAndNode.setLong(4, time);
        this.stmtOutgoingEdgesWithTypeAndNode.setLong(5, time);
        return this.stmtOutgoingEdgesWithTypeAndNode;
    }

    @Override
    public PreparedStatement getOutgoingEdgesWithTypeAndNodeStatement(String type, int fromID, int toID) throws SQLException {
        return this.getOutgoingEdgesWithTypeAndNodeStatement(type, fromID, toID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getOutgoingEdgesStatement(int fromID, long time) throws SQLException {
        if (this.stmtOutgoingEdges == null) {
            this.stmtOutgoingEdges = this.connection.prepareStatement("SELECT rowid, endId, label FROM edges WHERE startId = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtOutgoingEdges.setInt(1, fromID);
        this.stmtOutgoingEdges.setLong(2, time);
        this.stmtOutgoingEdges.setLong(3, time);
        return this.stmtOutgoingEdges;
    }

    @Override
    public PreparedStatement getOutgoingEdgesStatement(int fromID) throws SQLException {
        return this.getOutgoingEdgesStatement(fromID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getIncomingEdgesWithTypeStatement(String type, int toID, long time) throws SQLException {
        if (this.stmtIncomingEdgesWithType == null) {
            this.stmtIncomingEdgesWithType = this.connection.prepareStatement("SELECT rowid, startId FROM edges WHERE label = ? AND endId = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtIncomingEdgesWithType.setString(1, type);
        this.stmtIncomingEdgesWithType.setInt(2, toID);
        this.stmtIncomingEdgesWithType.setLong(3, time);
        this.stmtIncomingEdgesWithType.setLong(4, time);
        return this.stmtIncomingEdgesWithType;
    }

    @Override
    public PreparedStatement getIncomingEdgesWithTypeStatement(String type, int toID) throws SQLException {
        return this.getIncomingEdgesWithTypeStatement(type, toID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getIncomingEdgesStatement(int toID, long time) throws SQLException {
        if (this.stmtIncomingEdges == null) {
            this.stmtIncomingEdges = this.connection.prepareStatement("SELECT rowid, startId, label FROM edges WHERE endId = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtIncomingEdges.setInt(1, toID);
        this.stmtIncomingEdges.setLong(2, time);
        this.stmtIncomingEdges.setLong(3, time);
        return this.stmtIncomingEdges;
    }

    @Override
    public PreparedStatement getIncomingEdgesStatement(int toID) throws SQLException {
        return this.getIncomingEdgesStatement(toID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getEdgesStatement(int startOrEndID, long time) throws SQLException {
        if (this.stmtEdges == null) {
            this.stmtEdges = this.connection.prepareStatement("SELECT rowid, startId, endId, label FROM edges WHERE (startId = ? OR endId = ?) AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtEdges.setInt(1, startOrEndID);
        this.stmtEdges.setInt(2, startOrEndID);
        this.stmtEdges.setLong(3, time);
        this.stmtEdges.setLong(4, time);
        return this.stmtEdges;
    }

    @Override
    public PreparedStatement getEdgesStatement(int startOrEndID) throws SQLException {
        return this.getEdgesStatement(startOrEndID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getEdgesWithTypeStatement(String type, int startOrEndID, long time) throws SQLException {
        if (this.stmtEdgesWithType == null) {
            this.stmtEdgesWithType = this.connection.prepareStatement("SELECT rowid, startId, endid FROM edges WHERE label = ? AND (startId = ? OR endId = ?) AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);");
        }
        this.stmtEdgesWithType.setString(1, type);
        this.stmtEdgesWithType.setInt(2, startOrEndID);
        this.stmtEdgesWithType.setInt(3, startOrEndID);
        this.stmtEdgesWithType.setLong(4, time);
        this.stmtEdgesWithType.setLong(5, time);
        return this.stmtEdgesWithType;
    }

    @Override
    public PreparedStatement getEdgesWithTypeStatement(String type, int startOrEndID) throws SQLException {
        return this.getEdgesWithTypeStatement(type, startOrEndID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getEdgePropKeysStatement(int id, long time) throws SQLException {
        if (this.stmtEdgePropKeys == null) {
            this.stmtEdgePropKeys = this.connection.prepareStatement("SELECT DISTINCT key FROM ( SELECT edgeid, key, max(validAt) AS validAt FROM edgeprops WHERE edgeid = ? AND validAt <= ? GROUP BY edgeid, key ) JOIN edgeprops USING (edgeid, key, validAt) WHERE value IS NOT NULL;");
        }
        this.stmtEdgePropKeys.setInt(1, id);
        this.stmtEdgePropKeys.setLong(2, time);
        return this.stmtEdgePropKeys;
    }

    @Override
    public PreparedStatement getEdgePropKeysStatement(int id) throws SQLException {
        return this.getEdgePropKeysStatement(id, this.defaultTimeProvider.get());
    }

    public PreparedStatement getEdgePropValueStatement(int id, String name, long time) throws SQLException {
        if (this.stmtEdgePropValue == null) {
            this.stmtEdgePropValue = this.connection.prepareStatement("SELECT type, value FROM edgeprops WHERE edgeid = ? AND key = ? AND validAt <= ? ORDER BY validAt DESC LIMIT 1;");
        }
        this.stmtEdgePropValue.setInt(1, id);
        this.stmtEdgePropValue.setString(2, name);
        this.stmtEdgePropValue.setLong(3, time);
        return this.stmtEdgePropValue;
    }

    @Override
    public PreparedStatement getEdgePropValueStatement(int id, String name) throws SQLException {
        return this.getEdgePropValueStatement(id, name, this.defaultTimeProvider.get());
    }

    public PreparedStatement getUpsertEdgePropStatement(int id, String key, Object value, long time) throws SQLException, IOException {
        if (this.stmtUpsertEdgeProp == null) {
            this.stmtUpsertEdgeProp = this.connection.prepareStatement("INSERT OR REPLACE INTO edgeprops (edgeid, key, type, value, validAt) VALUES (?, ?, ?, ?, ?);");
        }
        this.stmtUpsertEdgeProp.setInt(1, id);
        this.stmtUpsertEdgeProp.setString(2, key);
        this.stmtUpsertEdgeProp.setString(3, this.getPropertyType(value));
        if (value instanceof Blob) {
            String value_base64 = this.base64(value);
            this.stmtUpsertEdgeProp.setString(4, value_base64);
        } else {
            this.stmtUpsertEdgeProp.setObject(4, value);
        }
        this.stmtUpsertEdgeProp.setLong(5, time);
        return this.stmtUpsertEdgeProp;
    }

    @Override
    public PreparedStatement getUpsertEdgePropStatement(int id, String key, Object value) throws SQLException, IOException {
        return this.getUpsertEdgePropStatement(id, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteEdgePropStatement(int id, String name, long time) throws SQLException {
        if (this.stmtDeleteEdgeProp == null) {
            this.stmtDeleteEdgeProp = this.connection.prepareStatement("INSERT OR REPLACE INTO edgeprops (edgeid, key, type, value, validAt) SELECT ?, ?, 'deleted', NULL, ? WHERE EXISTS ( SELECT 1 FROM edgeprops WHERE edgeid = ? AND key = ? AND validAt = ( SELECT MAX(validAt) FROM edgeprops WHERE edgeid = ? AND key = ? AND validAt <= ? ) AND value IS NOT NULL );");
        }
        this.stmtDeleteEdgeProp.setInt(1, id);
        this.stmtDeleteEdgeProp.setInt(4, id);
        this.stmtDeleteEdgeProp.setInt(6, id);
        this.stmtDeleteEdgeProp.setString(2, name);
        this.stmtDeleteEdgeProp.setString(5, name);
        this.stmtDeleteEdgeProp.setString(7, name);
        this.stmtDeleteEdgeProp.setLong(3, time);
        this.stmtDeleteEdgeProp.setLong(8, time);
        return this.stmtDeleteEdgeProp;
    }

    @Override
    public PreparedStatement getDeleteEdgePropStatement(int id, String name) throws SQLException {
        return this.getDeleteEdgePropStatement(id, name, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteEdgePropsStatement(int id, long time) throws SQLException {
        if (this.stmtDeleteEdgeProps == null) {
            this.stmtDeleteEdgeProps = this.connection.prepareStatement("INSERT OR REPLACE INTO edgeprops (edgeid, key, type, value, validAt) SELECT p.edgeid, p.key, 'deleted', NULL, ? FROM (SELECT edgeid, key, max(validAt) AS validAt FROM edgeprops WHERE edgeid = ? AND validAt <= ? GROUP BY edgeid, key) JOIN edgeprops p USING (edgeid, key, validAt) WHERE p.value IS NOT NULL;");
        }
        this.stmtDeleteEdgeProps.setLong(1, time);
        this.stmtDeleteEdgeProps.setInt(2, id);
        this.stmtDeleteEdgeProps.setLong(3, time);
        return this.stmtDeleteEdgeProps;
    }

    @Override
    public PreparedStatement getDeleteEdgePropsStatement(int id) throws SQLException {
        return this.getDeleteEdgePropsStatement(id, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteEdgePropsForNodeStatement(int nodeID, long time) throws SQLException {
        if (this.stmtDeleteEdgePropsForNode == null) {
            this.stmtDeleteEdgePropsForNode = this.connection.prepareStatement("INSERT OR REPLACE INTO edgeprops (edgeid, key, type, value, validAt) SELECT p.edgeid, p.key, 'deleted', NULL, ? FROM (SELECT edgeid, key, max(validAt) AS validAt FROM edgeprops WHERE edgeid IN ( SELECT rowid FROM edges WHERE startId = ? OR endId = ? ) AND validAt <= ? GROUP BY edgeid, key) JOIN edgeprops p USING (edgeid, key, validAt) WHERE p.value IS NOT NULL;");
        }
        this.stmtDeleteEdgePropsForNode.setLong(1, time);
        this.stmtDeleteEdgePropsForNode.setLong(3, time);
        this.stmtDeleteEdgePropsForNode.setInt(2, nodeID);
        this.stmtDeleteEdgePropsForNode.setLong(4, time);
        return this.stmtDeleteEdgePropsForNode;
    }

    @Override
    public PreparedStatement getDeleteEdgePropsForNodeStatement(int nodeID) throws SQLException {
        return this.getDeleteEdgePropsForNodeStatement(nodeID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getDeleteEdgesForNodeStatement(int nodeID, long time) throws SQLException {
        if (this.stmtDeleteEdgesForNode == null) {
            this.stmtDeleteEdgesForNode = this.connection.prepareStatement("UPDATE edges SET validTo = ? WHERE startId = ? OR endId = ?;");
        }
        this.stmtDeleteEdgesForNode.setLong(1, time);
        this.stmtDeleteEdgesForNode.setInt(2, nodeID);
        this.stmtDeleteEdgesForNode.setInt(3, nodeID);
        return this.stmtDeleteEdgesForNode;
    }

    @Override
    public PreparedStatement getDeleteEdgesForNodeStatement(int nodeID) throws SQLException {
        return this.getDeleteEdgesForNodeStatement(nodeID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getAllInstantsForNodeStatement(int nodeID) throws SQLException {
        if (this.stmtAllInstantsForNode == null) {
            this.stmtAllInstantsForNode = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint ORDER BY tp.timepoint DESC;");
        }
        this.stmtAllInstantsForNode.setInt(1, nodeID);
        this.stmtAllInstantsForNode.setInt(2, nodeID);
        this.stmtAllInstantsForNode.setInt(3, nodeID);
        this.stmtAllInstantsForNode.setInt(4, nodeID);
        this.stmtAllInstantsForNode.setInt(5, nodeID);
        this.stmtAllInstantsForNode.setInt(6, nodeID);
        this.stmtAllInstantsForNode.setInt(7, nodeID);
        return this.stmtAllInstantsForNode;
    }

    public PreparedStatement getNextInstantStatement(int nodeID, long time) throws SQLException {
        if (this.stmtNextInstant == null) {
            this.stmtNextInstant = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint WHERE tp.timepoint > ? ORDER BY tp.timepoint ASC LIMIT 1;");
        }
        this.stmtNextInstant.setInt(1, nodeID);
        this.stmtNextInstant.setInt(2, nodeID);
        this.stmtNextInstant.setInt(3, nodeID);
        this.stmtNextInstant.setInt(4, nodeID);
        this.stmtNextInstant.setInt(5, nodeID);
        this.stmtNextInstant.setInt(6, nodeID);
        this.stmtNextInstant.setInt(7, nodeID);
        this.stmtNextInstant.setLong(8, time);
        return this.stmtNextInstant;
    }

    public PreparedStatement getNextInstantStatement(int nodeID) throws SQLException {
        return this.getNextInstantStatement(nodeID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getLatestInstantStatement(int nodeID) throws SQLException {
        if (this.stmtLatestInstant == null) {
            this.stmtLatestInstant = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint ORDER BY tp.timepoint DESC LIMIT 1;");
        }
        this.stmtLatestInstant.setInt(1, nodeID);
        this.stmtLatestInstant.setInt(2, nodeID);
        this.stmtLatestInstant.setInt(3, nodeID);
        this.stmtLatestInstant.setInt(4, nodeID);
        this.stmtLatestInstant.setInt(5, nodeID);
        this.stmtLatestInstant.setInt(6, nodeID);
        this.stmtLatestInstant.setInt(7, nodeID);
        return this.stmtLatestInstant;
    }

    public PreparedStatement getPrevInstantStatement(int nodeID, long time) throws SQLException {
        if (this.stmtPrevInstant == null) {
            this.stmtPrevInstant = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint WHERE tp.timepoint < ? ORDER BY tp.timepoint DESC LIMIT 1;");
        }
        this.stmtPrevInstant.setInt(1, nodeID);
        this.stmtPrevInstant.setInt(2, nodeID);
        this.stmtPrevInstant.setInt(3, nodeID);
        this.stmtPrevInstant.setInt(4, nodeID);
        this.stmtPrevInstant.setInt(5, nodeID);
        this.stmtPrevInstant.setInt(6, nodeID);
        this.stmtPrevInstant.setInt(7, nodeID);
        this.stmtPrevInstant.setLong(8, time);
        return this.stmtPrevInstant;
    }

    public PreparedStatement getPrevInstantStatement(int nodeID) throws SQLException {
        return this.getPrevInstantStatement(nodeID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getEarliestInstantStatement(int nodeID) throws SQLException {
        if (this.stmtEarliestInstant == null) {
            this.stmtEarliestInstant = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint ORDER BY tp.timepoint ASC LIMIT 1;");
        }
        this.stmtEarliestInstant.setInt(1, nodeID);
        this.stmtEarliestInstant.setInt(2, nodeID);
        this.stmtEarliestInstant.setInt(3, nodeID);
        this.stmtEarliestInstant.setInt(4, nodeID);
        this.stmtEarliestInstant.setInt(5, nodeID);
        this.stmtEarliestInstant.setInt(6, nodeID);
        this.stmtEarliestInstant.setInt(7, nodeID);
        return this.stmtEarliestInstant;
    }

    public PreparedStatement getInstantsBetweenStatement(int nodeID, long fromInclusive, long toInclusive) throws SQLException {
        if (this.stmtInstantsBetween == null) {
            this.stmtInstantsBetween = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint WHERE tp.timepoint >= ? AND tp.timepoint <= ? ORDER BY tp.timepoint DESC;");
        }
        this.stmtInstantsBetween.setInt(1, nodeID);
        this.stmtInstantsBetween.setInt(2, nodeID);
        this.stmtInstantsBetween.setInt(3, nodeID);
        this.stmtInstantsBetween.setInt(4, nodeID);
        this.stmtInstantsBetween.setInt(5, nodeID);
        this.stmtInstantsBetween.setInt(6, nodeID);
        this.stmtInstantsBetween.setInt(7, nodeID);
        this.stmtInstantsBetween.setLong(8, fromInclusive);
        this.stmtInstantsBetween.setLong(9, toInclusive);
        return this.stmtInstantsBetween;
    }

    public PreparedStatement getInstantsFromStatement(int nodeID, long fromInclusive) throws SQLException {
        if (this.stmtInstantsFrom == null) {
            this.stmtInstantsFrom = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint WHERE tp.timepoint >= ? ORDER BY tp.timepoint DESC;");
        }
        this.stmtInstantsFrom.setInt(1, nodeID);
        this.stmtInstantsFrom.setInt(2, nodeID);
        this.stmtInstantsFrom.setInt(3, nodeID);
        this.stmtInstantsFrom.setInt(4, nodeID);
        this.stmtInstantsFrom.setInt(5, nodeID);
        this.stmtInstantsFrom.setInt(6, nodeID);
        this.stmtInstantsFrom.setInt(7, nodeID);
        this.stmtInstantsFrom.setLong(8, fromInclusive);
        return this.stmtInstantsFrom;
    }

    public PreparedStatement getInstantsUpToStatement(int nodeID, long toInclusive) throws SQLException {
        if (this.stmtInstantsUpTo == null) {
            this.stmtInstantsUpTo = this.connection.prepareStatement("SELECT DISTINCT tp.timepoint FROM ( SELECT validFrom AS timepoint FROM nodes WHERE rowid = ? UNION SELECT validAt FROM nodeprops WHERE nodeid = ? UNION SELECT validFrom FROM edges WHERE startId = ? OR endId = ? UNION SELECT validTo FROM edges WHERE validTo IS NOT NULL AND (startId = ? OR endId = ?) ) AS tp JOIN (SELECT validTo FROM nodes WHERE rowid = ?) AS tpThreshold ON tpThreshold.validTo IS NULL OR tpThreshold.validTo > tp.timepoint WHERE tp.timepoint <= ? ORDER BY tp.timepoint DESC;");
        }
        this.stmtInstantsUpTo.setInt(1, nodeID);
        this.stmtInstantsUpTo.setInt(2, nodeID);
        this.stmtInstantsUpTo.setInt(3, nodeID);
        this.stmtInstantsUpTo.setInt(4, nodeID);
        this.stmtInstantsUpTo.setInt(5, nodeID);
        this.stmtInstantsUpTo.setInt(6, nodeID);
        this.stmtInstantsUpTo.setInt(7, nodeID);
        this.stmtInstantsUpTo.setLong(8, toInclusive);
        return this.stmtInstantsUpTo;
    }

    public PreparedStatement getIsAliveStatement(int nodeID, long time) throws SQLException {
        if (this.stmtIsAlive == null) {
            this.stmtIsAlive = this.connection.prepareStatement("SELECT EXISTS (SELECT 1 FROM nodes WHERE rowid = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?));");
        }
        this.stmtIsAlive.setInt(1, nodeID);
        this.stmtIsAlive.setLong(2, time);
        this.stmtIsAlive.setLong(3, time);
        return this.stmtIsAlive;
    }

    public PreparedStatement getIsAliveStatement(int nodeID) throws SQLException {
        return this.getIsAliveStatement(nodeID, this.defaultTimeProvider.get());
    }

    public PreparedStatement getOutgoingEdgesWithTypeBetweenStatement(String type, int fromID, long fromInclusive, long toExclusive) throws SQLException {
        if (this.stmtOutgoingEdgesWithTypeBetween == null) {
            this.stmtOutgoingEdgesWithTypeBetween = this.connection.prepareStatement("SELECT rowid, endId, validFrom FROM edges WHERE label = ? AND startId = ? AND ((validFrom >= ? AND validFrom < ?) OR (? >= validFrom AND ? < COALESCE(validTo, ?)));");
        }
        this.stmtOutgoingEdgesWithTypeBetween.setString(1, type);
        this.stmtOutgoingEdgesWithTypeBetween.setInt(2, fromID);
        this.stmtOutgoingEdgesWithTypeBetween.setLong(3, fromInclusive);
        this.stmtOutgoingEdgesWithTypeBetween.setLong(5, fromInclusive);
        this.stmtOutgoingEdgesWithTypeBetween.setLong(6, fromInclusive);
        this.stmtOutgoingEdgesWithTypeBetween.setLong(4, toExclusive);
        this.stmtOutgoingEdgesWithTypeBetween.setLong(7, toExclusive);
        return this.stmtOutgoingEdgesWithTypeBetween;
    }

    public PreparedStatement getIncomingEdgesWithTypeBetweenStatement(String type, int toID, long fromInclusive, long toExclusive) throws SQLException {
        if (this.stmtIncomingEdgesWithTypeBetween == null) {
            this.stmtIncomingEdgesWithTypeBetween = this.connection.prepareStatement("SELECT rowid, startId, validFrom FROM edges WHERE label = ? AND endId = ? AND ((validFrom >= ? AND validFrom < ?) OR (? >= validFrom AND ? < COALESCE(validTo, ?)));");
        }
        this.stmtIncomingEdgesWithTypeBetween.setString(1, type);
        this.stmtIncomingEdgesWithTypeBetween.setInt(2, toID);
        this.stmtIncomingEdgesWithTypeBetween.setLong(3, fromInclusive);
        this.stmtIncomingEdgesWithTypeBetween.setLong(5, fromInclusive);
        this.stmtIncomingEdgesWithTypeBetween.setLong(6, fromInclusive);
        this.stmtIncomingEdgesWithTypeBetween.setLong(4, toExclusive);
        this.stmtIncomingEdgesWithTypeBetween.setLong(7, toExclusive);
        return this.stmtIncomingEdgesWithTypeBetween;
    }

    public PreparedStatement getOutgoingEdgesWithTypeCreatedBetweenStatement(String type, int fromID, long fromInclusive, long toExclusive) throws SQLException {
        if (this.stmtOutgoingEdgesWithTypeCreatedBetween == null) {
            this.stmtOutgoingEdgesWithTypeCreatedBetween = this.connection.prepareStatement("SELECT rowid, endId, validFrom FROM edges WHERE label = ? AND startId = ? AND validFrom >= ? AND validFrom < ?;");
        }
        this.stmtOutgoingEdgesWithTypeCreatedBetween.setString(1, type);
        this.stmtOutgoingEdgesWithTypeCreatedBetween.setInt(2, fromID);
        this.stmtOutgoingEdgesWithTypeCreatedBetween.setLong(3, fromInclusive);
        this.stmtOutgoingEdgesWithTypeCreatedBetween.setLong(4, toExclusive);
        return this.stmtOutgoingEdgesWithTypeCreatedBetween;
    }

    public PreparedStatement getIncomingEdgesWithTypeCreatedBetweenStatement(String type, int toID, long fromInclusive, long toExclusive) throws SQLException {
        if (this.stmtIncomingEdgesWithTypeCreatedBetween == null) {
            this.stmtIncomingEdgesWithTypeCreatedBetween = this.connection.prepareStatement("SELECT rowid, startId, validFrom FROM edges WHERE label = ? AND endId = ? AND validFrom >= ? AND validFrom < ?;");
        }
        this.stmtIncomingEdgesWithTypeCreatedBetween.setString(1, type);
        this.stmtIncomingEdgesWithTypeCreatedBetween.setInt(2, toID);
        this.stmtIncomingEdgesWithTypeCreatedBetween.setLong(3, fromInclusive);
        this.stmtIncomingEdgesWithTypeCreatedBetween.setLong(4, toExclusive);
        return this.stmtIncomingEdgesWithTypeCreatedBetween;
    }

    @Override
    public PreparedStatement getUpsertNodeIndexStatement(String name) throws SQLException {
        if (this.stmtUpsertNodeIndex == null) {
            this.stmtUpsertNodeIndex = this.connection.prepareStatement("INSERT INTO nodeindices (name) VALUES (?) ON CONFLICT (name) DO NOTHING;");
        }
        this.stmtUpsertNodeIndex.setString(1, name);
        return this.stmtUpsertNodeIndex;
    }

    @Override
    public PreparedStatement getDeleteNodeIndexStatement(String name) throws SQLException {
        if (this.stmtDeleteNodeIndex == null) {
            this.stmtDeleteNodeIndex = this.connection.prepareStatement("DELETE FROM nodeindices WHERE name = ?;");
        }
        this.stmtDeleteNodeIndex.setString(1, name);
        return this.stmtDeleteNodeIndex;
    }

    @Override
    public PreparedStatement getAllNodeIndicesStatement() throws SQLException {
        if (this.stmtAllNodeIndices == null) {
            this.stmtAllNodeIndices = this.connection.prepareStatement("SELECT name FROM nodeindices;");
        }
        return this.stmtAllNodeIndices;
    }

    public PreparedStatement getAddNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtAddNodeIndexEntry.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("INSERT OR REPLACE INTO `idx_%s` (key, nodeId, value, validFrom, validTo) VALUES (?, ?, ?, ?, NULL);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setInt(2, nodeId);
        stmt.setObject(3, value);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getAddNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value) throws SQLException {
        return this.getAddNodeIndexEntryStatement(indexName, key, nodeId, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getAnnotateNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value, long validToExclusive, long time) throws SQLException {
        PreparedStatement stmt = this.stmtAnnotateNodeIndexEntry.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("INSERT OR REPLACE INTO `idx_%s` (key, nodeId, value, validFrom, validTo) VALUES (?, ?, ?, ?, ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setInt(2, nodeId);
        stmt.setObject(3, value);
        stmt.setLong(4, time);
        stmt.setLong(5, validToExclusive);
        return stmt;
    }

    public PreparedStatement getAnnotateNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value, long validToExclusive) throws SQLException {
        return this.getAnnotateNodeIndexEntryStatement(indexName, key, nodeId, value, validToExclusive, this.defaultTimeProvider.get());
    }

    public PreparedStatement getRemoveNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeIndexEntry.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("UPDATE `idx_%s` SET validTo = ? WHERE key = ? AND nodeId = ? AND value = ? AND validTo IS NULL;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setString(2, key);
        stmt.setInt(3, nodeId);
        stmt.setObject(4, value);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeIndexEntryStatement(String indexName, String key, int nodeId, Object value) throws SQLException {
        return this.getRemoveNodeIndexEntryStatement(indexName, key, nodeId, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getRemoveNodeFromIndexStatement(String indexName, int nodeId, long time) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeFromIndex.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("UPDATE `idx_%s` SET validTo = ? WHERE nodeId = ? AND validTo IS NULL;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setInt(2, nodeId);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeFromIndexStatement(String indexName, int nodeId) throws SQLException {
        return this.getRemoveNodeFromIndexStatement(indexName, nodeId, this.defaultTimeProvider.get());
    }

    public PreparedStatement getRemoveNodeFieldFromIndexStatement(String indexName, int nodeId, String key, long time) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeFieldFromIndex.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("UPDATE `idx_%s` SET validTo = ? WHERE nodeId = ? AND key = ? AND validTo IS NULL;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setInt(2, nodeId);
        stmt.setString(3, key);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeFieldFromIndexStatement(String indexName, int nodeId, String key) throws SQLException {
        return this.getRemoveNodeFieldFromIndexStatement(indexName, nodeId, key, this.defaultTimeProvider.get());
    }

    public PreparedStatement getRemoveNodeValueFromIndexStatement(String indexName, int nodeId, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtRemoveNodeValueFromIndex.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("UPDATE `idx_%s` SET validTo = ? WHERE nodeId = ? AND value = ? AND validTo IS NULL;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setInt(2, nodeId);
        stmt.setObject(3, value);
        return stmt;
    }

    @Override
    public PreparedStatement getRemoveNodeValueFromIndexStatement(String indexName, int nodeId, Object value) throws SQLException {
        return this.getRemoveNodeValueFromIndexStatement(indexName, nodeId, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValuePatternStatement(String indexName, String key, String value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValuePattern.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value GLOB ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setString(2, value);
        stmt.setLong(3, time);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValuePatternStatement(String indexName, String key, String value) throws SQLException {
        return this.getQueryIndexValuePatternStatement(indexName, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValuePatternCountStatement(String indexName, String key, String value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValuePatternCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND value GLOB ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setString(2, value);
        stmt.setLong(3, time);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValuePatternCountStatement(String indexName, String key, String value) throws SQLException {
        return this.getQueryIndexValuePatternCountStatement(indexName, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValuePatternSingleStatement(String indexName, String key, String value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValuePatternSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value GLOB ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?)LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setString(2, value);
        stmt.setLong(3, time);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValuePatternSingleStatement(String indexName, String key, String value) throws SQLException {
        return this.getQueryIndexValuePatternSingleStatement(indexName, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueExactStatement(String indexName, String key, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueExact.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setObject(2, value);
        stmt.setLong(3, time);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueExactStatement(String indexName, String key, Object value) throws SQLException {
        return this.getQueryIndexValueExactStatement(indexName, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueExactCountStatement(String indexName, String key, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueExactCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND value = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setObject(2, value);
        stmt.setLong(3, time);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueExactCountStatement(String indexName, String key, Object value) throws SQLException {
        return this.getQueryIndexValueExactCountStatement(indexName, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueExactSingleStatement(String indexName, String key, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueExactSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?)LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setObject(2, value);
        stmt.setLong(3, time);
        stmt.setLong(4, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueExactSingleStatement(String indexName, String key, Object value) throws SQLException {
        return this.getQueryIndexValueExactSingleStatement(indexName, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueAllValuesStatement(String indexName, String key, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllValues.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setLong(2, time);
        stmt.setLong(3, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllValuesStatement(String indexName, String key) throws SQLException {
        return this.getQueryIndexValueAllValuesStatement(indexName, key, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueAllValuesCountStatement(String indexName, String key, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllValuesCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setLong(2, time);
        stmt.setLong(3, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllValuesCountStatement(String indexName, String key) throws SQLException {
        return this.getQueryIndexValueAllValuesCountStatement(indexName, key, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueAllValuesSingleStatement(String indexName, String key, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllValuesSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?)LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setLong(2, time);
        stmt.setLong(3, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllValuesSingleStatement(String indexName, String key) throws SQLException {
        return this.getQueryIndexValueAllValuesSingleStatement(indexName, key, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueAllPairsStatement(String indexName, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllPairs.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setLong(2, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllPairsStatement(String indexName) throws SQLException {
        return this.getQueryIndexValueAllPairsStatement(indexName, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueAllPairsCountStatement(String indexName, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllPairsCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE validFrom <= ? AND (validTo IS NULL OR validTo > ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setLong(2, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllPairsCountStatement(String indexName) throws SQLException {
        return this.getQueryIndexValueAllPairsCountStatement(indexName, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexValueAllPairsSingleStatement(String indexName, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexValueAllPairsSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE validFrom <= ? AND (validTo IS NULL OR validTo > ?)LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setLong(1, time);
        stmt.setLong(2, time);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexValueAllPairsSingleStatement(String indexName) throws SQLException {
        return this.getQueryIndexValueAllPairsSingleStatement(indexName, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexNumberRangeStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexNumberRange.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?) AND (? AND value >= ? OR value > ?) AND (? AND value <= ? OR value < ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setLong(2, time);
        stmt.setLong(3, time);
        stmt.setBoolean(4, fromInclusive);
        stmt.setObject(5, from);
        stmt.setObject(6, from);
        stmt.setBoolean(7, toInclusive);
        stmt.setObject(8, to);
        stmt.setObject(9, to);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexNumberRangeStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to) throws SQLException {
        return this.getQueryIndexNumberRangeStatement(indexName, key, fromInclusive, from, toInclusive, to, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexNumberRangeCountStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexNumberRangeCount.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?) AND (? AND value >= ? OR value > ?) AND (? AND value <= ? OR value < ?);", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setLong(2, time);
        stmt.setLong(3, time);
        stmt.setBoolean(4, fromInclusive);
        stmt.setObject(5, from);
        stmt.setObject(6, from);
        stmt.setBoolean(7, toInclusive);
        stmt.setObject(8, to);
        stmt.setObject(9, to);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexNumberRangeCountStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to) throws SQLException {
        return this.getQueryIndexNumberRangeCountStatement(indexName, key, fromInclusive, from, toInclusive, to, this.defaultTimeProvider.get());
    }

    public PreparedStatement getQueryIndexNumberRangeSingleStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to, long time) throws SQLException {
        PreparedStatement stmt = this.stmtQueryIndexNumberRangeSingle.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND validFrom <= ? AND (validTo IS NULL OR validTo > ?) AND (? AND value >= ? OR value > ?) AND (? AND value <= ? OR value < ?)LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setString(1, key);
        stmt.setLong(2, time);
        stmt.setLong(3, time);
        stmt.setBoolean(4, fromInclusive);
        stmt.setObject(5, from);
        stmt.setObject(6, from);
        stmt.setBoolean(7, toInclusive);
        stmt.setObject(8, to);
        stmt.setObject(9, to);
        return stmt;
    }

    @Override
    public PreparedStatement getQueryIndexNumberRangeSingleStatement(String indexName, String key, boolean fromInclusive, Number from, boolean toInclusive, Number to) throws SQLException {
        return this.getQueryIndexNumberRangeSingleStatement(indexName, key, fromInclusive, from, toInclusive, to, this.defaultTimeProvider.get());
    }

    public PreparedStatement getIndexVersionsStatement(String indexName, int nodeID, String key, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtIndexVersions.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT validFrom, validTo FROM `idx_%s` WHERE nodeid = ? AND key = ? AND value = ? AND (validTo IS NULL OR (validTo > ? AND validTo > validFrom)) ORDER BY validFrom DESC;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setInt(1, nodeID);
        stmt.setString(2, key);
        stmt.setObject(3, value);
        stmt.setLong(4, time);
        return stmt;
    }

    public PreparedStatement getIndexVersionsStatement(String indexName, int nodeID, String key, Object value) throws SQLException {
        return this.getIndexVersionsStatement(indexName, nodeID, key, value, this.defaultTimeProvider.get());
    }

    public PreparedStatement getIndexEarliestVersionSinceStatement(String indexName, int nodeID, String key, Object value, long time) throws SQLException {
        PreparedStatement stmt = this.stmtIndexEarliestVersionSince.computeIfAbsent(indexName, name -> {
            try {
                return this.connection.prepareStatement(String.format("SELECT validFrom, validTo FROM `idx_%s` WHERE nodeid = ? AND key = ? AND value = ? AND (validTo IS NULL OR (validTo > ? AND validTo > validFrom)) ORDER BY validFrom ASC LIMIT 1;", name));
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
        stmt.setInt(1, nodeID);
        stmt.setString(2, key);
        stmt.setObject(3, value);
        stmt.setLong(4, time);
        return stmt;
    }

    public PreparedStatement getIndexEarliestVersionSinceStatement(String indexName, int nodeID, String key, Object value) throws SQLException {
        return this.getIndexEarliestVersionSinceStatement(indexName, nodeID, key, value, this.defaultTimeProvider.get());
    }

    protected String getPropertyType(Object value) {
        if (value instanceof Blob) {
            return TYPE_BLOB_BASE64;
        }
        return value == null ? "unknown" : value.getClass().getSimpleName();
    }

    protected void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }

    protected String base64(Object value) throws IOException, SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.copy(((Blob)value).getBinaryStream(), bos);
        return Base64.encodeBase64String((byte[])bos.toByteArray());
    }
}

