/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.patterns;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.eclipse.hawk.timeaware.queries.operations.TimeAwareNodeFirstOrderOperation;
import org.eclipse.hawk.timeaware.queries.operations.patterns.IShortCircuitReducer;

public class VersionQuantifierOperation
extends TimeAwareNodeFirstOrderOperation {
    private final IShortCircuitReducer reducer;

    public VersionQuantifierOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier, IShortCircuitReducer reducer) {
        super(containerModelSupplier);
        this.reducer = reducer;
    }

    @Override
    protected Object execute(Variable iterator, Expression expression, IEolContext context, Function<ITimeAwareGraphNode, Object> versionWrapper, ITimeAwareGraphNode taNode) throws EolInternalException {
        try {
            List versions = taNode.getAllVersions();
            FrameStack scope = context.getFrameStack();
            for (ITimeAwareGraphNode version : versions) {
                Boolean bResult;
                Object listItem = versionWrapper.apply(version);
                if (iterator.getType() != null && !iterator.getType().isKind(listItem)) continue;
                scope.enterLocal(FrameType.UNPROTECTED, (ModuleElement)expression, new Variable[0]);
                scope.put(Variable.createReadOnlyVariable((String)iterator.getName(), (Object)listItem));
                Object bodyResult = context.getExecutorFactory().execute((ModuleElement)expression, context);
                scope.leaveLocal((ModuleElement)expression);
                if (!(bodyResult instanceof Boolean) || (bResult = this.reducer.reduce((Boolean)bodyResult)) == null) continue;
                return bResult;
            }
        }
        catch (Exception ex) {
            throw new EolInternalException((Throwable)ex, (ModuleElement)expression);
        }
        return this.reducer.reduce();
    }

    public boolean isOverridable() {
        return false;
    }
}

