/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnPropertiesDiffHandler;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnOldDiffGenerator;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnNewDiffGenerator
implements ISVNDiffGenerator,
ISvnPropertiesDiffHandler {
    private final ISvnDiffGenerator generator;
    private boolean diffDeleted;
    private boolean diffAdded;
    private boolean diffCopied;
    private boolean diffUnversioned;
    private SVNProperties lastOriginalProperties;
    private SVNProperties lastPropChanges;

    public SvnNewDiffGenerator(ISvnDiffGenerator generator) {
        this.generator = generator;
        if (generator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultGenerator = (DefaultSVNDiffGenerator)((Object)generator);
            this.diffAdded = defaultGenerator.isDiffAdded();
            this.diffDeleted = defaultGenerator.isDiffDeleted();
            this.diffCopied = defaultGenerator.isDiffCopied();
            this.diffUnversioned = defaultGenerator.isDiffUnversioned();
        } else {
            this.diffAdded = true;
            this.diffDeleted = true;
            this.diffCopied = false;
            this.diffUnversioned = false;
        }
    }

    public ISvnDiffGenerator getDelegate() {
        return this.generator;
    }

    @Override
    public void init(String anchorPath1, String anchorPath2) {
        this.generator.setOriginalTargets(this.getAbsoluteTarget(anchorPath1), this.getAbsoluteTarget(anchorPath2));
        this.generator.setAnchors(this.getAbsoluteTarget(anchorPath1), this.getAbsoluteTarget(anchorPath2));
    }

    @Override
    public void setBasePath(File basePath) {
        this.generator.setBaseTarget(SvnTarget.fromFile(basePath));
    }

    @Override
    public void setForcedBinaryDiff(boolean forced) {
        this.generator.setForcedBinaryDiff(forced);
    }

    @Override
    public void setEncoding(String encoding) {
        this.generator.setEncoding(encoding);
    }

    @Override
    public String getEncoding() {
        return this.generator.getEncoding();
    }

    @Override
    public void setEOL(byte[] eol) {
        this.generator.setEOL(eol);
    }

    @Override
    public byte[] getEOL() {
        return this.generator.getEOL();
    }

    @Override
    public void setDiffDeleted(boolean isDiffDeleted) {
        if (this.generator instanceof SvnDiffGenerator) {
            ((SvnDiffGenerator)this.generator).setDiffDeleted(isDiffDeleted);
        } else if (this.generator instanceof SvnOldDiffGenerator) {
            ((SvnOldDiffGenerator)this.generator).getDelegate().setDiffDeleted(isDiffDeleted);
        }
        this.diffDeleted = isDiffDeleted;
    }

    @Override
    public boolean isDiffDeleted() {
        return this.diffDeleted;
    }

    @Override
    public void setDiffAdded(boolean isDiffAdded) {
        this.diffAdded = isDiffAdded;
    }

    @Override
    public boolean isDiffAdded() {
        return this.diffAdded;
    }

    @Override
    public void setDiffCopied(boolean isDiffCopied) {
        this.diffCopied = isDiffCopied;
    }

    @Override
    public boolean isDiffCopied() {
        return this.diffCopied;
    }

    @Override
    public void setDiffUnversioned(boolean diffUnversioned) {
        this.diffUnversioned = diffUnversioned;
    }

    @Override
    public boolean isDiffUnversioned() {
        return this.diffUnversioned;
    }

    @Override
    public File createTempDirectory() throws SVNException {
        return SVNFileUtil.createTempDirectory("diff");
    }

    @Override
    public void displayPropDiff(String path, SVNProperties baseProps, SVNProperties diff, OutputStream result) throws SVNException {
        this.generator.displayPropsChanged(this.getTarget(path), "", "", false, baseProps, diff, result);
    }

    @Override
    public void handlePropertiesDiff(SVNProperties originalProperties, SVNProperties propChanges) {
        this.lastOriginalProperties = originalProperties;
        this.lastPropChanges = originalProperties;
    }

    @Override
    public void displayFileDiff(String path, File file1, File file2, String rev1, String rev2, String mimeType1, String mimeType2, OutputStream result) throws SVNException {
        this.generator.displayContentChanged(this.getTarget(path), file1, file2, rev1, rev2, mimeType1, mimeType2, SvnDiffCallback.OperationKind.Modified, null, this.lastOriginalProperties, this.lastPropChanges, result);
    }

    @Override
    public void displayDeletedDirectory(String path, String rev1, String rev2) throws SVNException {
        this.generator.displayDeletedDirectory(this.getTarget(path), rev1, rev2, null);
    }

    @Override
    public void displayAddedDirectory(String path, String rev1, String rev2) throws SVNException {
        this.generator.displayAddedDirectory(this.getTarget(path), rev1, rev2, null);
    }

    @Override
    public boolean isForcedBinaryDiff() {
        return this.generator.isForcedBinaryDiff();
    }

    private SvnTarget getTarget(String path) {
        return SvnTarget.fromFile(SVNFileUtil.createFilePath(path));
    }

    private SvnTarget getAbsoluteTarget(String path) {
        if (SVNPathUtil.isURL(path)) {
            try {
                return SvnTarget.fromURL(SVNURL.parseURIEncoded(path));
            }
            catch (SVNException e) {
                return SvnTarget.fromFile(SVNFileUtil.createFilePath(path));
            }
        }
        return SvnTarget.fromFile(SVNFileUtil.createFilePath(path));
    }
}

