/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.context;

import java.util.function.Supplier;
import junit.framework.TestCase;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.util.Property;

public class ContextTest
extends TestCase {
    private static final Property<String> P1 = Property.get((String)"p1", String.class).withDefault((Object)"bar");
    private static final Property<Supplier<String>> P2 = new Property<Supplier<String>>("p2"){};
    private static final Property<Foo> P3 = Property.get((String)"p3", Foo.class);
    private Context ctx;

    protected void setUp() throws Exception {
        this.ctx = new Context();
    }

    public void test01() {
        ContextTest.assertFalse((boolean)this.ctx.containsKey(P1));
        ContextTest.assertNull((Object)this.ctx.get(P1));
        ContextTest.assertEquals((String)"bar", (String)((String)this.ctx.getOrDefault(P1)));
    }

    public void test02() {
        this.ctx.bind(P1).to(null);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(P1));
        ContextTest.assertNull((Object)this.ctx.get(P1));
        ContextTest.assertNull((Object)this.ctx.getOrDefault(P1));
    }

    public void test03() {
        String value = "foo";
        this.ctx.bind(P1).to((Object)value);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(P1));
        ContextTest.assertSame((Object)value, (Object)this.ctx.get(P1));
        ContextTest.assertSame((Object)value, (Object)this.ctx.getOrDefault(P1));
    }

    public void test04() {
        String value = "foo";
        Supplier<String> supplier = () -> value;
        this.ctx.bind(P1).toSupplier(supplier);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(P1));
        ContextTest.assertSame((Object)value, (Object)this.ctx.get(P1));
        ContextTest.assertSame((Object)value, (Object)this.ctx.getOrDefault(P1));
    }

    public void test05() {
        Supplier<String> supplier = () -> "foo";
        this.ctx.bind(P2).to(supplier);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(P2));
        ContextTest.assertSame(supplier, (Object)this.ctx.get(P2));
        ContextTest.assertSame(supplier, (Object)this.ctx.getOrDefault(P2));
    }

    public void test06() {
        ContextTest.assertFalse((boolean)this.ctx.containsKey(P3));
        ContextTest.assertNull((Object)this.ctx.get(P3));
        ContextTest.assertNull((Object)this.ctx.getOrDefault(P3));
        ContextTest.assertFalse((boolean)this.ctx.containsKey(Foo.class));
        ContextTest.assertNull((Object)this.ctx.get(Foo.class));
    }

    public void test07() {
        this.ctx.bind(P3).to(null);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(P3));
        ContextTest.assertNull((Object)this.ctx.get(P3));
        ContextTest.assertNull((Object)this.ctx.getOrDefault(P3));
    }

    public void test08() {
        this.ctx.bind(Foo.class).to(null);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(Foo.class));
        ContextTest.assertNull((Object)this.ctx.get(Foo.class));
    }

    public void test09() {
        Foo foo = new Foo();
        this.ctx.bind(P3).to((Object)foo);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(P3));
        ContextTest.assertSame((Object)foo, (Object)this.ctx.get(P3));
        ContextTest.assertSame((Object)foo, (Object)this.ctx.getOrDefault(P3));
        try {
            this.ctx.bind(P3);
            ContextTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test10() {
        Foo foo = new Foo();
        this.ctx.bind(Foo.class).to((Object)foo);
        ContextTest.assertTrue((boolean)this.ctx.containsKey(Foo.class));
        ContextTest.assertSame((Object)foo, (Object)this.ctx.get(Foo.class));
        try {
            this.ctx.bind(Foo.class);
            ContextTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test11() {
        Bar bar = new Bar();
        this.ctx.bind(P3).to((Object)bar);
        ContextTest.assertSame((Object)bar, (Object)this.ctx.get(P3));
    }

    public void test12() {
        Bar bar = new Bar();
        this.ctx.bind(Foo.class).to((Object)bar);
        ContextTest.assertSame((Object)bar, (Object)this.ctx.get(Foo.class));
    }

    public void test13() {
        Bar bar = new Bar();
        this.ctx.bind(P3).toSupplier((Supplier)bar);
        ContextTest.assertEquals(Foo.class, ((Foo)this.ctx.get(P3)).getClass());
    }

    public void test14() {
        Bar bar = new Bar();
        this.ctx.bind(Foo.class).toSupplier((Supplier)bar);
        ContextTest.assertEquals(Foo.class, ((Foo)this.ctx.get(Foo.class)).getClass());
    }

    public void test15() {
        Bar bar = new Bar();
        Supplier<Bar> supplier = () -> bar;
        this.ctx.bind(P3).toSupplier(supplier);
        ContextTest.assertSame((Object)bar, (Object)this.ctx.get(P3));
    }

    public void test16() {
        Bar bar = new Bar();
        Supplier<Bar> supplier = () -> bar;
        this.ctx.bind(Foo.class).toSupplier(supplier);
        ContextTest.assertSame((Object)bar, (Object)this.ctx.get(Foo.class));
    }

    private static class Bar
    extends Foo
    implements Supplier<Foo> {
        private Bar() {
        }

        @Override
        public Foo get() {
            return new Foo();
        }
    }

    private static class Foo {
        private Foo() {
        }
    }
}

