/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class DeferredSourceFileDocumentProvider
extends TextFileDocumentProvider {
    private static final ISourceFile[] NO_SOURCE_FILES = new ISourceFile[0];

    public DeferredSourceFileDocumentProvider() {
        this(null);
    }

    public DeferredSourceFileDocumentProvider(IDocumentProvider parent) {
        super(parent);
    }

    public ISourceFile getConnectedSourceFile(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof SourceFileInfo) {
            return ((SourceFileInfo)info).sourceFile;
        }
        return null;
    }

    public ISourceFile getConnectedSourceFile(IDocument document) {
        Iterator it = this.getFileInfosIterator();
        while (it.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)it.next();
            IDocument infoDocument = null;
            if (info.fTextFileBuffer != null) {
                infoDocument = info.fTextFileBuffer.getDocument();
            }
            if (infoDocument == null || !infoDocument.equals(document) || !(info instanceof SourceFileInfo)) continue;
            return ((SourceFileInfo)info).sourceFile;
        }
        return null;
    }

    public ISourceFile[] getConnectedSourceFiles() {
        ArrayList<ISourceFile> result = new ArrayList<ISourceFile>();
        Iterator it = this.getFileInfosIterator();
        while (it.hasNext()) {
            ISourceFile sourceFile;
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)it.next();
            if (!(info instanceof SourceFileInfo) || (sourceFile = ((SourceFileInfo)info).sourceFile) == null) continue;
            result.add(sourceFile);
        }
        return result.toArray(NO_SOURCE_FILES);
    }

    protected abstract ISourceFile getSourceFile(Object var1);

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (info instanceof SourceFileInfo) {
            this.setUpSourceFileInfo(element, (SourceFileInfo)info);
        }
        return info;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        try {
            if (info instanceof SourceFileInfo) {
                this.disposeSourceFileInfo(element, (SourceFileInfo)info);
            }
        }
        finally {
            super.disposeFileInfo(element, info);
        }
    }

    protected boolean acquireWorkingCopy(ISourceFile sourceFile, Object element, TextFileDocumentProvider.FileInfo info, IProgressMonitor monitor) throws CoreException {
        if (sourceFile instanceof ISourceFileImplExtension) {
            ((ISourceFileImplExtension)sourceFile).becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, monitor);
            return true;
        }
        return false;
    }

    protected void releaseWorkingCopy(ISourceFile workingCopy, Object element, TextFileDocumentProvider.FileInfo info) {
        ((ISourceFileImplExtension)workingCopy).releaseWorkingCopy_();
    }

    private void setUpSourceFileInfo(Object element, SourceFileInfo info) {
        ISourceFile sourceFile = this.getSourceFile(element);
        if (sourceFile == null) {
            return;
        }
        info.sourceFile = sourceFile;
        info.setUpWorkingCopyJob = Job.createSystem((String)"DeferredSourceFileDocumentProvider::setUpSourceFileInfo", monitor -> {
            if (!this.acquireWorkingCopy(sourceFile, element, info, monitor)) {
                return;
            }
            if (!Elements.isWorkingCopy((ISourceFile)sourceFile)) {
                throw new AssertionError();
            }
            boolean releaseWorkingCopy = true;
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (IBuffer buffer = Elements.getBuffer((ISourceFile)sourceFile);){
                    IDocument document = null;
                    if (sourceFileInfo.fTextFileBuffer != null) {
                        document = sourceFileInfo.fTextFileBuffer.getDocument();
                    }
                    if (!buffer.getDocument().equals(document)) {
                        throw new AssertionError();
                    }
                    SourceFileInfo sourceFileInfo2 = info;
                    synchronized (sourceFileInfo2) {
                        if (!sourceFileInfo.disposed) {
                            sourceFileInfo.workingCopyAcquired = true;
                            releaseWorkingCopy = false;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (releaseWorkingCopy) {
                    this.releaseWorkingCopy(sourceFile, element, info);
                }
            }
        });
        info.setUpWorkingCopyJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeSourceFileInfo(Object element, SourceFileInfo info) {
        Job setUpWorkingCopyJob = info.setUpWorkingCopyJob;
        if (setUpWorkingCopyJob != null) {
            setUpWorkingCopyJob.cancel();
        }
        ISourceFile workingCopy = null;
        SourceFileInfo sourceFileInfo = info;
        synchronized (sourceFileInfo) {
            if (info.workingCopyAcquired) {
                workingCopy = info.sourceFile;
            }
            info.disposed = true;
        }
        if (workingCopy != null) {
            this.releaseWorkingCopy(workingCopy, element, info);
        }
    }

    protected static class SourceFileInfo
    extends TextFileDocumentProvider.FileInfo {
        ISourceFile sourceFile;
        Job setUpWorkingCopyJob;
        boolean workingCopyAcquired;
        boolean disposed;

        protected SourceFileInfo() {
        }
    }
}

