/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.typehierarchy;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.ui.DefaultEditorUtility;
import org.eclipse.handly.ui.EditorOpener;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.PartListenerAdapter;
import org.eclipse.handly.ui.action.HistoryDropDownAction;
import org.eclipse.handly.ui.typehierarchy.Messages;
import org.eclipse.handly.ui.typehierarchy.TypeHierarchyKind;
import org.eclipse.handly.ui.viewer.DelegatingSelectionProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class TypeHierarchyViewPart
extends ViewPart {
    protected static final String GROUP_FOCUS = "group.focus";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String KEY_HIERARCHY_KIND = "org.eclipse.handly.typehierarchy.view.hierarchyKind";
    private static final String KEY_LAYOUT_MODE = "org.eclipse.handly.typehierarchy.view.layoutMode";
    private static final String KEY_HORIZONTAL_WEIGHTS = "org.eclipse.handly.typehierarchy.view.horizontalWeights";
    private static final String KEY_VERTICAL_WEIGHTS = "org.eclipse.handly.typehierarchy.view.verticalWeights";
    private static final int LAYOUT_AUTOMATIC = 768;
    private final Set<TypeHierarchyKind> supportedHierarchyKinds;
    private Set<TypeHierarchyKind> enabledHierarchyKinds;
    private TypeHierarchyKind hierarchyKind;
    private int layoutMode = this.getDefaultLayoutMode();
    private boolean layoutAdjusted;
    private int[] horizontalWeights;
    private int[] verticalWeights;
    private Object[] inputElements = NO_ELEMENTS;
    private final List<HistoryEntry> history = new ArrayList<HistoryEntry>();
    private PageBook pageBook;
    private PageBook hierarchyPageBook;
    private Control noHierarchyPage;
    private SashForm sashForm;
    private final Map<TypeHierarchyKind, TreeViewer> hierarchyViewers = new HashMap<TypeHierarchyKind, TreeViewer>();
    private EditorOpener editorOpener;
    private SetHierarchyKindAction[] setHierarchyKindActions = new SetHierarchyKindAction[0];
    private SetLayoutModeAction[] setLayoutModeActions = new SetLayoutModeAction[0];
    private final FocusOnSelectionAction focusOnSelectionAction = new FocusOnSelectionAction();
    private HistoryDropDownAction<HistoryEntry> historyDropDownAction;
    private final RefreshAction refreshAction = new RefreshAction();
    private final IPartListener partListener = new PartListenerAdapter(){

        @Override
        public void partOpened(IWorkbenchPart part) {
            if (part != TypeHierarchyViewPart.this) {
                return;
            }
            TypeHierarchyViewPart.this.refresh();
        }
    };

    public TypeHierarchyViewPart() {
        this(EnumSet.allOf(TypeHierarchyKind.class));
    }

    public TypeHierarchyViewPart(Set<TypeHierarchyKind> supportedHierarchyKinds) {
        if (supportedHierarchyKinds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.supportedHierarchyKinds = supportedHierarchyKinds;
        this.enabledHierarchyKinds = supportedHierarchyKinds;
        this.hierarchyKind = supportedHierarchyKinds.iterator().next();
        this.makeSetHierarchyKindActions();
        this.makeSetLayoutModeActions();
        this.refreshAction.setEnabled(false);
    }

    public boolean arePossibleInputElements(Object[] elements) {
        if (elements == null) {
            return false;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.isPossibleInputElement(element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setInputElements(Object[] elements) {
        if (!this.arePossibleInputElements(elements)) {
            throw new IllegalArgumentException(Arrays.toString(elements));
        }
        Object[] oldInputElements = this.inputElements;
        this.inputElements = elements;
        this.refreshAction.setEnabled(elements.length > 0);
        if (elements.length > 0) {
            this.addHistoryEntry(this.createHistoryEntry(elements));
        }
        this.onInputElementsChanged(oldInputElements, elements);
    }

    public final Object[] getInputElements() {
        return this.inputElements;
    }

    public final boolean isEnabledHierarchyKind(TypeHierarchyKind kind) {
        return this.enabledHierarchyKinds.contains((Object)kind);
    }

    public void setHierarchyKind(TypeHierarchyKind kind) {
        if (!this.isEnabledHierarchyKind(kind)) {
            throw new IllegalArgumentException();
        }
        if (kind == this.hierarchyKind) {
            return;
        }
        TypeHierarchyKind oldKind = this.hierarchyKind;
        this.hierarchyKind = kind;
        SetHierarchyKindAction[] setHierarchyKindActionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyKindAction action = setHierarchyKindActionArray[n2];
            action.setChecked(action.kind == kind);
            ++n2;
        }
        this.onHierarchyKindChanged(oldKind, kind);
    }

    public final TypeHierarchyKind getHierarchyKind() {
        return this.hierarchyKind;
    }

    public void setLayoutMode(int layoutMode) {
        if (!this.supportsLayoutMode(layoutMode)) {
            throw new IllegalArgumentException();
        }
        if (layoutMode == this.layoutMode) {
            return;
        }
        int oldLayoutMode = this.layoutMode;
        this.layoutMode = layoutMode;
        SetLayoutModeAction[] setLayoutModeActionArray = this.setLayoutModeActions;
        int n = this.setLayoutModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetLayoutModeAction action = setLayoutModeActionArray[n2];
            action.setChecked(action.layoutMode == layoutMode);
            ++n2;
        }
        this.onLayoutModeChanged(oldLayoutMode, layoutMode);
    }

    public final int getLayoutMode() {
        return this.layoutMode;
    }

    public boolean supportsLayoutMode(int layoutMode) {
        return layoutMode == 0;
    }

    public final void refresh() {
        this.refresh(Contexts.EMPTY_CONTEXT);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            int value;
            Integer layoutMode;
            String value2;
            if (this.supportedHierarchyKinds.size() > 1 && (value2 = memento.getString(KEY_HIERARCHY_KIND)) != null) {
                TypeHierarchyKind kind = null;
                try {
                    kind = TypeHierarchyKind.valueOf(value2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (this.supportedHierarchyKinds.contains((Object)kind)) {
                    this.setHierarchyKind(kind);
                }
            }
            if ((layoutMode = memento.getInteger(KEY_LAYOUT_MODE)) != null && this.supportsLayoutMode(value = layoutMode.intValue())) {
                this.setLayoutMode(value);
            }
            try {
                this.horizontalWeights = TypeHierarchyViewPart.toIntArray(memento.getString(KEY_HORIZONTAL_WEIGHTS));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.verticalWeights = TypeHierarchyViewPart.toIntArray(memento.getString(KEY_VERTICAL_WEIGHTS));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.supportedHierarchyKinds.size() > 1) {
            memento.putString(KEY_HIERARCHY_KIND, this.hierarchyKind.name());
        }
        memento.putInteger(KEY_LAYOUT_MODE, this.layoutMode);
        this.saveSashFormWeights();
        memento.putString(KEY_HORIZONTAL_WEIGHTS, TypeHierarchyViewPart.toString(this.horizontalWeights));
        memento.putString(KEY_VERTICAL_WEIGHTS, TypeHierarchyViewPart.toString(this.verticalWeights));
    }

    public void createPartControl(Composite parent) {
        SetHierarchyKindAction action;
        this.getSite().getPage().addPartListener(this.partListener);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!TypeHierarchyViewPart.this.layoutAdjusted || TypeHierarchyViewPart.this.layoutMode == 768) {
                    TypeHierarchyViewPart.this.adjustLayout(TypeHierarchyViewPart.this.layoutMode);
                }
            }
        });
        final DelegatingSelectionProvider selectionProvider = new DelegatingSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        selectionProvider.addSelectionChangedListener(e -> {
            ISelection selection = e.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.updateStatusLine(this.getViewSite().getActionBars().getStatusLineManager(), (IStructuredSelection)selection);
            }
        });
        this.pageBook = new PageBook(parent, 0);
        this.noHierarchyPage = this.createNoHierarchyPage((Composite)this.pageBook);
        this.sashForm = new SashForm((Composite)this.pageBook, 0);
        this.hierarchyPageBook = new PageBook((Composite)this.sashForm, 0);
        if (this.layoutMode == 0) {
            this.sashForm.setMaximizedControl((Control)this.hierarchyPageBook);
        }
        for (final TypeHierarchyKind kind : this.supportedHierarchyKinds) {
            final TreeViewer hierarchyViewer = this.createHierarchyViewer((Composite)this.hierarchyPageBook, kind);
            this.configureHierarchyViewer(hierarchyViewer, kind);
            this.initContextMenu(hierarchyViewer.getControl(), manager -> {
                this.createHierarchyViewerMenuGroups(manager, kind);
                this.fillHierarchyViewerMenu(manager, kind);
            }, this.getSite().getId(), (ISelectionProvider)selectionProvider);
            new OpenEditorHelper((StructuredViewer)hierarchyViewer);
            hierarchyViewer.getControl().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    selectionProvider.setDelegate((ISelectionProvider)hierarchyViewer);
                    TypeHierarchyViewPart.this.onHierarchySelectionChanged(hierarchyViewer.getSelection(), kind);
                }

                public void focusLost(FocusEvent e) {
                    selectionProvider.setDelegate(null);
                }
            });
            hierarchyViewer.addSelectionChangedListener(e -> this.onHierarchySelectionChanged(e.getSelection(), kind));
            this.hierarchyViewers.put(kind, hierarchyViewer);
        }
        this.editorOpener = this.createEditorOpener();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.focusOnSelectionAction);
        this.addRefreshAction((IAction)this.refreshAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        Action[] actionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.addSetHierarchyKindAction((IAction)action, action.kind);
            ++n2;
        }
        actionArray = this.setLayoutModeActions;
        n = this.setLayoutModeActions.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.addSetLayoutModeAction((IAction)action, ((SetLayoutModeAction)((Object)action)).layoutMode);
            ++n2;
        }
        this.historyDropDownAction = this.createHistoryDropDownAction(new HistoryDropDownAction.History<HistoryEntry>(){

            @Override
            public List<HistoryEntry> getHistoryEntries() {
                return TypeHierarchyViewPart.this.getHistory();
            }

            @Override
            public void setHistoryEntries(List<HistoryEntry> entries) {
                List<HistoryEntry> history = TypeHierarchyViewPart.this.getHistory();
                history.clear();
                history.addAll(entries);
                TypeHierarchyViewPart.this.onHistoryChanged();
            }

            @Override
            public HistoryEntry getActiveEntry() {
                Object[] inputElements = TypeHierarchyViewPart.this.getInputElements();
                if (inputElements.length == 0) {
                    return null;
                }
                return TypeHierarchyViewPart.this.createHistoryEntry(inputElements);
            }

            @Override
            public void setActiveEntry(HistoryEntry entry) {
                TypeHierarchyViewPart.this.setInputElements(entry.getInputElements());
            }

            @Override
            public String getLabel(HistoryEntry entry) {
                return entry.getLabel();
            }

            @Override
            public ImageDescriptor getImageDescriptor(HistoryEntry entry) {
                return entry.getImageDescriptor();
            }
        });
        this.historyDropDownAction.setEnabled(!this.getHistory().isEmpty());
        this.addHistoryDropDownAction((IAction)this.historyDropDownAction);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    protected abstract boolean isPossibleInputElement(Object var1);

    protected abstract HistoryEntry createHistoryEntry(Object[] var1);

    protected abstract String computeContentDescription();

    protected final boolean isOpen() {
        return this.pageBook != null && !this.pageBook.isDisposed();
    }

    protected void refresh(IContext context) {
        if (!this.isOpen()) {
            return;
        }
        this.setContentDescription(this.computeContentDescription());
        for (Map.Entry<TypeHierarchyKind, TreeViewer> entry : this.hierarchyViewers.entrySet()) {
            this.setHierarchyViewerInput(entry.getValue(), entry.getKey());
        }
        this.updateHierarchyPage();
    }

    protected void updateHierarchyPage() {
        if (this.inputElements.length > 0) {
            TreeViewer hierarchyViewer = this.hierarchyViewers.get((Object)this.hierarchyKind);
            Control hierarchyPage = hierarchyViewer.getControl();
            this.pageBook.showPage((Control)this.sashForm);
            this.hierarchyPageBook.showPage(hierarchyPage);
            hierarchyPage.setFocus();
        } else {
            this.pageBook.showPage(this.noHierarchyPage);
            this.pageBook.setFocus();
        }
    }

    protected void onInputElementsChanged(Object[] oldInputElements, Object[] newInputElements) {
        this.refresh();
    }

    protected void onHierarchyKindChanged(TypeHierarchyKind oldKind, TypeHierarchyKind newKind) {
        if (!this.isOpen()) {
            return;
        }
        this.updateHierarchyPage();
    }

    protected final Set<TypeHierarchyKind> getSupportedHierarchyKinds() {
        return this.supportedHierarchyKinds;
    }

    protected void setEnabledHierarchyKinds(Set<TypeHierarchyKind> kinds) {
        if (kinds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.supportedHierarchyKinds.containsAll(kinds)) {
            throw new IllegalArgumentException();
        }
        if (this.enabledHierarchyKinds.equals(kinds)) {
            return;
        }
        Set<TypeHierarchyKind> oldKinds = this.enabledHierarchyKinds;
        this.enabledHierarchyKinds = kinds;
        SetHierarchyKindAction[] setHierarchyKindActionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyKindAction action = setHierarchyKindActionArray[n2];
            action.setEnabled(kinds.contains((Object)action.kind));
            ++n2;
        }
        if (!kinds.contains((Object)this.hierarchyKind)) {
            this.setHierarchyKind(kinds.iterator().next());
        }
        this.onEnabledHierarchyKindsChanged(oldKinds, kinds);
    }

    protected void onEnabledHierarchyKindsChanged(Set<TypeHierarchyKind> oldKinds, Set<TypeHierarchyKind> newKinds) {
        if (!this.isOpen()) {
            return;
        }
        for (TypeHierarchyKind kind : TypeHierarchyViewPart.symmetricDifference(oldKinds, newKinds)) {
            this.setHierarchyViewerInput(this.hierarchyViewers.get((Object)kind), kind);
        }
    }

    protected void onLayoutModeChanged(int oldLayoutMode, int newLayoutMode) {
        if (!this.isOpen()) {
            return;
        }
        this.sashForm.setMaximizedControl((Control)(newLayoutMode == 0 ? this.hierarchyPageBook : null));
        this.adjustLayout(newLayoutMode);
    }

    protected void updateStatusLine(IStatusLineManager manager, IStructuredSelection selection) {
        String message = null;
        int size = selection.size();
        if (size > 1) {
            message = MessageFormat.format(Messages.TypeHierarchyViewPart_0__items_selected, size);
        }
        manager.setMessage(message);
        manager.setErrorMessage(null);
    }

    protected Control createNoHierarchyPage(Composite parent) {
        Label label = new Label(parent, 16448);
        label.setText(Messages.TypeHierarchyViewPart_No_hierarchy_to_display);
        return label;
    }

    protected final SashForm getSashForm() {
        return this.sashForm;
    }

    protected final TreeViewer getHierarchyViewer(TypeHierarchyKind kind) {
        return this.hierarchyViewers.get((Object)kind);
    }

    protected TreeViewer createHierarchyViewer(Composite parent, TypeHierarchyKind kind) {
        return new TreeViewer(parent, 4);
    }

    protected abstract void configureHierarchyViewer(TreeViewer var1, TypeHierarchyKind var2);

    protected void setHierarchyViewerInput(TreeViewer viewer, TypeHierarchyKind kind) {
        viewer.setInput(this.inputElements.length > 0 && this.isEnabledHierarchyKind(kind) ? this.inputElements : null);
    }

    protected void createHierarchyViewerMenuGroups(IMenuManager manager, TypeHierarchyKind kind) {
        manager.add((IContributionItem)new Separator(GROUP_FOCUS));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillHierarchyViewerMenu(IMenuManager manager, TypeHierarchyKind kind) {
        if (this.focusOnSelectionAction.isEnabled()) {
            manager.appendToGroup(GROUP_FOCUS, (IAction)this.focusOnSelectionAction);
        }
    }

    protected void onHierarchySelectionChanged(ISelection selection, TypeHierarchyKind kind) {
        Object element = TypeHierarchyViewPart.getSelectedElement(selection);
        if (element != null && this.hierarchyViewers.get((Object)kind).getControl().isFocusControl()) {
            try {
                this.revealInEditor(element, false, false);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    protected void revealInEditor(Object element, boolean activate, boolean mayOpenNewEditor) throws PartInitException {
        EditorUtility editorUtility = this.editorOpener.getEditorUtility();
        if (editorUtility.getEditorInput(element) == null) {
            return;
        }
        if (mayOpenNewEditor) {
            this.editorOpener.open(element, activate, true);
        } else {
            IEditorPart editor;
            IWorkbenchPage page = this.editorOpener.getWorkbenchPage();
            IEditorReference editorRef = editorUtility.findEditor(page, element);
            if (editorRef != null && (editor = editorRef.getEditor(true)) != null) {
                if (activate) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.bringToTop((IWorkbenchPart)editor);
                }
                editorUtility.revealElement(editor, element);
            }
        }
    }

    protected final EditorOpener getEditorOpener() {
        return this.editorOpener;
    }

    protected EditorOpener createEditorOpener() {
        return new EditorOpener(this.getSite().getPage(), DefaultEditorUtility.INSTANCE);
    }

    protected final IAction getFocusOnSelectionAction() {
        return this.focusOnSelectionAction;
    }

    protected void addRefreshAction(IAction action) {
        this.getViewSite().getActionBars().getToolBarManager().add(action);
    }

    protected void addSetHierarchyKindAction(IAction action, TypeHierarchyKind kind) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add(action);
        actionBars.getMenuManager().add(action);
    }

    protected void addSetLayoutModeAction(IAction action, int layoutMode) {
        String id;
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        IMenuManager layoutSubMenu = viewMenu.findMenuUsingPath(id = "layout");
        if (layoutSubMenu == null) {
            viewMenu.add((IContributionItem)new Separator());
            layoutSubMenu = new MenuManager(Messages.TypeHierarchyViewPart_Layout_menu, id);
            viewMenu.add((IContributionItem)layoutSubMenu);
        }
        layoutSubMenu.add(action);
    }

    protected HistoryDropDownAction<HistoryEntry> createHistoryDropDownAction(HistoryDropDownAction.History<HistoryEntry> history) {
        return new HistoryDropDownAction<HistoryEntry>(history);
    }

    protected void addHistoryDropDownAction(IAction action) {
        this.getViewSite().getActionBars().getToolBarManager().add(action);
    }

    protected List<HistoryEntry> getHistory() {
        return this.history;
    }

    protected void onHistoryChanged() {
        boolean empty = this.getHistory().isEmpty();
        this.historyDropDownAction.setEnabled(!empty);
        if (empty) {
            this.setInputElements(NO_ELEMENTS);
        }
    }

    private void addHistoryEntry(HistoryEntry entry) {
        List<HistoryEntry> history = this.getHistory();
        history.remove(entry);
        history.add(0, entry);
        this.onHistoryChanged();
    }

    private void makeSetHierarchyKindActions() {
        int size = this.supportedHierarchyKinds.size();
        if (size > 1) {
            this.setHierarchyKindActions = new SetHierarchyKindAction[size];
            int i = 0;
            for (TypeHierarchyKind kind : this.supportedHierarchyKinds) {
                this.setHierarchyKindActions[i++] = new SetHierarchyKindAction(kind);
            }
        }
    }

    private void makeSetLayoutModeActions() {
        int size;
        ArrayList<SetLayoutModeAction> actions = new ArrayList<SetLayoutModeAction>();
        if (this.supportsLayoutMode(512)) {
            actions.add(new SetLayoutModeAction(512));
        }
        if (this.supportsLayoutMode(256)) {
            actions.add(new SetLayoutModeAction(256));
        }
        if (this.supportsLayoutMode(768)) {
            actions.add(new SetLayoutModeAction(768));
        }
        if (this.supportsLayoutMode(0)) {
            actions.add(new SetLayoutModeAction(0));
        }
        if ((size = actions.size()) > 1) {
            this.setLayoutModeActions = actions.toArray(new SetLayoutModeAction[size]);
        }
    }

    private int getDefaultLayoutMode() {
        if (this.supportsLayoutMode(768)) {
            return 768;
        }
        if (this.supportsLayoutMode(512)) {
            return 512;
        }
        if (this.supportsLayoutMode(256)) {
            return 256;
        }
        if (this.supportsLayoutMode(0)) {
            return 0;
        }
        throw new AssertionError();
    }

    private void adjustLayout(int layoutMode) {
        int orientation;
        if (layoutMode == 0) {
            return;
        }
        Point size = this.sashForm.getParent().getParent().getSize();
        if (size.x == 0 || size.y == 0) {
            return;
        }
        int n = layoutMode == 768 ? (size.x > size.y ? 256 : 512) : (orientation = layoutMode);
        if (this.sashForm.getOrientation() == orientation && this.layoutAdjusted) {
            return;
        }
        if (this.sashForm.getOrientation() != orientation) {
            this.saveSashFormWeights();
            this.sashForm.setOrientation(orientation);
        }
        this.restoreSashFormWeights();
        this.layoutAdjusted = true;
    }

    private void saveSashFormWeights() {
        if (!this.layoutAdjusted) {
            return;
        }
        int[] weights = this.sashForm.getWeights();
        if (weights.length < 2) {
            return;
        }
        if (this.sashForm.getOrientation() == 256) {
            this.horizontalWeights = weights;
        } else {
            this.verticalWeights = weights;
        }
    }

    private void restoreSashFormWeights() {
        int[] weights;
        int[] nArray = weights = this.sashForm.getOrientation() == 256 ? this.horizontalWeights : this.verticalWeights;
        if (weights != null) {
            this.sashForm.setWeights(weights);
        }
    }

    private void initContextMenu(Control parent, IMenuListener listener, String menuId, ISelectionProvider selectionProvider) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        Menu menu = manager.createContextMenu(parent);
        parent.setMenu(menu);
        this.getSite().registerContextMenu(menuId, manager, selectionProvider);
    }

    private static Object getSelectedElement(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement();
        }
        return null;
    }

    private static Set<TypeHierarchyKind> symmetricDifference(Set<TypeHierarchyKind> kindsA, Set<TypeHierarchyKind> kindsB) {
        EnumSet<TypeHierarchyKind> result = EnumSet.copyOf(kindsA);
        for (TypeHierarchyKind kind : kindsB) {
            if (result.add(kind)) continue;
            result.remove((Object)kind);
        }
        return result;
    }

    private static String toString(int[] values) {
        if (values == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int length = values.length;
        int i = 0;
        while (i < length) {
            sb.append(values[i]);
            if (i < length - 1) {
                sb.append(',');
            }
            ++i;
        }
        return sb.toString();
    }

    private static int[] toIntArray(String s) throws NumberFormatException {
        if (s == null) {
            return null;
        }
        String[] values = s.split(",");
        int length = values.length;
        int[] result = new int[length];
        int i = 0;
        while (i < length) {
            result[i] = Integer.parseInt(values[i]);
            ++i;
        }
        return result;
    }

    private class FocusOnSelectionAction
    extends BaseSelectionListenerAction {
        FocusOnSelectionAction() {
            super(Messages.TypeHierarchyViewPart_Focus_on_selection_action_text);
            this.setToolTipText(Messages.TypeHierarchyViewPart_Focus_on_selection_action_tooltip);
        }

        public void run() {
            TypeHierarchyViewPart.this.setInputElements(this.getStructuredSelection().toArray());
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return !selection.isEmpty() && TypeHierarchyViewPart.this.arePossibleInputElements(selection.toArray());
        }
    }

    protected static abstract class HistoryEntry {
        private final Object[] inputElements;

        protected HistoryEntry(Object[] inputElements) {
            if (inputElements.length == 0) {
                throw new AssertionError();
            }
            this.inputElements = inputElements;
        }

        public final Object[] getInputElements() {
            return this.inputElements;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoryEntry other = (HistoryEntry)obj;
            return Arrays.equals(this.inputElements, other.inputElements);
        }

        public int hashCode() {
            return Arrays.hashCode(this.inputElements);
        }

        public String getLabel() {
            switch (this.inputElements.length) {
                case 1: {
                    return MessageFormat.format(Messages.TypeHierarchyViewPart_History_entry_label__0, this.getElementLabel(this.inputElements[0]));
                }
                case 2: {
                    return MessageFormat.format(Messages.TypeHierarchyViewPart_History_entry_label__0__1, this.getElementLabel(this.inputElements[0]), this.getElementLabel(this.inputElements[1]));
                }
            }
            return MessageFormat.format(Messages.TypeHierarchyViewPart_History_entry_label__0__1_more, this.getElementLabel(this.inputElements[0]), this.getElementLabel(this.inputElements[1]));
        }

        protected abstract String getElementLabel(Object var1);

        public ImageDescriptor getImageDescriptor() {
            return null;
        }
    }

    protected class OpenEditorHelper
    extends OpenAndLinkWithEditorHelper {
        public OpenEditorHelper(StructuredViewer viewer) {
            super(viewer);
        }

        protected void activate(ISelection selection) {
            Object element = TypeHierarchyViewPart.getSelectedElement(selection);
            if (element != null) {
                try {
                    TypeHierarchyViewPart.this.revealInEditor(element, true, false);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }

        protected void open(ISelection selection, boolean activate) {
            Object element = TypeHierarchyViewPart.getSelectedElement(selection);
            if (element != null) {
                try {
                    TypeHierarchyViewPart.this.revealInEditor(element, activate, true);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)TypeHierarchyViewPart.this.getSite().getShell(), (String)Messages.TypeHierarchyViewPart_Open_selected_element, (String)Messages.TypeHierarchyViewPart_Error_opening_editor, (IStatus)e.getStatus());
                }
            }
        }
    }

    private class RefreshAction
    extends Action {
        RefreshAction() {
            this.setText(Messages.TypeHierarchyViewPart_Refresh_action_text);
            this.setToolTipText(Messages.TypeHierarchyViewPart_Refresh_action_tooltip);
            this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/refresh.png"));
            this.setDisabledImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/dlcl16/refresh.png"));
        }

        public void run() {
            TypeHierarchyViewPart.this.refresh();
        }
    }

    private class SetHierarchyKindAction
    extends Action {
        final TypeHierarchyKind kind;

        SetHierarchyKindAction(TypeHierarchyKind kind) {
            super(null, 8);
            this.kind = kind;
            switch (kind) {
                case TYPES: {
                    this.setText(Messages.TypeHierarchyViewPart_Show_type_hierarchy_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Show_type_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/th_types.png"));
                    break;
                }
                case SUPERTYPES: {
                    this.setText(Messages.TypeHierarchyViewPart_Show_supertype_hierarchy_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Show_supertype_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/th_supertypes.png"));
                    break;
                }
                case SUBTYPES: {
                    this.setText(Messages.TypeHierarchyViewPart_Show_subtype_hierarchy_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Show_subtype_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/th_subtypes.png"));
                }
            }
            if (kind == TypeHierarchyViewPart.this.getHierarchyKind()) {
                this.setChecked(true);
            }
        }

        public void run() {
            TypeHierarchyViewPart.this.setHierarchyKind(this.kind);
        }
    }

    private class SetLayoutModeAction
    extends Action {
        final int layoutMode;

        SetLayoutModeAction(int layoutMode) {
            super(null, 8);
            this.layoutMode = layoutMode;
            switch (layoutMode) {
                case 512: {
                    this.setText(Messages.TypeHierarchyViewPart_Layout_vertical_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Layout_vertical_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_vertical.png"));
                    break;
                }
                case 256: {
                    this.setText(Messages.TypeHierarchyViewPart_Layout_horizontal_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Layout_horizontal_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_horizontal.png"));
                    break;
                }
                case 768: {
                    this.setText(Messages.TypeHierarchyViewPart_Layout_automatic_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Layout_automatic_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_automatic.png"));
                    break;
                }
                case 0: {
                    this.setText(Messages.TypeHierarchyViewPart_Layout_single_action_text);
                    this.setToolTipText(Messages.TypeHierarchyViewPart_Layout_single_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_single.png"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (layoutMode == TypeHierarchyViewPart.this.getLayoutMode()) {
                this.setChecked(true);
            }
        }

        public void run() {
            TypeHierarchyViewPart.this.setLayoutMode(this.layoutMode);
        }
    }
}

