/******************************************************************************
 * Copyright (c) 2004, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.common.ui.action.actions;

/**
 * Various strings used by the menus and actions in the modeler domain.
 * @author ldamus
 */
public class CommonActionConstants {

	/**
	 * This class should not be instantiated since it is a static constant
	 * class.
	 */
	private CommonActionConstants() {
		super();
	}

	/**
	 * Edit menu: name of Repeat global action (value
	 * <code>"org.eclipse.gmf.runtime.common.ui.edit.repeat"</code>).
	 */
	public static final String REPEAT = "org.eclipse.gmf.runtime.common.ui.edit.repeat"; //$NON-NLS-1$

	/**
	 * The menu ID for the common file menu.
	 */
	public static final String FILE_MENU_ID = "org.eclipse.gmf.runtime.common.ui.actions.FileMenu"; //$NON-NLS-1$

	/**
	 * The menu ID for the common edit menu.
	 */
	public static final String EDIT_MENU_ID = "org.eclipse.gmf.runtime.common.ui.actions.EditMenu"; //$NON-NLS-1$

	/**
	 * The menu ID for the common edit menu.
	 */
	public static final String REFACTOR_MENU_ID = "org.eclipse.gmf.runtime.common.ui.actions.RefactorMenu"; //$NON-NLS-1$
	
	/**
	 * The menu ID for the common navigate menu.
	 */
	public static final String NAVIGATE_MENU_ID = "org.eclipse.gmf.runtime.common.ui.actions.NavigateMenu"; //$NON-NLS-1$
	
	/**
	 * The add context menu group name.
	 */
	public static final String ADD_GROUP = "addGroup"; //$NON-NLS-1$
	
	/**
	 * The add additions context menu group name.
	 */
	public static final String ADD_GROUP_ADDITIONS = "addGroupAdditions"; //$NON-NLS-1$
	
	/**
	 * The navigate context menu group name.
	 */
	public static final String NAVIGATE_GROUP = "navigateGroup"; //$NON-NLS-1$
	
	/**
	 * The post navigate context menu group name.
	 */
	public static final String POST_NAVIGATE_GROUP = "postNavigateGroup"; //$NON-NLS-1$
	
	/**
	 * The file context menu group name.
	 */
	public static final String FILE_GROUP = "fileGroup"; //$NON-NLS-1$
	
	/**
	 * The edit context menu group name.
	 */
	public static final String EDIT_GROUP = "editGroup"; //$NON-NLS-1$
	
	/**
	 * The edit context menu copy group name.
	 */
	public static final String EDIT_COPY_GROUP = "copyGroup"; //$NON-NLS-1$

	/**
	 * The edit context menu delete group name.
	 */
	public static final String EDIT_DELETE_GROUP = "deleteGroup"; //$NON-NLS-1$
	
	/**
	 * The edit context menu modify group name.
	 */
	public static final String EDIT_MODIFY_GROUP = "modifyGroup"; //$NON-NLS-1$
	
	/**
	 * The edit context menu undo group name.
	 */
	public static final String EDIT_UNDO_GROUP = "undoGroup"; //$NON-NLS-1$
	
	/**
	 * The edit context menu rename group name.
	 */
	public static final String RENAME_GROUP = "renameGroup"; //$NON-NLS-1$
	
	/**
	 * The properties context menu group name.
	 */
	public static final String PROPERTIES_GROUP = "propertiesGroup"; //$NON-NLS-1$
	
	/**
	 * The pre-properties context menu group name.
	 */
	public static final String PRE_PROPERTIES_GROUP = "prePropertiesGroup"; //$NON-NLS-1$
	
	/**
	 * The edit context menu import group name.
	 */
	public static final String IMPORT_GROUP = "importGroup"; //$NON-NLS-1$

	/**
	 * The refactor context menu modify group name.
	 */
	public static final String REFACTOR_MODIFY_GROUP = "modifyGroup"; //$NON-NLS-1$
	
	/**
	 * The additions context menu group name.
	 */
	public static final String ADDITIONS_GROUP = "additionsGroup"; //$NON-NLS-1$
	
	/**
	 * The file context menu group name.
	 */
	public static final String MISCELLANEOUS_GROUP = "miscellaneousGroup"; //$NON-NLS-1$
	
	/**
	 * The validate context menu group name.
	 */
	public static final String VALIDATE_GROUP = "validateGroup"; //$NON-NLS-1$
	
	/**
	 * The find context menu group name.
	 */
	public static final String FIND_GROUP = "findGroup"; //$NON-NLS-1$
}
