/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

abstract class DialogBlock {
    private final IDialogUnitConverter dluConverter;

    DialogBlock(IDialogUnitConverter dluConverter) {
        this.dluConverter = dluConverter;
    }

    protected Shell getShell() {
        return this.dluConverter.getShell();
    }

    static Composite layout(Composite composite, int columns) {
        GridLayout g = new GridLayout(columns, false);
        g.marginLeft = 6;
        g.marginRight = 6;
        g.marginTop = 6;
        g.marginBottom = 3;
        composite.setLayout((Layout)g);
        return composite;
    }

    GridData getLayoutData(Control control) {
        GridData result = (GridData)control.getLayoutData();
        if (result == null) {
            result = new GridData();
            control.setLayoutData((Object)result);
        }
        return result;
    }

    Control layoutFillHorizontal(Control control) {
        this.layoutFillHorizontal(control, true);
        return control;
    }

    Control layoutFillHorizontal(Control control, boolean grab) {
        GridData data = this.getLayoutData(control);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = grab;
        return control;
    }

    Control layoutFillVertical(Control control) {
        GridData data = this.getLayoutData(control);
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        return control;
    }

    Control layoutAlignLeft(Control control) {
        GridData data = this.getLayoutData(control);
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = false;
        return control;
    }

    Control layoutAlignRight(Control control) {
        GridData data = this.getLayoutData(control);
        data.horizontalAlignment = 0x1000008;
        data.grabExcessHorizontalSpace = false;
        return control;
    }

    Control layoutFillBoth(Control control) {
        GridData data = this.getLayoutData(control);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        return control;
    }

    Control layoutSpanHorizontal(Control control, int span) {
        GridData data = this.getLayoutData(control);
        data.horizontalSpan = span;
        return control;
    }

    Control layoutSpanVertical(Control control, int span) {
        GridData data = this.getLayoutData(control);
        data.verticalSpan = span;
        return control;
    }

    Control layoutHorizontalIndent(Control control) {
        this.layoutHorizontalIndent(control, 15);
        return control;
    }

    Control layoutHorizontalIndent(Control control, int inset) {
        GridData data = this.getLayoutData(control);
        data.horizontalIndent = inset;
        return control;
    }

    Control layoutVerticalIndent(Control control) {
        this.layoutVerticalIndent(control, 15);
        return control;
    }

    Control layoutVerticalIndent(Control control, int inset) {
        GridData data = this.getLayoutData(control);
        data.verticalIndent = inset;
        return control;
    }

    Control layoutWidth(Control control, int dlus) {
        if (dlus > 0) {
            GridData data = this.getLayoutData(control);
            data.widthHint = this.dluConverter.convertHorizontalDLUsToPixels(dlus);
        }
        return control;
    }

    Control layoutHeight(Control control, int dlus) {
        if (dlus > 0) {
            GridData data = this.getLayoutData(control);
            data.heightHint = this.dluConverter.convertHorizontalDLUsToPixels(dlus);
        }
        return control;
    }

    Group group(Composite parent, String text) {
        Group result = new Group(parent, 0);
        result.setText(text);
        this.layoutFillBoth((Control)result);
        return result;
    }

    Label label(Composite parent, String text) {
        Label result = new Label(parent, 0);
        result.setText(text);
        return result;
    }

    Text text(Composite parent, int width) {
        Text result = new Text(parent, 2052);
        this.layoutFillHorizontal((Control)result, false);
        this.layoutWidth((Control)result, width);
        return result;
    }

    ComboViewer combo(Composite parent) {
        ComboViewer result = new ComboViewer(parent);
        return result;
    }

    ListViewer list(Composite parent) {
        ListViewer result = new ListViewer(parent);
        return result;
    }

    Button button(Composite parent, String text) {
        Button result = new Button(parent, 8);
        result.setText(text);
        return result;
    }

    Button radio(Composite parent, String text) {
        Button result = new Button(parent, 16);
        result.setText(text);
        return result;
    }

    Button check(Composite parent, String text) {
        Button result = new Button(parent, 32);
        result.setText(text);
        return result;
    }

    Spinner spinner(Composite parent, int min, int max) {
        Spinner result = new Spinner(parent, 2048);
        result.setMinimum(min);
        result.setMaximum(max);
        return result;
    }

    Control blank(Composite parent) {
        Label result = new Label(parent, 0);
        return result;
    }

    public abstract Control createContents(Composite var1);

    public abstract void dispose();

    public static interface IDialogUnitConverter {
        public int convertHorizontalDLUsToPixels(int var1);

        public Shell getShell();
    }
}

