/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.commands;

import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramDebugOptions;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramPlugin;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class RemoveBookmarkCommand
extends AbstractTransactionalCommand {
    private Set bookmarks;

    public RemoveBookmarkCommand(TransactionalEditingDomain editingDomain, String label, Set bookmarks) {
        super(editingDomain, label, null);
        this.bookmarks = bookmarks;
    }

    protected void deleteBookmarks() {
        if (this.getBookmarkedObjects() == null) {
            return;
        }
        for (Object oBookmark : this.getBookmarkedObjects()) {
            if (!(oBookmark instanceof IMarker)) continue;
            try {
                ((IMarker)oBookmark).delete();
            }
            catch (CoreException e) {
                Trace.catching((Plugin)DiagramPlugin.getInstance(), (String)DiagramDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"deleteBookmarks", (Throwable)e);
                Log.error((Plugin)DiagramPlugin.getInstance(), (int)4, (String)"deleteBookmarks");
            }
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.deleteBookmarks();
        return CommandResult.newOKCommandResult();
    }

    public Set getBookmarkedObjects() {
        return this.bookmarks;
    }

    public void setBookmarkedObjects(Set bookmarks) {
        this.bookmarks = bookmarks;
    }
}

