/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.protocol.DefaultGLSPServer;
import org.eclipse.glsp.server.protocol.InitializeResult;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.MapUtil;

public class WorkflowGLSPServer
extends DefaultGLSPServer {
    protected static final Logger LOGGER = LogManager.getLogger(WorkflowGLSPServer.class);
    private static final String MESSAGE_KEY = "message";
    private static final String TIMESTAMP_KEY = "timestamp";

    public CompletableFuture<InitializeResult> handleIntializeArgs(InitializeResult result, Map<String, String> args) {
        CompletableFuture<InitializeResult> completableResult = CompletableFuture.completedFuture(result);
        if (args.isEmpty()) {
            return completableResult;
        }
        String timestamp = (String)GLSPServerException.getOrThrow((Optional)MapUtil.getValue(args, (String)TIMESTAMP_KEY), (String)"No value present for the given key: timestamp");
        String message = (String)GLSPServerException.getOrThrow((Optional)MapUtil.getValue(args, (String)MESSAGE_KEY), (String)"No value present for the given key: message");
        LOGGER.debug(String.valueOf(timestamp) + ": " + message);
        return completableResult;
    }
}

