/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.session;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.glsp.server.disposable.Disposable;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.protocol.GLSPServerListener;
import org.eclipse.glsp.server.session.ClientSession;
import org.eclipse.glsp.server.session.ClientSessionFactory;
import org.eclipse.glsp.server.session.ClientSessionListener;
import org.eclipse.glsp.server.session.ClientSessionManager;
import org.eclipse.glsp.server.types.GLSPServerException;

public class DefaultClientSessionManager
extends Disposable
implements ClientSessionManager,
GLSPServerListener {
    private static final String ALL_CLIENT_IDS_KEY = "*";
    @Inject
    protected ClientSessionFactory sessionFactory;
    protected final Map<String, ClientSession> clientSessions = new HashMap<String, ClientSession>();
    protected final Map<String, List<ClientSessionListener>> listeners = new HashMap<String, List<ClientSessionListener>>();

    @Inject
    public DefaultClientSessionManager(GLSPServer server) {
        server.addListener(this);
    }

    @Override
    public synchronized ClientSession getOrCreateClientSession(String clientSessionId, String diagramType) {
        ClientSession session = this.clientSessions.get(clientSessionId);
        if (session != null) {
            if (!session.getDiagramType().equals(diagramType)) {
                String errorMsg = String.format("Could not initialize new session for diagram type '%s'Another session with the same id for the diagram type '%s' already exists", diagramType, session.getDiagramType());
                throw new GLSPServerException(errorMsg);
            }
            return session;
        }
        ClientSession newSession = this.sessionFactory.create(clientSessionId, diagramType);
        this.clientSessions.put(clientSessionId, newSession);
        this.getListenersToNotifiy(newSession).forEach(listener -> listener.sessionCreated(newSession));
        return newSession;
    }

    protected List<ClientSessionListener> getListenersToNotifiy(ClientSession clientSession) {
        ArrayList<ClientSessionListener> toNotify = new ArrayList<ClientSessionListener>();
        List globalListeners = ((List)this.listeners.getOrDefault(ALL_CLIENT_IDS_KEY, new ArrayList())).stream().filter(listener -> listener != null).collect(Collectors.toList());
        List sessionListeners = ((List)this.listeners.getOrDefault(clientSession.getId(), new ArrayList())).stream().filter(listener -> listener != null).collect(Collectors.toList());
        this.listeners.put(ALL_CLIENT_IDS_KEY, globalListeners);
        this.listeners.put(clientSession.getId(), sessionListeners);
        toNotify.addAll(globalListeners);
        toNotify.addAll(sessionListeners);
        return toNotify;
    }

    @Override
    public synchronized boolean disposeClientSession(String clientSessionId) {
        ClientSession session = this.clientSessions.remove(clientSessionId);
        if (session == null) {
            return false;
        }
        session.dispose();
        this.getListenersToNotifiy(session).forEach(listener -> listener.sessionDisposed(session));
        this.listeners.remove(clientSessionId);
        return true;
    }

    @Override
    public Optional<ClientSession> getSession(String clientSessionId) {
        return Optional.ofNullable(this.clientSessions.get(clientSessionId));
    }

    @Override
    public boolean addListener(ClientSessionListener listener, String ... clientSessionIds) {
        if (clientSessionIds.length == 0) {
            return this.addListener(ALL_CLIENT_IDS_KEY, listener);
        }
        return Stream.of(clientSessionIds).map(clientId -> this.addListener((String)clientId, listener)).allMatch(added -> added);
    }

    protected boolean addListener(String clientSessionId, ClientSessionListener listener) {
        return this.listeners.computeIfAbsent(clientSessionId, k -> new ArrayList()).add(listener);
    }

    @Override
    public boolean removeListener(ClientSessionListener listener) {
        return new ArrayList<List<ClientSessionListener>>(this.listeners.values()).stream().map(listeners -> listeners.remove(listener)).anyMatch(removed -> removed);
    }

    @Override
    public void removeListeners(String ... clientSessionIds) {
        if (clientSessionIds.length == 0) {
            this.listeners.clear();
        } else {
            Stream.of(clientSessionIds).forEach(id -> {
                List<ClientSessionListener> list = this.listeners.remove(id);
            });
        }
    }

    @Override
    public List<ClientSession> getSessionsByType(String diagramType) {
        return this.clientSessions.values().stream().filter(session -> session.getDiagramType().equals(diagramType)).collect(Collectors.toList());
    }

    @Override
    protected synchronized void doDispose() {
        new ArrayList<String>(this.clientSessions.keySet()).forEach(clientSessionId -> {
            boolean bl = this.disposeClientSession((String)clientSessionId);
        });
        this.listeners.clear();
    }

    @Override
    public void serverShutDown(GLSPServer glspServer) {
        this.dispose();
    }
}

