/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.handlers;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.ide.editor.handlers.IdeActionHandler;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;

public class ExternalBrowserDebugHandler
extends IdeActionHandler {
    protected static Logger LOG = LogManager.getLogger(ExternalBrowserDebugHandler.class);

    @Override
    protected void execute(IEclipseContext context) {
        String clientId = (String)context.get("GLSP_CLIENT_ID");
        Optional<GLSPDiagramComposite> editor = GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().getGLSPEditor(clientId);
        if (editor.isPresent()) {
            String url = editor.get().getBrowserUrl();
            this.openInExternalBrowser(url);
            return;
        }
        LOG.warn("Execute failed, could not retrieve active GLSPDiagramEditor");
    }

    protected void openInExternalBrowser(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Could not open url in external browser. Url: " + url, (Throwable)e);
            }
        } else {
            LOG.error("Could not open url in external browser. Desktop is not supported.");
        }
    }
}

