/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.internal.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

public final class UrlUtils {
    private static Logger LOG = Logger.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static String createUrl(String host, String baseUrl) {
        return UrlUtils.createUrl(host, baseUrl, false, Collections.emptyMap());
    }

    public static String createUrl(String host, String baseUrl, boolean useHttps) {
        return UrlUtils.createUrl(host, baseUrl, useHttps, Collections.emptyMap());
    }

    public static String createUrl(String host, String baseUrl, Map<String, String> queryParams) {
        return UrlUtils.createUrl(host, baseUrl, false, queryParams);
    }

    public static String createUrl(String host, String baseUrl, boolean useHttps, Map<String, String> queryParams) {
        return UrlUtils.createUrl(host, -1, baseUrl, useHttps, queryParams);
    }

    public static String createUrl(String host, int port, String baseUrl) {
        return UrlUtils.createUrl(host, port, baseUrl, false);
    }

    public static String createUrl(String host, int port, String baseUrl, boolean useHttps) {
        return UrlUtils.createUrl(host, port, baseUrl, useHttps, Collections.emptyMap());
    }

    public static String createUrl(String host, int port, String baseUrl, Map<String, String> queryParams) {
        return UrlUtils.createUrl(host, port, baseUrl, false, queryParams);
    }

    public static String createUrl(String host, int port, String baseUrl, boolean useHttps, Map<String, String> queryParams) {
        StringBuilder builder = new StringBuilder(useHttps ? "https" : "http").append("://").append(host);
        if (port >= 0) {
            builder.append(":").append(port);
        }
        builder.append("/").append(baseUrl);
        if (!queryParams.isEmpty()) {
            builder.append("?");
            queryParams.entrySet().forEach(e -> {
                StringBuilder stringBuilder2 = builder.append((String)e.getKey()).append("=").append(UrlUtils.encodeParameter((String)e.getValue())).append("&");
            });
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static String encodeParameter(String parameter) {
        try {
            return URLEncoder.encode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            LOG.warn((Object)exception);
            return parameter;
        }
    }
}

