/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import org.glassfish.cluster.ssh.util.SSHUtil;

public class SFTPClient {
    private Session session = null;
    private ChannelSftp sftpChannel = null;

    public SFTPClient(Session session) throws JSchException {
        this.session = session;
        this.sftpChannel = (ChannelSftp)session.openChannel("sftp");
        this.sftpChannel.connect();
        SSHUtil.register(session);
    }

    public ChannelSftp getSftpChannel() {
        return this.sftpChannel;
    }

    public void close() {
        if (this.session != null) {
            SSHUtil.unregister(this.session);
            this.session = null;
        }
    }

    public boolean exists(String path) throws SftpException {
        return this._stat(SFTPClient.normalizePath(path)) != null;
    }

    public SftpATTRS _stat(String path) throws SftpException {
        try {
            return this.sftpChannel.stat(SFTPClient.normalizePath(path));
        }
        catch (SftpException e) {
            int c = e.id;
            if (c == 2) {
                return null;
            }
            throw e;
        }
    }

    public void mkdirs(String path, int posixPermission) throws SftpException {
        SftpATTRS attrs;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((attrs = this._stat(path = SFTPClient.normalizePath(path))) != null && attrs.isDir()) {
            return;
        }
        int idx = path.lastIndexOf("/");
        if (idx > 0) {
            this.mkdirs(path.substring(0, idx), posixPermission);
        }
        this.sftpChannel.mkdir(path);
        this.sftpChannel.chmod(posixPermission, path);
    }

    public void chmod(String path, int permissions) throws SftpException {
        path = SFTPClient.normalizePath(path);
        this.sftpChannel.chmod(permissions, path);
    }

    public static String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public void cd(String path) throws SftpException {
        path = SFTPClient.normalizePath(path);
        this.sftpChannel.cd(path);
    }
}

