/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.audit;

import com.sun.appserv.security.AuditModule;
import com.sun.enterprise.security.BaseAuditModule;
import com.sun.enterprise.security.audit.BaseAuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@Rank(value=20)
public final class AppServerAuditManager
extends BaseAuditManager<AuditModule> {
    private static final String AUDIT_MGR_WS_INVOCATION_KEY = "auditmgr.webServiceInvocation";
    private static final String AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY = "auditmgr.ejbAsWebServiceInvocation";
    private static final Logger _logger = LogDomains.getLogger(AppServerAuditManager.class, (String)"javax.enterprise.system.core.security");
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(AppServerAuditManager.class);
    private List<AuditModule> myAuditModules;

    private synchronized List<AuditModule> myAuditModules() {
        if (this.myAuditModules == null) {
            this.myAuditModules = this.instances(AuditModule.class);
        }
        return this.myAuditModules;
    }

    @Override
    public BaseAuditModule addAuditModule(String name, String classname, Properties props) throws Exception {
        BaseAuditModule am = super.addAuditModule(name, classname, props);
        if (AuditModule.class.isAssignableFrom(am.getClass())) {
            this.myAuditModules().add((AuditModule)am);
        }
        return am;
    }

    @Override
    public BaseAuditModule removeAuditModule(String name) {
        BaseAuditModule am = super.removeAuditModule(name);
        if (AuditModule.class.isAssignableFrom(am.getClass())) {
            this.myAuditModules().remove((AuditModule)am);
        }
        return am;
    }

    public void webInvocation(String user, HttpServletRequest req, String type, boolean success) {
        if (this.auditOn) {
            for (AuditModule am : this.myAuditModules()) {
                try {
                    am.webInvocation(user, req, type, success);
                }
                catch (Exception ex) {
                    String name = this.moduleName((BaseAuditModule)am);
                    String msg = _localStrings.getLocalString("auditmgr.webinvocation", " Audit Module {0} threw the following exception during web invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    public void ejbInvocation(String user, String ejb, String method, boolean success) {
        if (this.auditOn) {
            for (AuditModule am : this.myAuditModules()) {
                try {
                    am.ejbInvocation(user, ejb, method, success);
                }
                catch (Exception ex) {
                    String name = this.moduleName((BaseAuditModule)am);
                    String msg = _localStrings.getLocalString("auditmgr.ejbinvocation", " Audit Module {0} threw the following exception during ejb invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    public void webServiceInvocation(String uri, String endpoint, boolean validRequest) {
        if (this.auditOn) {
            for (AuditModule am : this.myAuditModules()) {
                try {
                    am.webServiceInvocation(uri, endpoint, validRequest);
                }
                catch (Exception ex) {
                    String name = this.moduleName((BaseAuditModule)am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    public void ejbAsWebServiceInvocation(String endpoint, boolean validRequest) {
        if (this.auditOn) {
            for (AuditModule am : this.myAuditModules()) {
                try {
                    am.ejbAsWebServiceInvocation(endpoint, validRequest);
                }
                catch (Exception ex) {
                    String name = this.moduleName((BaseAuditModule)am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during ejb as web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, ex);
                }
            }
        }
    }
}

