/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.security.web.integration.ConstraintValue;
import com.sun.enterprise.security.web.integration.MethodValue;
import com.sun.enterprise.security.web.integration.WebPermissionUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.security.common.Role;

class MapValue {
    boolean committed = false;
    int patternType;
    int patternLength;
    boolean irrelevantByQualifier;
    StringBuffer urlPatternSpec;
    final HashMap<String, MethodValue> methodValues = new HashMap();
    ConstraintValue otherConstraint;

    MapValue(String urlPattern) {
        this.patternType = WebPermissionUtil.patternType(urlPattern);
        this.patternLength = urlPattern.length();
        this.irrelevantByQualifier = false;
        this.urlPatternSpec = new StringBuffer(urlPattern);
        this.otherConstraint = new ConstraintValue();
    }

    void addQualifier(String urlPattern) {
        if (WebPermissionUtil.implies(urlPattern, this.urlPatternSpec.substring(0, this.patternLength))) {
            this.irrelevantByQualifier = true;
        }
        this.urlPatternSpec.append(":" + urlPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodValue getMethodValue(int methodIndex) {
        String methodName = MethodValue.getMethodName(methodIndex);
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            MethodValue methodValue = this.methodValues.get(methodName);
            if (methodValue == null) {
                methodValue = new MethodValue(methodName, this.otherConstraint);
                this.methodValues.put(methodName, methodValue);
                if (WebPermissionUtil.logger.isLoggable(Level.FINE)) {
                    WebPermissionUtil.logger.log(Level.FINE, "JACC: created MethodValue: " + methodValue);
                }
            }
            return methodValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getExcludedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isExcluded()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getNoAuthMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (v.isAuthConstrained()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getAuthConstrainedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isAuthConstrained()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getTransportConstrainedMethods() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isTransportConstrained()) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, BitSet> getRoleMap() {
        HashMap<String, BitSet> roleMap = new HashMap<String, BitSet>();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (v.isExcluded() || !v.isAuthConstrained()) continue;
                for (String role : v.roleList) {
                    BitSet methodSet = roleMap.get(role);
                    if (methodSet == null) {
                        methodSet = new BitSet();
                        roleMap.put(role, methodSet);
                    }
                    methodSet.set(v.index);
                }
            }
        }
        return roleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getConnectMap(int cType) {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                if (!v.isConnectAllowed(cType)) continue;
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getMethodSet() {
        BitSet methodSet = new BitSet();
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            Collection<MethodValue> values = this.methodValues.values();
            for (MethodValue v : values) {
                methodSet.set(v.index);
            }
        }
        return methodSet;
    }

    void setMethodOutcomes(Set<Role> roleSet, AuthorizationConstraint ac, UserDataConstraint udc, BitSet methods, BitSet omittedMethods) {
        this.committed = true;
        if (omittedMethods != null) {
            BitSet methodsInMap = this.getMethodSet();
            BitSet saved = (BitSet)omittedMethods.clone();
            omittedMethods.andNot(methodsInMap);
            int i = omittedMethods.nextSetBit(0);
            while (i >= 0) {
                this.getMethodValue(i);
                i = omittedMethods.nextSetBit(i + 1);
            }
            this.otherConstraint.setOutcome(roleSet, ac, udc);
            methodsInMap.andNot(saved);
            this.setMethodOutcomes(roleSet, ac, udc, methodsInMap, null);
        } else {
            int i = methods.nextSetBit(0);
            while (i >= 0) {
                this.getMethodValue(i).setOutcome(roleSet, ac, udc);
                i = methods.nextSetBit(i + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUncoveredMethods(boolean deny) {
        if (!this.committed) {
            return;
        }
        boolean otherIsUncovered = false;
        HashMap<String, MethodValue> hashMap = this.methodValues;
        synchronized (hashMap) {
            BitSet uncoveredMethodSet = new BitSet();
            for (MethodValue v : this.methodValues.values()) {
                if (!v.isUncovered()) continue;
                if (deny) {
                    v.setPredefinedOutcome(false);
                }
                uncoveredMethodSet.set(v.index);
            }
            if (this.otherConstraint.isUncovered()) {
                otherIsUncovered = true;
                if (deny) {
                    this.otherConstraint.setPredefinedOutcome(false);
                }
                BitSet otherMethodSet = this.getMethodSet();
                if (!uncoveredMethodSet.isEmpty()) {
                    otherMethodSet.andNot(uncoveredMethodSet);
                }
                uncoveredMethodSet = otherMethodSet;
            }
            if (otherIsUncovered || !uncoveredMethodSet.isEmpty()) {
                String uncoveredMethods = MethodValue.getActions(uncoveredMethodSet);
                Object[] args = new Object[]{this.urlPatternSpec, uncoveredMethods};
                if (deny) {
                    if (otherIsUncovered) {
                        WebPermissionUtil.logger.log(Level.INFO, "AS-SECURITY-00005", args);
                    } else {
                        WebPermissionUtil.logger.log(Level.INFO, "AS-SECURITY-00006", args);
                    }
                } else if (otherIsUncovered) {
                    WebPermissionUtil.logger.log(Level.WARNING, "AS-SECURITY-00007", args);
                } else {
                    WebPermissionUtil.logger.log(Level.WARNING, "AS-SECURITY-00008", args);
                }
            }
        }
    }
}

