/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.Result;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

public class DomainXmlVerifier {
    private Domain domain;
    public boolean error;
    PrintStream _out;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DomainXmlVerifier.class);

    public DomainXmlVerifier(Domain domain) throws Exception {
        this(domain, System.out);
    }

    public DomainXmlVerifier(Domain domain, PrintStream out) throws Exception {
        this.domain = domain;
        this._out = out;
        this.error = false;
    }

    public boolean invokeConfigValidator() {
        boolean failed = false;
        try {
            failed = this.validate();
        }
        catch (Exception e) {
            failed = true;
            e.printStackTrace();
        }
        return failed;
    }

    public boolean validate() {
        try {
            this.checkUnique(Dom.unwrap((ConfigBeanProxy)this.domain));
            if (!this.error) {
                this._out.println(strings.get("VerifySuccess"));
            }
        }
        catch (Exception e) {
            this.error = true;
            e.printStackTrace();
        }
        return this.error;
    }

    private void checkUnique(Dom d) {
        try {
            Set eltnames = d.getElementNames();
            Set leafeltnames = d.model.getLeafElementNames();
            for (String elt : eltnames) {
                if (leafeltnames.contains(elt)) continue;
                List eltlist = d.nodeElements(elt);
                this.checkDuplicate(eltlist);
                for (Dom subelt : eltlist) {
                    this.checkUnique(subelt);
                }
            }
        }
        catch (Exception e) {
            this.error = true;
            e.printStackTrace();
        }
    }

    private void output(Result result) {
        this._out.println(strings.get("VerifyError", new Object[]{result.result()}));
    }

    private void checkDuplicate(Collection<? extends Dom> beans) {
        if (beans == null || beans.size() <= 1) {
            return;
        }
        WeakHashMap<String, Dom> keyBeanMap = new WeakHashMap<String, Dom>();
        ArrayList<String> keys = new ArrayList<String>(beans.size());
        for (Dom dom : beans) {
            String key = dom.getKey();
            keyBeanMap.put(key, dom);
            keys.add(key);
        }
        WeakHashMap<String, Class> errorKeyBeanMap = new WeakHashMap<String, Class>();
        String[] stringArray = keys.toArray(new String[beans.size()]);
        block1: for (int i = 0; i < stringArray.length; ++i) {
            boolean foundDuplicate = false;
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (!stringArray[i].equals(stringArray[j])) continue;
                foundDuplicate = true;
                errorKeyBeanMap.put(stringArray[i], ((Dom)keyBeanMap.get(stringArray[i])).getProxyType());
                this.error = true;
                continue block1;
            }
        }
        for (Map.Entry e : errorKeyBeanMap.entrySet()) {
            Result result = new Result((Object)strings.get("VerifyDupKey", new Object[]{e.getKey(), e.getValue()}));
            this.output(result);
        }
    }
}

