/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="change-master-password")
@PerLookup
public class ChangeMasterPasswordCommand
extends CLICommand {
    @Inject
    private ServiceLocator habitat;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    private boolean savemp;
    @Param(name="domain_name_or_node_name", primary=true, optional=true)
    private String domainNameOrNodeName;
    @Param(name="nodedir", optional=true)
    protected String nodeDir;
    @Param(name="domaindir", optional=true)
    protected String domainDirParam = null;
    private final String CHANGE_MASTER_PASSWORD_DAS = "_change-master-password-das";
    private final String CHANGE_MASTER_PASSWORD_NODE = "_change-master-password-node";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeMasterPasswordCommand.class);

    protected int executeCommand() throws CommandException {
        CLICommand command = null;
        if (this.domainDirParam != null && this.nodeDir != null) {
            throw new CommandException(strings.get("both.domaindir.nodedir.not.allowed"));
        }
        try {
            if (this.isDomain()) {
                command = CLICommand.getCommand((ServiceLocator)this.habitat, (String)"_change-master-password-das");
                return command.execute(this.argv);
            }
            if (this.nodeDir != null) {
                command = CLICommand.getCommand((ServiceLocator)this.habitat, (String)"_change-master-password-node");
                return command.execute(this.argv);
            }
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(this.argv));
            arguments.remove(this.argv.length - 1);
            arguments.add("--nodedir");
            arguments.add(this.getDefaultNodesDirs().getAbsolutePath());
            arguments.add(this.domainNameOrNodeName);
            String[] newargs = arguments.toArray(new String[arguments.size()]);
            command = CLICommand.getCommand((ServiceLocator)this.habitat, (String)"_change-master-password-node");
            return command.execute(newargs);
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    public int execute(String ... args) throws CommandException {
        super.execute(args);
        return 0;
    }

    private boolean isDomain() throws IOException {
        DomainDirs domainDirs = null;
        if (this.domainDirParam == null && this.domainNameOrNodeName == null) {
            domainDirs = new DomainDirs(DomainDirs.getDefaultDomainsDir());
        } else {
            if (this.domainDirParam != null) {
                domainDirs = new DomainDirs(new File(this.domainDirParam), this.domainNameOrNodeName);
                return domainDirs.isValid();
            }
            if (this.domainNameOrNodeName != null) {
                return new File(DomainDirs.getDefaultDomainsDir(), this.domainNameOrNodeName).isDirectory();
            }
        }
        if (domainDirs != null) {
            return domainDirs.getDomainsDir().isDirectory();
        }
        return false;
    }

    private File getDefaultNodesDirs() throws IOException {
        return new File(DomainDirs.getDefaultDomainsDir().getParent(), "nodes");
    }
}

