/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class LoadResponseCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_response");
    private long version;
    private byte[] rawV;
    private long tokenId;
    private String originatingInstance;
    private String respondingInstanceName;

    public LoadResponseCommand() {
        super((byte)37);
    }

    public LoadResponseCommand(K key, long version, byte[] rawV) {
        this();
        super.setKey(key);
        this.version = version;
        this.rawV = rawV;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public long getVersion() {
        return this.version;
    }

    public void setOriginatingInstance(String originatingInstance) {
        this.originatingInstance = originatingInstance;
    }

    public byte[] getRawV() {
        return this.rawV;
    }

    @Override
    protected boolean beforeTransmit() {
        this.setTargetName(this.originatingInstance);
        return this.originatingInstance != null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.version);
        out.writeLong(this.tokenId);
        out.writeUTF(this.originatingInstance);
        out.writeUTF(this.dsc.getInstanceName());
        out.writeBoolean(this.rawV != null);
        if (this.rawV != null) {
            out.writeInt(this.rawV.length);
            out.write(this.rawV);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " sending load_response command for " + this.getKey() + " to " + this.originatingInstance + "; version = " + this.version + "; state = " + (this.rawV == null ? "NOT_FOUND" : Integer.valueOf(this.rawV.length)));
        }
    }

    private void readObject(ObjectInputStream ris) throws IOException {
        this.version = ris.readLong();
        this.tokenId = ris.readLong();
        this.originatingInstance = ris.readUTF();
        this.respondingInstanceName = ris.readUTF();
        boolean notNull = ris.readBoolean();
        if (notNull) {
            int vLen = ris.readInt();
            this.rawV = new byte[vLen];
            ris.readFully(this.rawV);
        }
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + " received load_response key=" + this.getKey() + "; version=" + this.version + "; from " + this.respondingInstanceName);
            }
            resp.setRespondingInstanceName(this.respondingInstanceName);
            resp.setResult(this);
        }
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.getKey() + ")";
    }
}

