/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.RadioButton;
import com.sun.webui.jsf.renderkit.html.RbCbRendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class RadioButtonRenderer
extends RbCbRendererBase {
    private final String MSG_COMPONENT_NOT_RADIOBUTTON = "RadioButtonRenderer only renders RadioButton components.";
    protected String[] styles = new String[]{"RADIOBUTTON", "RADIOBUTTON_DISABLED", "RADIOBUTTON_LABEL", "RADIOBUTTON_LABEL_DISABLED", "RADIOBUTTON_IMAGE", "RADIOBUTTON_IMAGE_DISABLED", "RADIOBUTTON_SPAN", "RADIOBUTTON_SPAN_DISABLED"};

    public void decode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        boolean inGroup;
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        RadioButton radioButton = (RadioButton)component;
        String name = radioButton.getName();
        boolean bl = inGroup = name != null;
        if (name == null) {
            name = component.getClientId(context);
        }
        if ((requestParameterMap = context.getExternalContext().getRequestParameterMap()).containsKey(name)) {
            String newValue = (String)requestParameterMap.get(name);
            Object selectedValue = radioButton.getSelectedValue();
            String selectedValueAsString = null;
            if (inGroup && selectedValue instanceof Boolean) {
                selectedValueAsString = component.getClientId(context);
                if (selectedValueAsString.equals(newValue)) {
                    ((UIInput)component).setSubmittedValue((Object)new String[]{selectedValue.toString()});
                    return;
                }
            } else {
                selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                if (selectedValueAsString.equals(newValue)) {
                    ((UIInput)component).setSubmittedValue((Object)new String[]{newValue});
                    return;
                }
            }
            ((UIInput)component).setSubmittedValue((Object)new String[0]);
        }
    }

    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof RadioButton)) {
            throw new IllegalArgumentException("RadioButtonRenderer only renders RadioButton components.");
        }
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderSelection(context, component, theme, writer, "radio");
    }

    protected boolean isSelected(FacesContext context, UIComponent component) {
        return ((RadioButton)component).isChecked();
    }

    protected String getStyle(Theme theme, int styleCode) {
        String style = null;
        try {
            style = theme.getStyleClass(this.styles[styleCode]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }
}

