/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.WebModule;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.glassfish.web.LogFacade;
import org.glassfish.web.valve.GlassFishValve;

public class AdHocContextValve
implements GlassFishValve {
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final String VALVE_INFO = "com.sun.enterprise.web.AdHocContextValve";
    private WebModule context;

    public AdHocContextValve(WebModule context) {
        this.context = context;
    }

    public String getInfo() {
        return VALVE_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(Request request, Response response) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String adHocServletName = this.context.getAdHocServletName(hreq.getServletPath());
        Wrapper adHocWrapper = (Wrapper)this.context.findChild(adHocServletName);
        if (adHocWrapper != null) {
            Servlet adHocServlet = null;
            try {
                adHocServlet = adHocWrapper.allocate();
                adHocServlet.service(hreq, hres);
            }
            catch (Throwable t) {
                hres.sendError(500);
                String msg = rb.getString("AS-WEB-GLUE-00050");
                msg = MessageFormat.format(msg, hreq.getServletPath());
                response.setDetailMessage(msg);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, msg, t);
                }
                int n = 2;
                return n;
            }
            finally {
                if (adHocServlet != null) {
                    adHocWrapper.deallocate(adHocServlet);
                }
            }
        } else {
            hres.sendError(500);
            String msg = rb.getString("AS-WEB-GLUE-00051");
            msg = MessageFormat.format(msg, hreq.getServletPath());
            response.setDetailMessage(msg);
            return 2;
        }
        return 2;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
    }
}

