/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.Serializable;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletMapping;
import javax.servlet.http.MappingMatch;
import org.apache.catalina.LogFacade;
import org.glassfish.grizzly.http.server.util.MappingData;

public class MappingImpl
implements HttpServletMapping,
Serializable {
    private static final long serialVersionUID = -5134622427867249518L;
    private String matchValue;
    private String pattern;
    private String servletName;
    private MappingMatch mappingMatch;
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    public MappingImpl(MappingData mappingData) {
        if (null == mappingData) {
            throw new NullPointerException(rb.getString("AS-WEB-CORE-00185"));
        }
        this.matchValue = null != mappingData.matchedPath && mappingData.matchedPath.length() >= 2 ? mappingData.matchedPath.substring(1) : "";
        this.pattern = null != mappingData.descriptorPath ? mappingData.descriptorPath : "";
        this.servletName = null != mappingData.servletName ? mappingData.servletName : "";
        switch (mappingData.mappingType) {
            case 1: {
                this.mappingMatch = MappingMatch.CONTEXT_ROOT;
                break;
            }
            case 2: {
                this.mappingMatch = MappingMatch.DEFAULT;
                this.matchValue = "";
                break;
            }
            case 4: {
                this.mappingMatch = MappingMatch.EXACT;
                break;
            }
            case 8: {
                int i;
                this.mappingMatch = MappingMatch.EXTENSION;
                if (null == this.pattern || '*' != this.pattern.charAt(0) || -1 == (i = this.matchValue.indexOf(this.pattern.substring(1)))) break;
                this.matchValue = this.matchValue.substring(0, i);
                break;
            }
            case 16: {
                int patternLen;
                this.mappingMatch = MappingMatch.PATH;
                if (null == this.pattern || 0 >= (patternLen = this.pattern.length()) || '*' != this.pattern.charAt(patternLen - 1)) break;
                int indexOfPatternStart = patternLen - 2;
                int matchValueLen = this.matchValue.length();
                if (0 > indexOfPatternStart || indexOfPatternStart >= matchValueLen) break;
                this.matchValue = this.matchValue.substring(indexOfPatternStart);
            }
        }
    }

    @Override
    public String getMatchValue() {
        return this.matchValue;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getServletName() {
        return this.servletName;
    }

    @Override
    public MappingMatch getMappingMatch() {
        return this.mappingMatch;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.matchValue);
        hash = 29 * hash + Objects.hashCode(this.pattern);
        hash = 29 * hash + Objects.hashCode(this.servletName);
        hash = 29 * hash + Objects.hashCode((Object)this.mappingMatch);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingImpl other = (MappingImpl)obj;
        if (!Objects.equals(this.matchValue, other.matchValue)) {
            return false;
        }
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        if (!Objects.equals(this.servletName, other.servletName)) {
            return false;
        }
        return this.mappingMatch == other.mappingMatch;
    }

    public String toString() {
        return "MappingImpl{matchValue=" + this.matchValue + ", pattern=" + this.pattern + ", servletName=" + this.servletName + ", mappingMatch=" + (Object)((Object)this.mappingMatch) + '}';
    }
}

