/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.server.logging.commands.TargetInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@Service(name="set-log-levels")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set.log.level")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-log-levels", description="set-log-levels")})
public class SetLogLevel
implements AdminCommand {
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    Domain domain;
    String[] validLevels = new String[]{"ALL", "OFF", "EMERGENCY", "ALERT", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetLogLevel.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuffer successMsg = new StringBuffer();
        boolean success = false;
        boolean invalidLogLevels = false;
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String logger_name = (String)key;
                String level = (String)this.properties.get(logger_name);
                boolean vlvl = false;
                for (String s : this.validLevels) {
                    if (!s.equals(level)) continue;
                    m.put(logger_name + ".level", level);
                    vlvl = true;
                    successMsg.append(localStrings.getLocalString("set.log.level.properties", "{0} package set with log level {1}.\n", new Object[]{logger_name, level}));
                }
                if (vlvl) continue;
                report.setMessage(localStrings.getLocalString("set.log.level.invalid", "Invalid logger level found {0}.  Valid levels are: SEVERE, WARNING, INFO, FINE, FINER, FINEST", new Object[]{level}));
                invalidLogLevels = true;
                break;
            }
            if (invalidLogLevels) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            TargetInfo targetInfo = new TargetInfo(this.domain, this.target);
            String targetConfigName = targetInfo.getConfigName();
            boolean isDas = targetInfo.isDas();
            if (targetConfigName != null && !targetConfigName.isEmpty()) {
                this.loggingConfig.updateLoggingProperties(m, targetConfigName);
                success = true;
            } else if (isDas) {
                this.loggingConfig.updateLoggingProperties(m);
                success = true;
            }
            if (success) {
                successMsg.append(localStrings.getLocalString("set.log.level.success", "These logging levels are set for {0}.", new Object[]{this.target}));
                report.setMessage(successMsg.toString());
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (IOException e) {
            report.setMessage(localStrings.getLocalString("set.log.level.failed", "Could not set logger levels for {0}.", new Object[]{this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

