/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class Util {
    private Util() {
    }

    public static boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (a != null && b == null) {
            return false;
        }
        if (!Util.isEqual(a.getUserName(), b.getUserName())) {
            return false;
        }
        String p1 = null;
        String p2 = null;
        if (a.getPassword() != null) {
            p1 = new String(a.getPassword());
        }
        if (b.getPassword() != null) {
            p2 = new String(b.getPassword());
        }
        return Util.isEqual(p1, p2);
    }

    public static PasswordCredential getPasswordCredential(ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo myinfo) throws ResourceException {
        String username2use = null;
        String password2use = null;
        PasswordCredential pc = null;
        if (subject != null) {
            pc = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                    if (creds == null) {
                        return null;
                    }
                    for (PasswordCredential temp : creds) {
                        if (temp == null || temp.getUserName() == null) continue;
                        return temp;
                    }
                    return null;
                }
            });
        }
        if (pc != null) {
            return pc;
        }
        if (myinfo != null) {
            if (myinfo.getUserName() != null) {
                username2use = myinfo.getUserName();
                password2use = myinfo.getPassword();
            } else {
                username2use = mcf.getUserName();
                password2use = mcf.getPassword();
            }
        } else {
            username2use = mcf.getUserName();
            password2use = mcf.getPassword();
        }
        char[] password = password2use.toCharArray();
        pc = new PasswordCredential(username2use, password);
        return pc;
    }

    public static boolean isPasswordCredentialValid(final Subject subject) throws ResourceException {
        if (subject == null) {
            return false;
        }
        Boolean pwcValid = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                if (creds == null) {
                    return false;
                }
                for (PasswordCredential temp : creds) {
                    String un;
                    if (temp == null || (un = temp.getUserName()) == null || "".equals(un)) continue;
                    return true;
                }
                return false;
            }
        });
        return pwcValid;
    }

    public static PasswordCredential getPasswordCredentialOld(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo myinfo) throws ResourceException {
        if (subject == null) {
            if (myinfo == null) {
                return null;
            }
            if (myinfo.getUserName() == null || myinfo.getPassword() == null) {
                return null;
            }
            char[] password = myinfo.getPassword().toCharArray();
            PasswordCredential pc = new PasswordCredential(myinfo.getUserName(), password);
            pc.setManagedConnectionFactory((javax.resource.spi.ManagedConnectionFactory)mcf);
            return pc;
        }
        PasswordCredential pc = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                for (PasswordCredential temp : creds) {
                    if (temp == null || temp.getManagedConnectionFactory() == null || !temp.getManagedConnectionFactory().equals((Object)mcf)) continue;
                    return temp;
                }
                return null;
            }
        });
        if (pc == null) {
            throw new SecurityException("MQRA:U:getPC:Null credentials");
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object jndiLookup(String jndiName) throws NamingException {
        InitialContext ic = null;
        Object obj = null;
        try {
            ic = new InitialContext();
            obj = ic.lookup(jndiName);
        }
        finally {
            if (ic != null) {
                try {
                    ic.close();
                }
                catch (Exception exception) {}
            }
        }
        return obj;
    }
}

