/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.ReadOnlyPropertyException;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrOptions;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrPrinter;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrProperties;
import com.sun.messaging.jmq.admin.apps.objmgr.Utils;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import java.util.Properties;

public class CmdPreviewer
implements ObjMgrOptions {
    private AdminResources ar = Globals.getAdminResources();
    private ObjMgrProperties objMgrProps;

    public CmdPreviewer(ObjMgrProperties props) {
        this.objMgrProps = props;
    }

    public void previewCommands() {
        Globals.stdOutPrintln(this.ar.getString("A1067"));
        String cmd = this.objMgrProps.getCommand();
        if (cmd.equals("add")) {
            this.previewAddCommand(this.objMgrProps);
        } else if (cmd.equals("delete")) {
            this.previewDeleteCommand(this.objMgrProps);
        } else if (cmd.equals("query")) {
            this.previewQueryCommand(this.objMgrProps);
        } else if (cmd.equals("list")) {
            this.previewListCommand(this.objMgrProps);
        } else if (cmd.equals("update")) {
            this.previewUpdateCommand(this.objMgrProps);
        }
    }

    private void previewAddCommand(ObjMgrProperties objMgrProps) {
        String type = objMgrProps.getObjType();
        Properties objProps = objMgrProps.getObjProperties();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        String lookupName = objMgrProps.getLookupName();
        boolean force = objMgrProps.forceModeSet();
        Object newObj = null;
        try {
            if (type.equals("q")) {
                newObj = JMSObjFactory.createQueue(objProps);
            } else if (type.equals("t")) {
                newObj = JMSObjFactory.createTopic(objProps);
            } else if (type.equals("xqf")) {
                newObj = JMSObjFactory.createXAQueueConnectionFactory(objProps);
            } else if (type.equals("xtf")) {
                newObj = JMSObjFactory.createXATopicConnectionFactory(objProps);
            } else if (type.equals("xcf")) {
                newObj = JMSObjFactory.createXAConnectionFactory(objProps);
            } else if (type.equals("qf")) {
                newObj = JMSObjFactory.createQueueConnectionFactory(objProps);
            } else if (type.equals("tf")) {
                newObj = JMSObjFactory.createTopicConnectionFactory(objProps);
            } else if (type.equals("cf")) {
                newObj = JMSObjFactory.createConnectionFactory(objProps);
            }
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(this.ar.getString("A1037"));
            return;
        }
        if (force) {
            Globals.stdOutPrintln(this.ar.getString("A1069"));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1068"));
        }
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1070", Utils.getObjTypeString(type)));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(2, 4);
        omp.printObjPropertiesFromObj((AdministeredObject)newObj);
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(objMgrProps.readOnlyValue());
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1101"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1102"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp2 = new ObjMgrPrinter(osa, 2, 4);
        omp2.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1023"));
    }

    private void previewDeleteCommand(ObjMgrProperties objMgrProps) {
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        String lookupName = objMgrProps.getLookupName();
        boolean force = objMgrProps.forceModeSet();
        if (force) {
            Globals.stdOutPrintln(this.ar.getString("A1069"));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1068"));
        }
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1071"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1104"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1024"));
    }

    private void previewQueryCommand(ObjMgrProperties objMgrProps) {
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        String lookupName = objMgrProps.getLookupName();
        Globals.stdOutPrintln(this.ar.getString("A1072"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1106"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1034"));
    }

    private void previewListCommand(ObjMgrProperties objMgrProps) {
        String type = objMgrProps.getObjType();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        String typeString = Utils.getObjTypeString(type);
        if (typeString != null) {
            Globals.stdOutPrintln(this.ar.getString("A1073", typeString));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1074"));
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1035"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void previewUpdateCommand(ObjMgrProperties objMgrProps) {
        ObjMgrPrinter omp;
        String type = objMgrProps.getObjType();
        Properties objProps = objMgrProps.getObjProperties();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        String lookupName = objMgrProps.getLookupName();
        boolean force = objMgrProps.forceModeSet();
        String typeString = Utils.getObjTypeString(type);
        if (force) {
            Globals.stdOutPrintln(this.ar.getString("A1069"));
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1068"));
        }
        Globals.stdOutPrintln("");
        if (typeString != null) {
            block14: {
                Object tempObj = null;
                try {
                    if (type.equals("q")) {
                        tempObj = JMSObjFactory.createQueue(objProps);
                        break block14;
                    }
                    if (type.equals("t")) {
                        tempObj = JMSObjFactory.createTopic(objProps);
                        break block14;
                    }
                    if (type.equals("xqf")) {
                        tempObj = JMSObjFactory.createXAQueueConnectionFactory(objProps);
                        break block14;
                    }
                    if (type.equals("xtf")) {
                        tempObj = JMSObjFactory.createXATopicConnectionFactory(objProps);
                        break block14;
                    }
                    if (type.equals("xcf")) {
                        tempObj = JMSObjFactory.createXAConnectionFactory(objProps);
                        break block14;
                    }
                    if (type.equals("qf")) {
                        tempObj = JMSObjFactory.createQueueConnectionFactory(objProps);
                        break block14;
                    }
                    if (type.equals("tf")) {
                        tempObj = JMSObjFactory.createTopicConnectionFactory(objProps);
                        break block14;
                    }
                    if (type.equals("cf")) {
                        tempObj = JMSObjFactory.createConnectionFactory(objProps);
                    }
                }
                catch (Exception e) {
                    this.handleRunCommandExceptions(e, lookupName);
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(this.ar.getString("A1036"));
                    return;
                }
            }
            Globals.stdOutPrintln(this.ar.getString("A1075", typeString));
            Globals.stdOutPrintln("");
            ObjMgrPrinter omp2 = new ObjMgrPrinter(objProps, 2, 4);
            omp2.print();
        } else {
            Globals.stdOutPrintln(this.ar.getString("A1076"));
            Globals.stdOutPrintln("");
            omp = new ObjMgrPrinter(objProps, 2, 4);
            omp.print();
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(objMgrProps.readOnlyValue());
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1077"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1112"));
        Globals.stdOutPrintln("");
        omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(this.ar.getString("A1025"));
    }

    private void handleRunCommandExceptions(Exception e, String lookupName) {
        if (e instanceof InvalidPropertyException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3070", e.getMessage()));
            Globals.stdErrPrintln("");
            Globals.stdErrPrintln(this.ar.getString("A1623"));
        } else if (e instanceof InvalidPropertyValueException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3072", e.getMessage()));
        } else if (e instanceof ReadOnlyPropertyException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3071"));
        }
    }
}

