/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;

public class ConsoleHelp {
    private static String[] hsURLStrs = new String[]{"Master.hs"};
    public static final int CONSOLE_HELP = 0;
    static HelpBroker[] hb;
    static HelpSet[] hs;
    static CSH.DisplayHelpFromSource[] hl;
    private static boolean helpLoaded;
    private static Exception helpLoadException;

    public static boolean helpLoaded() {
        return helpLoaded;
    }

    public static Exception getHelpLoadException() {
        return helpLoadException;
    }

    public static void loadHelp() {
        if (helpLoaded) {
            return;
        }
        int hsTotal = hsURLStrs.length;
        try {
            Class<?> c = Class.forName("javax.help.HelpBroker");
            c = Class.forName("javax.help.HelpSet");
            c = Class.forName("javax.help.CSH");
        }
        catch (Exception e) {
            helpLoadException = e;
            return;
        }
        hb = new HelpBroker[hsTotal];
        hs = new HelpSet[hsTotal];
        hl = new CSH.DisplayHelpFromSource[hsTotal];
        for (int i = 0; i < hsTotal; ++i) {
            String fileName = hsURLStrs[i];
            try {
                URL hsURL = HelpSet.findHelpSet(null, (String)fileName);
                if (hsURL == null) {
                    return;
                }
                ConsoleHelp.hs[i] = new HelpSet(null, hsURL);
                ConsoleHelp.hb[i] = hs[i].createHelpBroker();
                ConsoleHelp.hl[i] = new CSH.DisplayHelpFromSource(hb[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("HelpSet " + fileName + " not found.");
                return;
            }
        }
        helpLoaded = true;
    }

    static {
        helpLoaded = false;
        helpLoadException = null;
    }
}

