/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.OptionTitle;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.EndGroup;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.model.list.StartGroup;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ValueType;
import java.beans.Beans;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class ListSelector
extends Selector
implements ListManager,
NamingContainer {
    private static final boolean DEBUG = false;
    protected ArrayList listItems = null;
    private int separatorLength = 0;
    private static final String READONLY_ID = "_readOnly";
    private static final String LABEL_ID = "_label";
    private static final String READONLY_FACET = "readOnly";
    private static final String LABEL_FACET = "label";
    public static final String VALUE_ID = "_list_value";
    public static final String VALUE_LABEL_ID = "_hiddenlabel";
    public static final String LIST_ID = "_list";
    private boolean labelOnTop = false;
    private boolean labelOnTop_set = false;
    private int rows = Integer.MIN_VALUE;
    private boolean rows_set = false;
    private boolean separators = false;
    private boolean separators_set = false;
    private boolean visible = false;
    private boolean visible_set = false;

    public ListSelector() {
        this.setRendererType("com.sun.webui.jsf.ListSelectorRenderer");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.ListSelector";
    }

    public void checkSelectionModel(FacesContext context) {
        if (this.isMultiple() && this.valueTypeEvaluator.getValueType() != ValueType.ARRAY) {
            Object[] params = new Object[]{this.toString()};
            String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Selector.multipleError", params);
            throw new RuntimeException(msg);
        }
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        this.listItems = new ArrayList();
        this.separatorLength = 0;
        this.processOptions(this.getOptions());
        this.processSelections();
        return this.listItems.iterator();
    }

    public Iterator getListItems() throws FacesException {
        if (this.listItems != null) {
            return this.listItems.iterator();
        }
        this.listItems = new ArrayList();
        this.processOptions(this.getOptions());
        return this.listItems.iterator();
    }

    public int getSeparatorLength() {
        return this.separatorLength;
    }

    protected Option[] getOptions() {
        Option[] options = null;
        Object optionsObject = this.getItems();
        if (optionsObject instanceof Option[]) {
            options = (Option[])optionsObject;
        } else if (optionsObject instanceof Collection) {
            Object[] objects = ((Collection)optionsObject).toArray();
            if (objects == null || objects.length == 0) {
                options = new Option[]{};
            }
            int numObjects = objects.length;
            options = new Option[numObjects];
            for (int counter = 0; counter < numObjects; ++counter) {
                options[counter] = (Option)((Object)objects[counter]);
            }
        } else if (optionsObject instanceof Map) {
            Collection itemsCollection = ((Map)optionsObject).values();
            options = (Option[])itemsCollection.toArray();
        } else {
            options = new Option[]{};
        }
        return options;
    }

    protected void processOptions(Option[] options) {
        int length = options.length;
        for (int counter = 0; counter < length; ++counter) {
            if (options[counter] instanceof OptionGroup) {
                OptionGroup selectionGroup = (OptionGroup)options[counter];
                String groupLabel = selectionGroup.getLabel();
                if ((double)groupLabel.length() * 1.5 > (double)this.separatorLength) {
                    this.separatorLength = (int)((double)groupLabel.length() * 1.5);
                }
                this.listItems.add(new StartGroup(groupLabel));
                this.processOptions(selectionGroup.getOptions());
                this.listItems.add(new EndGroup());
                continue;
            }
            if (options[counter] instanceof Separator) {
                this.listItems.add(options[counter]);
                continue;
            }
            this.listItems.add(this.createListItem(options[counter]));
        }
    }

    protected void processSelections() {
        Object value = this.getSubmittedValue();
        if (value != null) {
            if (value instanceof String[]) {
                String[] obj = (String[])value;
                ArrayList<String> list = new ArrayList<String>(obj.length);
                for (int counter = 0; counter < obj.length; ++counter) {
                    list.add(obj[counter]);
                }
                this.markSelectedListItems(list, false);
                return;
            }
            throw new IllegalArgumentException("Illegal submitted value");
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.NONE || this.valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            this.markSelectedListItems(new ArrayList(), true);
            return;
        }
        value = this.getValue();
        if (value == null) {
            this.markSelectedListItems(new ArrayList(), true);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            int length = Array.getLength(value);
            for (int counter = 0; counter < length; ++counter) {
                list.add(Array.get(value, counter));
            }
            this.markSelectedListItems(list, true);
            return;
        }
        list.add(value);
        this.markSelectedListItems(list, true);
    }

    protected void markSelectedListItems(List list, boolean processed) {
        ListItem option = null;
        Object nextItem = null;
        Iterator items = this.listItems.iterator();
        Iterator selected = null;
        block0: while (items.hasNext()) {
            nextItem = items.next();
            if (!(nextItem instanceof ListItem)) continue;
            option = nextItem;
            option.setSelected(false);
            if (list.isEmpty()) continue;
            selected = list.iterator();
            while (selected.hasNext()) {
                if (processed) {
                    Object o = selected.next();
                    if (!option.getValueObject().equals(o)) continue;
                    option.setSelected(true);
                    list.remove(o);
                    continue block0;
                }
                String s = (String)selected.next();
                if (!s.equals(option.getValue())) continue;
                option.setSelected(true);
                list.remove(s);
                continue block0;
            }
        }
        if (!list.isEmpty() && !Beans.isDesignTime()) {
            String msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "List.badValue", new Object[]{this.getClientId(FacesContext.getCurrentInstance())});
            this.log(msg);
        }
    }

    protected ListItem createListItem(Option si) {
        String label = si.getLabel();
        String valueString = ConversionUtilities.convertValueToString((UIComponent)this, si.getValue());
        if (label == null) {
            label = valueString;
        }
        if ((double)label.length() * 1.5 > (double)this.separatorLength) {
            this.separatorLength = (int)((double)label.length() * 1.5);
        }
        ListItem listItem = new ListItem(si.getValue(), label, si.getDescription(), si.isDisabled());
        listItem.setValue(valueString);
        if (si instanceof OptionTitle) {
            listItem.setTitle(true);
        }
        return listItem;
    }

    public UIComponent getLabelComponent() {
        UIComponent labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent != null) {
            return labelComponent;
        }
        String labelString = this.getLabel();
        if (labelString == null) {
            return null;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, LABEL_FACET, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, LABEL_FACET));
        }
        this.initLabelFacet(label, labelString, this.getClientId(this.getFacesContext()));
        ComponentUtilities.putPrivateFacet((UIComponent)this, LABEL_FACET, (UIComponent)label);
        return label;
    }

    private void initLabelFacet(Label label, String labelString, String forComponentId) {
        if (labelString == null || labelString.length() < 1) {
            labelString = new String();
        }
        label.setText(labelString);
        label.setLabelLevel(this.getLabelLevel());
        if (!this.isReadOnly()) {
            label.setFor(forComponentId);
        }
    }

    public UIComponent getReadOnlyValueComponent() {
        UIComponent textComponent = this.getFacet(READONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        StaticText text = new StaticText();
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READONLY_FACET));
        text.setParent((UIComponent)this);
        FacesContext context = FacesContext.getCurrentInstance();
        String readOnlyString = this.getValueAsReadOnly(context);
        if (readOnlyString == null || readOnlyString.length() < 1) {
            readOnlyString = new String();
        }
        text.setText(readOnlyString);
        return text;
    }

    public String[] getValueAsStringArray(FacesContext context) {
        String[] values = null;
        Object value = this.getSubmittedValue();
        if (value != null) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                values = new String[]{(String)value};
                return values;
            }
        }
        if ((value = this.getValue()) == null) {
            return new String[0];
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.NONE) {
            return new String[0];
        }
        if (this.valueTypeEvaluator.getValueType() == ValueType.INVALID) {
            return new String[0];
        }
        int counter = 0;
        if (this.valueTypeEvaluator.getValueType() == ValueType.LIST) {
            List list = (List)value;
            counter = list.size();
            values = new String[counter];
            Iterator valueIterator = ((List)value).iterator();
            String valueString = null;
            counter = 0;
            while (valueIterator.hasNext()) {
                valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueIterator.next());
                values[counter++] = valueString;
            }
        } else if (this.valueTypeEvaluator.getValueType() == ValueType.ARRAY) {
            counter = Array.getLength(value);
            values = new String[counter];
            Object valueObject = null;
            String valueString = null;
            for (int i = 0; i < counter; ++i) {
                valueObject = Array.get(value, i);
                values[i] = valueString = ConversionUtilities.convertValueToString((UIComponent)this, valueObject);
            }
        } else if (this.valueTypeEvaluator.getValueType() == ValueType.OBJECT) {
            values = new String[]{ConversionUtilities.convertValueToString((UIComponent)this, value)};
        }
        return values;
    }

    public String getLabeledElementId(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent();
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(LIST_ID);
    }

    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public String getValueAsReadOnly(FacesContext context, String separator) {
        return "FIX ME!";
    }

    public boolean mainListSubmits() {
        return true;
    }

    public boolean isLabelOnTop() {
        if (this.labelOnTop_set) {
            return this.labelOnTop;
        }
        ValueExpression _vb = this.getValueExpression("labelOnTop");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setLabelOnTop(boolean labelOnTop) {
        this.labelOnTop = labelOnTop;
        this.labelOnTop_set = true;
    }

    public int getRows() {
        if (this.rows_set) {
            return this.rows;
        }
        ValueExpression _vb = this.getValueExpression("rows");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 12;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.rows_set = true;
    }

    public boolean isSeparators() {
        if (this.separators_set) {
            return this.separators;
        }
        ValueExpression _vb = this.getValueExpression("separators");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setSeparators(boolean separators) {
        this.separators = separators;
        this.separators_set = true;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.labelOnTop = (Boolean)_values[1];
        this.labelOnTop_set = (Boolean)_values[2];
        this.rows = (Integer)_values[3];
        this.rows_set = (Boolean)_values[4];
        this.separators = (Boolean)_values[5];
        this.separators_set = (Boolean)_values[6];
        this.visible = (Boolean)_values[7];
        this.visible_set = (Boolean)_values[8];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this.labelOnTop ? Boolean.TRUE : Boolean.FALSE, this.labelOnTop_set ? Boolean.TRUE : Boolean.FALSE, new Integer(this.rows), this.rows_set ? Boolean.TRUE : Boolean.FALSE, this.separators ? Boolean.TRUE : Boolean.FALSE, this.separators_set ? Boolean.TRUE : Boolean.FALSE, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

