/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.ext;

import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.KeyNotFoundException;
import com.sun.messaging.bridge.api.UpdateOpaqueDataCallback;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ext.TMLogRecordDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TMLogRecordDAOJMSBG
extends BaseDAOImpl
implements TMLogRecordDAO {
    private final String tableName;
    public static final String TABLE = "MQTMLRJMSBG";
    public static final String TABLE_NAME_PREFIX = "MQTMLRJMSBG41";
    private final String insertSQL;
    private final String updateLogRecordSQL;
    private final String deleteSQL;
    private final String selectLogRecordSQL;
    private final String selectUpdatedTimeSQL;
    private final String selectCreatedTimeSQL;
    private final String selectLogRecordsByNameByBrokerSQL;
    private final String selectTMNamesByBrokerSQL;

    public TMLogRecordDAOJMSBG() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName(TABLE_NAME_PREFIX);
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("XID").append(", ").append("LOG_RECORD").append(", ").append("NAME").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(", ").append("UPDATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?)").toString();
        this.updateLogRecordSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOG_RECORD").append(" = ?, ").append("UPDATED_TS").append(" = ? ").append(" WHERE ").append("XID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectLogRecordSQL = new StringBuffer(128).append("SELECT ").append("LOG_RECORD").append(" FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectUpdatedTimeSQL = new StringBuffer(128).append("SELECT ").append("UPDATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").toString();
        this.selectCreatedTimeSQL = new StringBuffer(128).append("SELECT ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").toString();
        this.selectLogRecordsByNameByBrokerSQL = new StringBuffer(128).append("SELECT ").append("XID").append(", ").append("LOG_RECORD").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectTMNamesByBrokerSQL = new StringBuffer(128).append("SELECT ").append("NAME").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return TABLE_NAME_PREFIX;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, String xid, byte[] logRecord, String name, Logger logger_) throws DupKeyException, Exception {
        Connection myconn = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            try {
                pstmt = DBManager.createPreparedStatement(conn, this.insertSQL);
                pstmt.setString(1, xid);
                pstmt.setBytes(2, logRecord);
                pstmt.setString(3, name);
                pstmt.setString(4, dbMgr.getBrokerID());
                pstmt.setLong(5, System.currentTimeMillis());
                pstmt.setLong(6, 0L);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                myex = e;
                try {
                    if (!conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    String emsg = "B4080";
                    this.logger.log(32, emsg, (Throwable)e1);
                    Util.logExt(logger_, Level.SEVERE, emsg, e1);
                }
                this.checkDupKeyOnException(conn, xid, logger_);
                throw e;
            }
            this.closeSQL(null, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateLogRecord(Connection conn, String xid, byte[] logRecord, String name, UpdateOpaqueDataCallback callback, boolean addIfNotExist, Logger logger_) throws KeyNotFoundException, StoreBeingTakenOverException, Exception {
        byte[] currLogRecord;
        DBManager dbMgr;
        Connection myconn = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(false);
            }
            if (conn.getAutoCommit()) {
                throw new BrokerException("Broker Internal Error: Unexpected auto commit SQL connection for update TM log record: " + xid);
            }
            currLogRecord = null;
            currLogRecord = this.getLogRecord(conn, xid, name, logger_);
            if (currLogRecord == null) {
                if (!addIfNotExist) throw new KeyNotFoundException("TM log record not found for " + xid);
                this.insert(conn, xid, logRecord, name, logger_);
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                return;
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn == null) throw e;
                    if (conn.getAutoCommit()) throw e;
                    conn.rollback();
                    throw e;
                }
                catch (SQLException e1) {
                    String emsg = "B4080";
                    this.logger.log(32, emsg, (Throwable)e1);
                    Util.logExt(logger_, Level.SEVERE, emsg, e1);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        {
            byte[] newLogRecord = (byte[])callback.update(currLogRecord);
            pstmt = DBManager.createPreparedStatement(conn, this.updateLogRecordSQL);
            pstmt.setBytes(1, newLogRecord);
            pstmt.setLong(2, System.currentTimeMillis());
            pstmt.setString(3, xid);
            pstmt.setString(4, dbMgr.getBrokerID());
            if (pstmt.executeUpdate() == 0) {
                Util.checkBeingTakenOver(conn, dbMgr, this.logger, logger_);
                throw new BrokerException(this.br.getKString("TM Log record not found in store for " + xid), 404);
            }
            if (myconn != null) {
                conn.commit();
            }
            this.closeSQL(null, pstmt, myconn, myex, logger_);
            return;
        }
    }

    @Override
    public void delete(Connection conn, String xid, String name, Logger logger_) throws KeyNotFoundException, Exception {
        Connection myconn = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = DBManager.createPreparedStatement(conn, this.deleteSQL);
            pstmt.setString(1, xid);
            pstmt.setString(2, dbMgr.getBrokerID());
            if (pstmt.executeUpdate() == 0) {
                throw new KeyNotFoundException("TM log record not found in store for " + xid);
            }
            this.closeSQL(null, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    String emsg = "B4080";
                    this.logger.log(32, emsg, (Throwable)e1);
                    Util.logExt(logger_, Level.SEVERE, emsg, e1);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(null, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
    }

    @Override
    public void deleteAllByName(Connection conn, String name, Logger logger_) throws KeyNotFoundException, Exception {
        DBManager dbMgr = DBManager.getDBManager();
        String whereClause = new StringBuffer(128).append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("'").append(" AND ").append("NAME").append(" = '").append(name).append("'").toString();
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        String whereClause = new StringBuffer(128).append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("'").toString();
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public byte[] getLogRecord(Connection conn, String xid, String name, Logger logger_) throws Exception {
        Exception myex;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection myconn;
        byte[] logRecord;
        block9: {
            logRecord = null;
            myconn = null;
            pstmt = null;
            rs = null;
            myex = null;
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = DBManager.createPreparedStatement(conn, this.selectLogRecordSQL);
            pstmt.setString(1, xid);
            pstmt.setString(2, dbMgr.getBrokerID());
            rs = pstmt.executeQuery();
            if (rs.next()) break block9;
            byte[] byArray = null;
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
            return byArray;
        }
        try {
            logRecord = Util.readBytes(rs, 1);
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectLogRecordSQL + "]", (Throwable)rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return logRecord;
    }

    @Override
    public long getUpdatedTime(Connection conn, String xid, String name, Logger logger_) throws KeyNotFoundException, Exception {
        long updatedTime = -1L;
        Connection myconn = conn;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = DBManager.createPreparedStatement(conn, this.selectUpdatedTimeSQL);
            pstmt.setString(1, xid);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new KeyNotFoundException("TM Log record not found in store for xid " + xid);
            }
            updatedTime = rs.getLong(1);
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectUpdatedTimeSQL + "]", (Throwable)rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return updatedTime;
    }

    @Override
    public long getCreatedTime(Connection conn, String xid, String name, Logger logger_) throws KeyNotFoundException, Exception {
        long createdTime = -1L;
        Connection myconn = conn;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = DBManager.createPreparedStatement(conn, this.selectCreatedTimeSQL);
            pstmt.setString(1, xid);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new KeyNotFoundException("TM Log record not found in store for xid " + xid);
            }
            createdTime = rs.getLong(1);
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectCreatedTimeSQL + "]", (Throwable)rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return createdTime;
    }

    @Override
    public List getLogRecordsByNameByBroker(Connection conn, String name, String brokerID, Logger logger_) throws Exception {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        Connection myconn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = DBManager.createPreparedStatement(conn, this.selectLogRecordsByNameByBrokerSQL);
            pstmt.setString(1, name);
            pstmt.setString(2, brokerID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(Util.readBytes(rs, 2));
            }
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectLogRecordsByNameByBrokerSQL + "]", (Throwable)rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return list;
    }

    @Override
    public List getNamesByBroker(Connection conn, String brokerID, Logger logger_) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection myconn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                myconn = conn = dbMgr.getConnection(true);
            }
            pstmt = DBManager.createPreparedStatement(conn, this.selectTMNamesByBrokerSQL);
            pstmt.setString(1, brokerID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            this.closeSQL(rs, pstmt, myconn, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (conn != null && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectTMNamesByBrokerSQL + "]", (Throwable)rbe);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, myconn, myex, logger_);
                throw throwable;
            }
        }
        return list;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("JMSBridgeTMLogRecord(" + this.tableName + ")", String.valueOf(count));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDupKeyOnException(Connection conn, String xid, Logger logger_) throws DupKeyException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception myex = null;
        try {
            DBManager.getDBManager();
            pstmt = DBManager.createPreparedStatement(conn, this.selectCreatedTimeSQL);
            pstmt.setString(1, xid);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                throw new DupKeyException("Xid " + xid + " already exists in DB");
            }
            this.closeSQL(rs, pstmt, null, myex, logger_);
        }
        catch (Exception e) {
            try {
                myex = e;
                try {
                    if (!conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException rbe) {
                    this.logger.log(32, "B4080[" + this.selectCreatedTimeSQL + "]", (Throwable)rbe);
                }
                if (e instanceof DupKeyException) {
                    throw (DupKeyException)e;
                }
                String emsg = this.br.getKString("B4117", "Exception on checkDupKey for xid " + xid);
                this.logger.log(16, emsg, (Throwable)e);
                Util.logExt(logger_, Level.WARNING, emsg, e);
                this.closeSQL(rs, pstmt, null, myex, logger_);
            }
            catch (Throwable throwable) {
                this.closeSQL(rs, pstmt, null, myex, logger_);
                throw throwable;
            }
        }
    }

    private void closeSQL(ResultSet rset, PreparedStatement pstmt, Connection conn, Throwable myex, Logger logger_) {
        try {
            Util.close(rset, pstmt, conn, myex);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String emsg = "Unable to close SQL connection or statement: " + e.getMessage() + (cause == null ? "" : " - " + cause.getMessage());
            this.logger.log(16, emsg, (Throwable)e);
            Util.logExt(logger_, Level.WARNING, emsg, e);
        }
    }
}

