/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.GenericDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.HADBDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MySQLDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.OracleDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public final class DBManager
extends CommDBManager
implements DBConstants {
    private static final String STORE_TYPE_PROP = "imq.persist.store";
    public static final String JDBC_PROP_PREFIX = "imq.persist.jdbc";
    public static final String FALLBACK_USER_PROP = "imq.persist.jdbc.user";
    public static final String FALLBACK_PWD_PROP = "imq.persist.jdbc.password";
    private static final String BROKERID_PROP = "imq.brokerid";
    private static final int LONGEST_TABLENAME_LEN = 17;
    private String clusterID = null;
    private String brokerID = null;
    private DAOFactory daoFactory = null;
    private DBConnectionPool dbpool = null;
    private boolean storeInited = false;
    private static final Object classLock = DBManager.class;
    private static volatile DBManager dbMgr = null;
    private static String[] v370tableNames = new String[]{"IMQSV37", "IMQCCREC37", "IMQDEST37", "IMQINT37", "IMQMSG37", "IMQPROPS37", "IMQILIST37", "IMQTXN37", "IMQTACK37"};
    private static String[] v350tableNames = new String[]{"IMQSV35", "IMQCCREC35", "IMQDEST35", "IMQINT35", "IMQMSG35", "IMQPROPS35", "IMQILIST35", "IMQTXN35", "IMQTACK35"};

    @Override
    protected boolean getDEBUG() {
        return Store.getDEBUG();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBManager getDBManager() throws BrokerException {
        if (dbMgr == null) {
            Object object = classLock;
            synchronized (object) {
                if (dbMgr == null) {
                    dbMgr = new DBManager();
                    dbMgr.loadTableSchema();
                    DBManager.dbMgr.dbpool = new DBConnectionPool(dbMgr, "dbp");
                    dbMgr.initDBMetaData();
                }
            }
        }
        return dbMgr;
    }

    @Override
    protected String getJDBCPropPrefix() {
        return JDBC_PROP_PREFIX;
    }

    @Override
    protected String getStoreTypeProp() {
        return STORE_TYPE_PROP;
    }

    @Override
    protected String getCreateStoreProp() {
        return "imq.persist.storecreate.all";
    }

    @Override
    protected boolean getCreateStorePropDefault() {
        return false;
    }

    @Override
    protected String getLogStringTag() {
        return "";
    }

    @Override
    public String toString() {
        return "DBManager";
    }

    @Override
    protected void checkMaxTableNameLength(int maxTableNameLength) throws BrokerException {
        if (maxTableNameLength > 0) {
            if (Globals.getHAEnabled()) {
                if (this.clusterID.length() + 17 + 1 > maxTableNameLength) {
                    Object[] args = new Object[]{this.clusterID, maxTableNameLength, 18};
                    throw new BrokerException(this.br.getKString("B3179", args));
                }
            } else if (this.brokerID.length() + 17 + 1 > maxTableNameLength) {
                Object[] args = new Object[]{this.brokerID, maxTableNameLength, 18};
                throw new BrokerException(this.br.getKString("B3094", args));
            }
        }
    }

    @Override
    protected boolean isStoreInited() {
        return this.storeInited;
    }

    protected void setStoreInited(boolean b) {
        this.storeInited = b;
    }

    private DBManager() throws BrokerException {
        this.initDBManagerProps();
        this.fixOldTableNames();
        this.initDBDriver();
    }

    @Override
    protected void initTableSuffix() throws BrokerException {
        this.brokerID = Globals.getBrokerID();
        if (this.brokerID == null || this.brokerID.length() == 0 || !Util.isAlphanumericString(this.brokerID)) {
            throw new BrokerException(this.br.getKString("B3093", this.brokerID));
        }
        if (Globals.getHAEnabled()) {
            this.clusterID = Globals.getClusterID();
            if (this.clusterID == null || this.clusterID.length() == 0 || !Util.isAlphanumericString(this.clusterID)) {
                throw new BrokerException(this.br.getKString("B3178", this.clusterID));
            }
            this.tableSuffix = "C" + this.clusterID;
        } else {
            this.tableSuffix = "S" + this.brokerID;
        }
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    @Override
    public String getClusterID() {
        return this.clusterID;
    }

    @Override
    public int checkStoreExists(Connection conn) throws BrokerException {
        return super.checkStoreExists(conn, null);
    }

    @Override
    protected Connection getConnection() throws BrokerException {
        return this.dbpool.getConnection();
    }

    @Override
    public void freeConnection(Connection conn, Throwable thr) throws BrokerException {
        this.dbpool.freeConnection(conn, thr);
    }

    @Override
    public void closeSQLObjects(ResultSet rset, Statement stmt, Connection conn, Throwable ex) throws BrokerException {
        Util.close(rset, stmt, conn, ex);
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("storeInited", this.storeInited);
        ht.put("clusterID", "" + this.clusterID);
        ht.put("brokerID", "" + this.brokerID);
        ht.put(this.dbpool.toString(), this.dbpool.getDebugState());
        return ht;
    }

    public boolean isHAClusterActive(Connection conn) throws BrokerException {
        boolean isActive = false;
        BrokerDAO bkrDAO = DBManager.getDBManager().getDAOFactory().getBrokerDAO();
        HashMap bkrMap = bkrDAO.getAllBrokerInfos(conn, false);
        Iterator itr = bkrMap.values().iterator();
        long currentTime = System.currentTimeMillis();
        while (itr.hasNext()) {
            long lastHeartBeat;
            HABrokerInfo bkrInfo = (HABrokerInfo)itr.next();
            int state = bkrInfo.getState();
            if (!BrokerState.getState(state).isActiveState() || (lastHeartBeat = bkrInfo.getHeartbeat()) + 180000L <= currentTime) continue;
            isActive = true;
            break;
        }
        return isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAOFactory getDAOFactory() {
        if (this.daoFactory == null) {
            Object object = classLock;
            synchronized (object) {
                if (this.daoFactory == null) {
                    if (this.isHADB) {
                        this.logger.log(4, "Instantiating HADB DAO factory");
                        this.daoFactory = new HADBDAOFactory();
                    } else if (this.isOracle) {
                        this.logger.log(4, "Instantiating Oracle DAO factory");
                        this.daoFactory = new OracleDAOFactory();
                    } else if (this.isMysql) {
                        this.logger.log(4, "Instantiating MySQL DAO factory");
                        this.daoFactory = new MySQLDAOFactory();
                    } else {
                        this.logger.log(4, "Instantiating generic DAO factory");
                        this.daoFactory = new GenericDAOFactory();
                    }
                }
            }
        }
        return this.daoFactory;
    }

    @Override
    protected BaseDAO getFirstDAO() throws BrokerException {
        return (BaseDAO)this.getDAOFactory().getAllDAOs().get(0);
    }

    public void resetConnectionPool() throws BrokerException {
        this.dbpool.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        Object object = classLock;
        synchronized (object) {
            this.dbpool.close();
            super.close();
            if (dbMgr != null) {
                dbMgr = null;
            }
        }
    }

    @Override
    public String[] getTableNames(int version) {
        String[] names = new String[]{};
        if (version == 410) {
            names = this.tableSchemas.keySet().toArray(names);
        } else if (version == 370) {
            names = v370tableNames;
        } else if (version == 350) {
            names = v350tableNames;
        }
        return names;
    }

    @Override
    public boolean hasSupplementForCreateDrop(String tableName) {
        return false;
    }

    @Override
    public Iterator allDAOIterator() throws BrokerException {
        return this.getDAOFactory().getAllDAOs().iterator();
    }

    @Override
    protected String getTableLockTableName() throws BrokerException {
        VersionDAO dao = DBManager.getDBManager().getDAOFactory().getVersionDAO();
        return dao.getTableName();
    }

    @Override
    protected String getCurrentTableLock(Connection conn, boolean doLock) throws BrokerException {
        VersionDAO verDAO = DBManager.getDBManager().getDAOFactory().getVersionDAO();
        String currLock = verDAO.getLock(conn, 410);
        if (currLock == null) {
            if (!doLock) {
                Globals.getLogger().log(16, "B3206", (Object)verDAO.getTableName());
                verDAO.insert(conn, 410);
                return "";
            }
            throw new BrokerException(Globals.getBrokerResources().getKString("B3206", verDAO.getTableName()), 404);
        }
        return currLock;
    }

    @Override
    protected void updateTableLock(Connection conn, String newLockID, String oldLockID, Object extra) throws BrokerException {
        VersionDAO verDAO = DBManager.getDBManager().getDAOFactory().getVersionDAO();
        boolean updated = verDAO.updateLock(conn, 410, newLockID, oldLockID);
        if (!updated) {
            if (newLockID == null) {
                Globals.getLogger().log(32, "B3205");
            }
            String currLock = verDAO.getLock(conn, 410);
            this.throwTableLockedException(currLock);
        }
    }

    @Override
    public void throwTableLockedException(String lockid) throws BrokerException {
        this.throwTableLockedException(new CommDBManager.TableLock(lockid, this.getTableLockTableName()));
    }

    @Override
    protected void throwTableLockedException(CommDBManager.TableLock lock) throws BrokerException {
        BrokerResources br = Globals.getBrokerResources();
        String emsg = null;
        if (lock.port != 0) {
            emsg = br.getKString("B3155", lock.host, String.valueOf(lock.port));
            throw new BrokerException(emsg, "B3155", null, 409);
        }
        emsg = br.getKString("B3156");
        throw new BrokerException(emsg, "B3156", null, 409);
    }

    private void fixOldTableNames() {
        int i;
        for (i = 0; i < v370tableNames.length; ++i) {
            DBManager.v370tableNames[i] = v370tableNames[i] + this.brokerID;
        }
        for (i = 0; i < v350tableNames.length; ++i) {
            DBManager.v350tableNames[i] = v350tableNames[i] + this.brokerID;
        }
    }
}

