/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.ObjectInputStreamCallback;
import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.PHashMapMMF;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnAckList;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TidList {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String TXN_USE_MEMORY_MAPPED_FILE_PROP = "imq.persist.file.transaction.memorymappedfile.enabled";
    static final String TXN_UPDATE_OPTIMIZATION_PROP = "imq.persist.file.transaction.memorymappedfile.updateoptimization.enabled";
    static final String TXN_FILE_SIZE_PROP = "imq.persist.file.transaction.file.size";
    static final boolean DEFAULT_TXN_USE_MEMORY_MAPPED_FILE = true;
    static final boolean DEFAULT_TXN_UPDATE_OPTIMIZATION = true;
    static final long DEFAULT_TXN_FILE_SIZE = 1024L;
    static final int CLIENT_DATA_SIZE = 17;
    static final String BASENAME = "txn";
    private PHashMap tidMap = null;
    private boolean useMemoryMappedFile = true;
    private boolean updateOptimization = true;
    private File backingFile = null;
    private TxnAckList txnAckList = null;
    private LoadException loadException = null;

    TidList(FileStore p, File topDir, boolean clear) throws BrokerException {
        SizeString filesize = this.config.getSizeProperty(TXN_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(topDir, BASENAME);
        try {
            this.useMemoryMappedFile = this.config.getBooleanProperty(TXN_USE_MEMORY_MAPPED_FILE_PROP, true);
            boolean bl = this.updateOptimization = this.useMemoryMappedFile && this.config.getBooleanProperty(TXN_UPDATE_OPTIMIZATION_PROP, true);
            if (this.useMemoryMappedFile) {
                this.tidMap = new PHashMapMMF(this.backingFile, filesize.getBytes(), 1024, false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
                if (this.updateOptimization) {
                    ((PHashMapMMF)this.tidMap).intClientData(17);
                }
            } else {
                this.tidMap = new PHashMap(this.backingFile, filesize.getBytes(), 1024, false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
            }
        }
        catch (IOException e) {
            this.logger.log(32, "B4032", (Throwable)e);
            throw new BrokerException(this.br.getString("B4032"), e);
        }
        try {
            Map.Entry entry2;
            Object value;
            this.tidMap.load((ObjectInputStreamCallback)p);
            boolean oldStore = false;
            Set entries = this.tidMap.entrySet();
            Iterator itr = entries.iterator();
            if (itr.hasNext() && (value = (entry2 = (Map.Entry)itr.next()).getValue()) instanceof TransactionState) {
                oldStore = true;
            }
            if (oldStore) {
                this.loadClientDataOldFormat();
                for (Map.Entry entry2 : entries) {
                    Object key = entry2.getKey();
                    Object value2 = entry2.getValue();
                    this.tidMap.put(key, (Object)new TransactionInfo((TransactionState)value2));
                }
            } else {
                this.loadClientData();
            }
        }
        catch (IOException e) {
            this.logger.log(32, "B4032", (Throwable)e);
            throw new BrokerException(this.br.getString("B4032"), e);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(32, "B4032", (Throwable)e);
            throw new BrokerException(this.br.getString("B4032"), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4197", (Throwable)le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = this.tidMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of transaction data", (Throwable)w);
        }
        if (clear && Store.getDEBUG()) {
            this.logger.log(1, "TidList initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "TidList: loaded " + this.tidMap.size() + " transactions");
        }
        this.txnAckList = new TxnAckList(p, topDir, clear);
    }

    TidList(FileStore p, File topDir, File oldTop) throws BrokerException {
        File oldFile = new File(oldTop, BASENAME);
        PHashMap olddata = null;
        this.backingFile = new File(topDir, BASENAME);
        try {
            olddata = new PHashMap(oldFile, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        try {
            olddata.load((ObjectInputStreamCallback)p);
        }
        catch (IOException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4202", (Throwable)le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = olddata.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of transaction data in old store", (Throwable)w);
        }
        try {
            this.useMemoryMappedFile = this.config.getBooleanProperty(TXN_USE_MEMORY_MAPPED_FILE_PROP, true);
            boolean bl = this.updateOptimization = this.useMemoryMappedFile && this.config.getBooleanProperty(TXN_UPDATE_OPTIMIZATION_PROP, true);
            if (this.useMemoryMappedFile) {
                this.tidMap = new PHashMapMMF(this.backingFile, oldFile.length(), 1024, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
                if (this.updateOptimization) {
                    ((PHashMapMMF)this.tidMap).intClientData(17);
                }
            } else {
                this.tidMap = new PHashMap(this.backingFile, oldFile.length(), 1024, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
            }
        }
        catch (IOException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        try {
            this.tidMap.load((ObjectInputStreamCallback)p);
            this.loadClientData();
        }
        catch (ClassNotFoundException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        catch (IOException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException e) {
            this.logger.log(32, "B4157", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4157", oldFile, this.backingFile), e);
        }
        w = this.tidMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of transaction data", (Throwable)w);
        }
        for (Map.Entry entry : olddata.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.tidMap.put(key, (Object)new TransactionInfo((TransactionState)value));
        }
        olddata.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "TidList: upgraded " + this.tidMap.size() + " transactions");
        }
        if (p.upgradeNoBackup() && !oldFile.delete()) {
            this.logger.log(32, "B1044", (Object)oldFile);
        }
        this.txnAckList = new TxnAckList(p, topDir, oldTop, p.upgradeNoBackup());
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    LoadException getLoadTransactionAckException() {
        return this.txnAckList.getLoadException();
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TidList: closing, " + this.tidMap.size() + " persisted transactions");
        }
        this.tidMap.close();
        this.txnAckList.close(cleanup);
    }

    void storeTransaction(TransactionUID id, TransactionState ts, boolean sync) throws IOException, BrokerException {
        try {
            Object oldValue = this.tidMap.putIfAbsent((Object)id, (Object)new TransactionInfo(new TransactionState(ts)));
            if (oldValue != null) {
                this.logger.log(32, "B3015", (Object)id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
            if (sync) {
                this.sync(id);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    public void storeClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] brokers, boolean sync) throws BrokerException {
        TransactionInfo txnInfo = null;
        try {
            txnInfo = new TransactionInfo(new TransactionState(ts), null, brokers, 2);
            Object oldValue = this.tidMap.putIfAbsent((Object)id, (Object)txnInfo);
            if (oldValue != null) {
                this.logger.log(32, "B3015", (Object)id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
            if (sync) {
                this.sync(id);
            }
        }
        catch (RuntimeException e) {
            String msg = txnInfo != null ? id + " " + txnInfo.toString() : id.toString();
            this.logger.log(32, "B4019", (Object)msg, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", msg), e);
        }
    }

    public void storeRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] acks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        TransactionInfo txnInfo = null;
        boolean removedAcksFlag = false;
        try {
            if (this.tidMap.containsKey((Object)id)) {
                this.logger.log(32, "B3015", (Object)id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
            if (acks != null && acks.length > 0) {
                this.txnAckList.storeAcks(id, acks, sync);
                removedAcksFlag = true;
            }
            txnInfo = new TransactionInfo(new TransactionState(ts), txnHomeBroker, null, 3);
            this.tidMap.put((Object)id, (Object)txnInfo);
            if (sync) {
                this.sync(id);
            }
        }
        catch (RuntimeException e) {
            String msg = txnInfo != null ? id + " " + txnInfo.toString() : id.toString();
            this.logger.log(32, "B4019", (Object)msg, (Throwable)e);
            try {
                if (removedAcksFlag) {
                    this.txnAckList.removeAcks(id, sync);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new BrokerException(this.br.getString("B4019", msg), e);
        }
    }

    void storeTransaction(TransactionUID id, TransactionInfo txnInfo, boolean sync) throws BrokerException {
        try {
            this.tidMap.put((Object)id, (Object)txnInfo);
            if (sync) {
                this.sync(id);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    void removeTransaction(TransactionUID id, boolean sync) throws BrokerException {
        try {
            Object txnInfo = this.tidMap.remove((Object)id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            if (sync) {
                this.sync(id);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4138", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4138", id), e);
        }
    }

    void updateTransactionState(TransactionUID id, TransactionState tstate, boolean sync) throws IOException, BrokerException {
        try {
            TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            TransactionState txnState = txnInfo.getTransactionState();
            int ts = tstate.getState();
            if (txnState.getState() != ts) {
                txnState.setState(ts);
                if (tstate.getOnephasePrepare()) {
                    txnState.setOnephasePrepare(true);
                }
                if (this.updateOptimization) {
                    byte[] cd = this.generateClientData(id, txnInfo);
                    PHashMapMMF tidMapMMF = (PHashMapMMF)this.tidMap;
                    tidMapMMF.putClientData((Object)id, cd);
                } else {
                    this.tidMap.put((Object)id, (Object)txnInfo);
                }
            } else {
                sync = false;
            }
            if (sync) {
                this.sync(id);
            }
        }
        catch (Exception e) {
            this.logger.log(32, "B4137", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4137", id), e);
        }
    }

    public void updateClusterTransaction(TransactionUID id, TransactionBroker[] brokers, boolean sync) throws BrokerException {
        try {
            TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            txnInfo.setType(2);
            txnInfo.setTransactionBrokers(brokers);
            this.tidMap.put((Object)id, (Object)txnInfo);
            if (sync) {
                this.sync(id);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    void updateTransactionBrokerState(TransactionUID id, int expectedTxnState, TransactionBroker txnBkr, boolean sync) throws BrokerException {
        try {
            TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
            if (txnInfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            TransactionState txnState = txnInfo.getTransactionState();
            if (txnState.getState() != expectedTxnState) {
                Object[] args = new Object[]{txnBkr, id, TransactionState.toString(expectedTxnState), TransactionState.toString(txnState.getState())};
                throw new BrokerException(this.br.getKString("B3219", args), 409);
            }
            txnInfo.updateBrokerState(txnBkr);
            if (this.updateOptimization) {
                byte[] cd = this.generateClientData(id, txnInfo);
                PHashMapMMF tidMapMMF = (PHashMapMMF)this.tidMap;
                tidMapMMF.putClientData((Object)id, cd);
            } else {
                this.tidMap.put((Object)id, (Object)txnInfo);
            }
            if (sync) {
                this.sync(id);
            }
        }
        catch (Exception e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
    }

    TransactionState getTransactionState(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return new TransactionState(txnInfo.getTransactionState());
    }

    int getTransactionStateValue(TransactionUID id) throws BrokerException {
        TransactionState txnState;
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
        if (txnInfo != null && (txnState = txnInfo.getTransactionState()) != null) {
            return txnState.getState();
        }
        return -1;
    }

    TransactionInfo getTransactionInfo(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return (TransactionInfo)txnInfo.clone();
    }

    BrokerAddress getRemoteTransactionHomeBroker(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return txnInfo.getTransactionHomeBroker();
    }

    TransactionBroker[] getClusterTransactionBrokers(TransactionUID id) throws BrokerException {
        TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)id);
        if (txnInfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        TransactionBroker[] txnBrokers = txnInfo.getTransactionBrokers();
        if (txnBrokers != null) {
            txnBrokers = (TransactionBroker[])txnBrokers.clone();
        }
        return txnBrokers;
    }

    HashMap getAllTransactionStates() throws IOException {
        HashMap map = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo txnInfo = (TransactionInfo)entry.getValue();
            int type = txnInfo.getType();
            if (type != 1 && type != 2) continue;
            map.put(entry.getKey(), new TransactionInfo(txnInfo));
        }
        return map;
    }

    HashMap getAllRemoteTransactionStates() throws IOException {
        HashMap map = new HashMap(this.tidMap.size());
        for (Map.Entry entry : this.tidMap.entrySet()) {
            TransactionInfo txnInfo = (TransactionInfo)entry.getValue();
            int type = txnInfo.getType();
            if (type != 3) continue;
            map.put(entry.getKey(), new TransactionState(txnInfo.getTransactionState()));
        }
        return map;
    }

    Collection getAllTransactions() {
        return this.tidMap.keySet();
    }

    void clearAll(boolean sync) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TidList.clearAll() called");
        }
        try {
            this.tidMap.clear();
            if (sync) {
                this.sync(null);
            }
        }
        catch (BrokerException e) {
            this.logger.log(32, this.br.getString("B4020", this.backingFile), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.log(32, this.br.getString("B4020", this.backingFile), (Throwable)e);
        }
        this.txnAckList.clearAll(sync);
    }

    void clear(int state, boolean sync) throws BrokerException {
        boolean error = false;
        Exception exception = null;
        Iterator itr = this.tidMap.entrySet().iterator();
        while (itr.hasNext()) {
            block10: {
                try {
                    Map.Entry entry = (Map.Entry)itr.next();
                    TransactionUID tid = (TransactionUID)entry.getKey();
                    TransactionState ts = (TransactionState)entry.getValue();
                    if (ts.getState() == state) break block10;
                    itr.remove();
                    try {
                        this.txnAckList.removeAcks(tid, sync);
                    }
                    catch (BrokerException e) {
                        error = true;
                        exception = e;
                        break;
                    }
                }
                catch (RuntimeException e) {
                    error = true;
                    exception = e;
                    this.logger.log(32, "B4139", (Object)state, (Throwable)e);
                }
            }
            if (!sync) continue;
            this.sync(null);
        }
        if (!error) {
            TransactionUID[] tids = this.txnAckList.getAllTids();
            for (int i = 0; i < tids.length; ++i) {
                TransactionInfo txnInfo = (TransactionInfo)this.tidMap.get((Object)tids[i]);
                if (txnInfo != null && txnInfo.getTransactionStateValue() == state) continue;
                try {
                    this.txnAckList.removeAcks(tids[i], sync);
                    continue;
                }
                catch (BrokerException e) {
                    error = true;
                    exception = e;
                    break;
                }
            }
        }
        if (error) {
            this.clearAll(sync);
            throw new BrokerException(this.br.getString("B4139", state), exception);
        }
    }

    void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        if (!this.tidMap.containsKey((Object)tid)) {
            this.logger.log(32, "B3016", (Object)tid.toString());
            throw new BrokerException(this.br.getString("B3016", tid.toString()));
        }
        this.txnAckList.storeAck(tid, ack, sync);
    }

    void removeTransactionAck(TransactionUID id, boolean sync) throws BrokerException {
        this.txnAckList.removeAcks(id, sync);
    }

    TransactionAcknowledgement[] getTransactionAcks(TransactionUID tid) throws BrokerException {
        return this.txnAckList.getAcks(tid);
    }

    HashMap getAllTransactionAcks() {
        return this.txnAckList.getAllAcks();
    }

    public int getNumberOfTxnAcks() {
        return this.txnAckList.getNumberOfTxnAcks();
    }

    public int getNumberOfTxns() {
        return this.tidMap.size();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Transactions", String.valueOf(this.tidMap.size()));
        t.putAll(this.txnAckList.getDebugState());
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nTransaction IDs");
        out.println("---------------");
        out.println("backing file: " + this.backingFile);
        out.println("number of transaction ids: " + this.tidMap.size());
        this.txnAckList.printInfo(out);
    }

    private void loadClientData() throws PHashMapLoadException {
        if (!this.updateOptimization) {
            return;
        }
        PHashMapLoadException loadException = null;
        Iterator itr = this.tidMap.entrySet().iterator();
        while (itr.hasNext()) {
            Throwable ex = null;
            Map.Entry entry = (Map.Entry)itr.next();
            Object key = entry.getKey();
            TransactionInfo value = (TransactionInfo)entry.getValue();
            byte[] cData = null;
            try {
                cData = ((PHashMapMMF)this.tidMap).getClientData(key);
                if (cData != null && cData.length > 0) {
                    byte state = cData[0];
                    value.getTransactionState().setState(state);
                    TransactionBroker[] bkrs = value.getTransactionBrokers();
                    if (bkrs != null) {
                        int len = bkrs.length;
                        for (int i = 0; i < len; ++i) {
                            TransactionBroker bkr = bkrs[i];
                            boolean isComplete = cData[i + 1] == 1;
                            bkr.setCompleted(isComplete);
                        }
                    }
                }
            }
            catch (Throwable e) {
                ex = e;
            }
            if (ex == null) continue;
            PHashMapLoadException le = new PHashMapLoadException("Failed to load client data [cData=" + Arrays.toString(cData) + "]");
            le.setKey(key);
            le.setValue((Object)value);
            le.setNextException(loadException);
            le.initCause(ex);
            loadException = le;
        }
        if (loadException != null) {
            throw loadException;
        }
    }

    private void loadClientDataOldFormat() throws PHashMapLoadException {
        if (!this.updateOptimization) {
            return;
        }
        PHashMapLoadException loadException = null;
        Iterator itr = this.tidMap.entrySet().iterator();
        while (itr.hasNext()) {
            Throwable ex = null;
            Map.Entry entry = (Map.Entry)itr.next();
            Object key = entry.getKey();
            TransactionState value = (TransactionState)entry.getValue();
            byte[] cData = null;
            try {
                cData = ((PHashMapMMF)this.tidMap).getClientData(key);
                if (cData != null && cData.length > 0) {
                    byte state = cData[0];
                    value.setState(state);
                }
            }
            catch (Throwable e) {
                ex = e;
            }
            if (ex == null) continue;
            PHashMapLoadException le = new PHashMapLoadException("Failed to load client data [cData=" + Arrays.toString(cData) + "]");
            le.setKey(key);
            le.setValue((Object)value);
            le.setNextException(loadException);
            le.initCause(ex);
            loadException = le;
        }
        if (loadException != null) {
            throw loadException;
        }
    }

    private byte[] generateClientData(TransactionUID tid, TransactionInfo txnInfo) throws BrokerException {
        int numBkrs;
        byte[] cd = new byte[17];
        cd[0] = (byte)txnInfo.getTransactionStateValue();
        TransactionBroker[] bkrs = txnInfo.getTransactionBrokers();
        int n = numBkrs = bkrs != null ? bkrs.length : 0;
        if (numBkrs > 16) {
            throw new BrokerException("Internal Error: transaction broker list size of " + numBkrs + " is larger than the reserved client data byte limit of " + 16 + " for transaction " + tid);
        }
        for (int i = 1; i < 17; ++i) {
            int bIndex = i - 1;
            cd[i] = bIndex < numBkrs ? (byte)(bkrs[bIndex].isCompleted() ? 1 : 0) : (byte)0;
        }
        return cd;
    }

    void sync(Object key) throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "TidList sync() ";
                this.logger.log(4, msg);
            }
            this.tidMap.force(key);
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.backingFile, e);
        }
    }

    void syncTransactionAck(TransactionUID tid) throws BrokerException {
        this.txnAckList.sync(tid);
    }

    public static void deleteAllFiles(File rootDir) throws BrokerException {
        boolean deleted;
        File file = new File(rootDir, BASENAME);
        if (file.exists() && !(deleted = file.delete())) {
            Object[] args = new String[]{BASENAME, rootDir.getPath(), "txn.deleted"};
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2248", args));
            File nf = new File(rootDir, "txn.deleted");
            if (!file.renameTo(nf)) {
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2249", file.getPath(), nf.getPath()));
                throw new BrokerException(Globals.getBrokerResources().getKString("B4362", file));
            }
        }
    }

    public static boolean txFileExists(File rootDir) {
        boolean result = false;
        String filename = BASENAME;
        File txFile = new File(rootDir, filename);
        result = txFile.exists();
        return result;
    }

    public static boolean txAckFileExists(File rootDir) {
        boolean result = false;
        String filename = "txnack";
        File txFile = new File(rootDir, filename);
        result = txFile.exists();
        return result;
    }

    public static void assertAllFilesExists(File rootDir) throws BrokerException {
        if (!TidList.txFileExists(rootDir)) {
            throw new BrokerException("assertion failure: txn file does not exist");
        }
        if (!TidList.txAckFileExists(rootDir)) {
            throw new BrokerException("assertion failure: txnack file does not exist");
        }
    }
}

