/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class ConnectionUtil {
    public static List getConnections() {
        List connections = ConnectionUtil.getConnections(null);
        return connections;
    }

    public static List getConnections(String service) {
        ConnectionManager cm = Globals.getConnectionManager();
        List connections = null;
        try {
            Service s = null;
            if (service != null && (s = Globals.getServiceManager().getService(service)) == null) {
                return connections;
            }
            connections = cm.getConnectionList(s);
        }
        catch (Exception e) {
            BrokerResources rb = Globals.getBrokerResources();
            Logger logger = Globals.getLogger();
            logger.log(16, rb.getString("B2175"), (Throwable)e);
        }
        return connections;
    }

    public static List getConnectionInfoList(String service) {
        List connections;
        ConnectionManager cm = Globals.getConnectionManager();
        ArrayList<ConnectionInfo> connectionInfoList = new ArrayList<ConnectionInfo>();
        try {
            Service s = null;
            if (service != null && (s = Globals.getServiceManager().getService(service)) == null) {
                return connectionInfoList;
            }
            connections = cm.getConnectionList(s);
        }
        catch (Exception e) {
            BrokerResources rb = Globals.getBrokerResources();
            Logger logger = Globals.getLogger();
            logger.log(16, rb.getString("B2175"), (Throwable)e);
            return connectionInfoList;
        }
        if (connections.size() == 0) {
            return connectionInfoList;
        }
        for (IMQConnection cxn : connections) {
            ConnectionInfo cxnInfo = cxn.getConnectionInfo();
            connectionInfoList.add(cxnInfo);
        }
        return connectionInfoList;
    }

    public static ConnectionInfo getConnectionInfo(long id) {
        ConnectionManager cm = Globals.getConnectionManager();
        ConnectionInfo cxnInfo = null;
        IMQConnection cxn = null;
        cxn = (IMQConnection)cm.getConnection(new ConnectionUID(id));
        if (cxn == null) {
            return null;
        }
        cxnInfo = cxn.getConnectionInfo();
        return cxnInfo;
    }

    public static String getServiceOfConnection(long id) {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(id);
        if (cxnInfo == null) {
            return null;
        }
        return cxnInfo.service;
    }

    public static Long getCreationTime(long cxnId) {
        long currentTime = System.currentTimeMillis();
        ConnectionUID cxnUID = new ConnectionUID(cxnId);
        return currentTime - cxnUID.age(currentTime);
    }

    public static List getConsumerIDs(long cxnId) {
        ConnectionManager cm = Globals.getConnectionManager();
        Object cxnInfo = null;
        IMQConnection cxn = null;
        cxn = (IMQConnection)cm.getConnection(new ConnectionUID(cxnId));
        List consumerIDs = cxn.getConsumersIDs();
        return consumerIDs;
    }

    public static List getProducerIDs(long cxnId) {
        ConnectionManager cm = Globals.getConnectionManager();
        Object cxnInfo = null;
        IMQConnection cxn = null;
        cxn = (IMQConnection)cm.getConnection(new ConnectionUID(cxnId));
        List producerIDs = cxn.getProducerIDs();
        return producerIDs;
    }

    public static void destroyConnection(long cxnId, String reasonString) {
        ConnectionManager cm = Globals.getConnectionManager();
        IMQConnection cxn = null;
        cxn = (IMQConnection)cm.getConnection(new ConnectionUID(cxnId));
        if (cxn != null) {
            cxn.destroyConnection(true, 3, reasonString);
        }
    }

    public static void destroyConnection(String serviceName, String reasonString) {
        List cxnList = ConnectionUtil.getConnections(serviceName);
        IMQConnection cxn2 = null;
        if (cxnList == null || cxnList.size() == 0) {
            return;
        }
        for (IMQConnection cxn2 : cxnList) {
            if (cxn2 == null) continue;
            cxn2.destroyConnection(true, 3, reasonString);
        }
    }
}

