/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class TransactionBroker
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 4331266333483540901L;
    private static transient Logger logger = Globals.getLogger();
    static final int PENDING = 0;
    static final int COMPLETE = 1;
    BrokerAddress broker = null;
    int state = 0;

    public TransactionBroker() {
    }

    public TransactionBroker(BrokerAddress broker) {
        this.broker = broker;
        this.state = 0;
    }

    public TransactionBroker(BrokerAddress broker, boolean completed) {
        this(broker);
        if (completed) {
            this.state = 1;
        }
    }

    public BrokerAddress getBrokerAddress() {
        return this.broker;
    }

    public boolean isCompleted() {
        return this.state == 1;
    }

    public void setCompleted(boolean value) {
        this.state = value ? 1 : 0;
    }

    public boolean copyState(TransactionBroker b) throws BrokerException {
        if (this.state == b.state) {
            return false;
        }
        if (this.state == 0) {
            this.state = b.state;
            return true;
        }
        throw new BrokerException("Can't update transaction broker state from " + TransactionBroker.toString(this.state) + " to " + TransactionBroker.toString(b.state));
    }

    public int hashCode() {
        return this.broker.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransactionBroker)) {
            return false;
        }
        TransactionBroker other = (TransactionBroker)o;
        BrokerAddress thiscurrb = this.getCurrentBrokerAddress();
        BrokerAddress othercurrb = other.getCurrentBrokerAddress();
        boolean sameaddr = this.broker.equals(other.broker) || thiscurrb != null && thiscurrb.equals(othercurrb);
        Globals.getDestinationList();
        if (!DestinationList.isPartitionMode()) {
            return sameaddr;
        }
        return sameaddr && this.broker.getStoreSessionUID().equals((Object)other.broker.getStoreSessionUID());
    }

    public BrokerAddress getCurrentBrokerAddress() {
        if (!Globals.getHAEnabled()) {
            return this.getBrokerAddress();
        }
        String brokerid = null;
        UID ss = this.broker.getStoreSessionUID();
        if (ss == null) {
            return null;
        }
        brokerid = Globals.getClusterManager().lookupStoreSessionOwner(ss);
        if (brokerid == null) {
            return null;
        }
        if (brokerid.equals(Globals.getMyAddress().getBrokerID())) {
            return Globals.getMyAddress();
        }
        return Globals.getClusterBroadcast().lookupBrokerAddress(brokerid);
    }

    public boolean isSame(UID ssid) {
        if (!Globals.getHAEnabled()) {
            return false;
        }
        UID ss = this.broker.getStoreSessionUID();
        return ss.equals((Object)ssid);
    }

    public String toString() {
        return "[" + this.broker.toString() + "]" + (this.state == 1 ? "" : TransactionBroker.toString(this.state));
    }

    private static String toString(int s) {
        if (s == 0) {
            return "PENDING";
        }
        if (s == 1) {
            return "COMPLETE";
        }
        return "UNKNOWN";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = in.readInt();
        this.broker = (BrokerAddress)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.state);
        out.writeObject(this.broker);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("This should never happen!");
        }
    }
}

