/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class SessionHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public Session createSession(int stype, String creator, IMQConnection con, boolean isIndemp) throws BrokerException {
        Session session = null;
        if (isIndemp) {
            session = Session.getSession(creator);
        }
        if (session == null) {
            session = Session.createSession(con.getConnectionUID(), creator, this.coreLifecycle);
            session.setAckType(stype);
            con.attachSession(session);
        }
        return session;
    }

    public void closeSession(SessionUID sessionID, IMQConnection con, boolean isIndemp) throws BrokerException {
        if (!isIndemp || Session.getSession(sessionID) != null) {
            assert (con.getSession(sessionID) != null);
            Session.closeSession(sessionID);
            con.closeSession(sessionID);
        }
    }

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        int status = 200;
        String reason = null;
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        boolean isIndemp = msg.getIndempotent();
        try {
            Hashtable props = msg.getProperties();
            Session session = null;
            if (msg.getPacketType() == 68) {
                Integer ack = props == null ? null : (Integer)props.get("JMQAckMode");
                int stype = ack == null ? 0 : ack;
                session = this.createSession(stype, msg.getSysMessageID().toString(), con, isIndemp);
                hash.put("JMQSessionID", session.getSessionUID().longValue());
            } else {
                assert (msg.getPacketType() == 70);
                Long lsessionid = (Long)props.get("JMQSessionID");
                if (lsessionid == null) {
                    throw new BrokerException(Globals.getBrokerResources().getString("B4117", "protocol error, no session"));
                }
                SessionUID sessionID = new SessionUID(lsessionid);
                this.closeSession(sessionID, con, isIndemp);
            }
        }
        catch (Exception ex) {
            boolean log = false;
            reason = ex.getMessage();
            if (ex instanceof BrokerException) {
                status = ((BrokerException)ex).getStatusCode();
                log = false;
            } else {
                status = 500;
                log = true;
            }
            if (log) {
                this.logger.logStack(8, Globals.getBrokerResources().getString("B4117", " session "), (Throwable)ex);
            }
            this.logger.log(8, ex.getMessage());
        }
        hash.put("JMQStatus", status);
        if (reason != null) {
            hash.put("JMQReason", reason);
        }
        if (msg.getSendAcknowledge()) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setConsumerID(msg.getConsumerID());
            pkt.setPacketType(msg.getPacketType() + 1);
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
        }
        return true;
    }
}

