/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.ExtHttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelDriver;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelTimerTask;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;

public class HttpTunnelConnection
implements HttpTunnelDefaults {
    private HttpTunnelDriver wire;
    private int connId;
    private int nextRecvSeq;
    private int rxWindowMax;
    private HttpTunnelPacket[] recvQ;
    private Object recvQLock;
    private int readOffset;
    private boolean sendWindowUpdate;
    private boolean connCloseReceived;
    private boolean connAbortReceived;
    private int rxConnCloseSeq;
    private int lastAckSeq;
    private int nextSendSeq;
    private int txWindowMax;
    private int dupAckCount;
    private Vector sendQ;
    private Object sendQLock;
    private boolean txDataDisabled;
    private boolean connCloseSent;
    private int txConnCloseSeq;
    private Hashtable rexmitTable;
    private long RTO;
    private long measuredRTO;
    private int pullPeriod;
    private int connectionTimeout;
    private int nRetransmit;
    private int nFastRetransmit;
    private static MQTimer timer = new MQTimer(true);
    private static long CLOSE_WAIT_TIMEOUT = Long.getLong("imq.httptunnel.close_wait", 60000L);
    private String remoteip = null;
    static final int ERRORRATE = -1;

    public HttpTunnelConnection(int connId, HttpTunnelDriver wire) {
        this.wire = wire;
        this.connId = connId;
        this.nextRecvSeq = 0;
        this.rxWindowMax = 64;
        this.recvQ = new HttpTunnelPacket[64];
        this.recvQLock = new Object();
        this.readOffset = 0;
        this.sendWindowUpdate = false;
        this.connCloseReceived = false;
        this.connAbortReceived = false;
        this.rxConnCloseSeq = 0;
        this.lastAckSeq = -1;
        this.nextSendSeq = 0;
        this.txWindowMax = 16;
        this.dupAckCount = 0;
        this.sendQ = new Vector();
        this.sendQLock = new Object();
        this.txDataDisabled = false;
        this.connCloseSent = false;
        this.txConnCloseSeq = 0;
        this.rexmitTable = new Hashtable();
        this.RTO = 15000L;
        this.measuredRTO = 15000L;
        this.pullPeriod = -1;
        this.connectionTimeout = -1;
        this.nRetransmit = 0;
        this.nFastRetransmit = 0;
        TimerTask dummyTask = new TimerTask(){

            @Override
            public void run() {
            }
        };
        try {
            timer.schedule(dummyTask, 1000L);
            dummyTask.cancel();
        }
        catch (IllegalStateException ise) {
            timer = new MQTimer(true);
        }
    }

    public void setRemoteAddr(String ip) {
        this.remoteip = ip;
    }

    public String getRemoteAddr() {
        return this.remoteip;
    }

    private boolean checkRange(int first, int last, int n) {
        if (first < last) {
            return n >= first && n <= last;
        }
        if (first > last) {
            return n >= first || n <= last;
        }
        return first == n;
    }

    public void receivePacket(HttpTunnelPacket p, boolean moreData) {
        int packetType = p.getPacketType();
        if (packetType == 4) {
            this.receiveData(p, moreData);
        } else {
            this.receiveAck(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveData(HttpTunnelPacket p, boolean moreData) {
        int seq = p.getSequence();
        boolean ackNow = true;
        Object object = this.recvQLock;
        synchronized (object) {
            if (p.getPacketType() == 5) {
                this.connCloseReceived = true;
                this.rxConnCloseSeq = seq;
            }
            if (this.recvQ == null) {
                if (this.connCloseReceived) {
                    this.flushAndClose();
                }
                return;
            }
            if (this.checkRange(this.nextRecvSeq, this.nextRecvSeq + this.rxWindowMax - 1, seq)) {
                if (this.connCloseReceived && p.getPacketType() == 4 && this.checkRange(this.rxConnCloseSeq, this.rxConnCloseSeq + this.rxWindowMax - 1, seq)) {
                    return;
                }
                int first = this.nextRecvSeq;
                if (this.recvQ[0] != null) {
                    first = this.recvQ[0].getSequence();
                }
                this.recvQ[seq - first] = p;
                if (seq == this.nextRecvSeq) {
                    int n;
                    for (n = 0; n < this.recvQ.length && this.recvQ[n] != null; ++n) {
                    }
                    this.nextRecvSeq = first + n;
                    this.rxWindowMax = this.recvQ.length - n;
                    this.recvQLock.notifyAll();
                    boolean bl = ackNow = !moreData;
                }
            }
            if (ackNow) {
                this.sendAck();
            }
        }
    }

    private void sendAck() {
        if (this.connAbortReceived) {
            return;
        }
        int seq = this.nextRecvSeq - 1;
        HttpTunnelPacket ack = new HttpTunnelPacket();
        ack.setPacketType(6);
        ack.setPacketBody(null);
        ack.setConnId(this.connId);
        ack.setSequence(seq);
        ack.setWinsize(this.rxWindowMax);
        ack.setChecksum(0);
        this.wire.sendPacket(ack);
        if (this.connCloseReceived && this.rxConnCloseSeq == seq) {
            this.wire.shutdown(this.connId);
        }
        this.sendWindowUpdate = !this.connCloseReceived && this.rxWindowMax == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRetransmitTimer(int seq) {
        HttpTunnelTimerTask task = new HttpTunnelTimerTask(this, seq);
        Hashtable hashtable = this.rexmitTable;
        synchronized (hashtable) {
            this.rexmitTable.put(Integer.toString(seq), task);
            timer.schedule((TimerTask)task, this.RTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRetransmitTimer(int seq) {
        HttpTunnelTimerTask task = null;
        Hashtable hashtable = this.rexmitTable;
        synchronized (hashtable) {
            task = (HttpTunnelTimerTask)this.rexmitTable.remove(Integer.toString(seq));
            if (task != null) {
                task.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRetransmitTimers() {
        Hashtable hashtable = this.rexmitTable;
        synchronized (hashtable) {
            Enumeration e = this.rexmitTable.elements();
            while (e.hasMoreElements()) {
                ((HttpTunnelTimerTask)e.nextElement()).cancel();
            }
            this.rexmitTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(ExtHttpTunnelPacket p) throws IOException {
        Object object = this.sendQLock;
        synchronized (object) {
            if (this.txDataDisabled) {
                throw new IOException("Connection closed.");
            }
            if (this.sendQ == null) {
                if (p.getPacketType() == 5) {
                    return;
                }
                if (this.connCloseReceived) {
                    throw new IOException("Broken pipe.");
                }
                throw new IOException("Connection closed.");
            }
            int seq = this.nextSendSeq++;
            p.setSequence(seq);
            long waitStart = -1L;
            while (this.txWindowMax == 0 || !this.checkRange(this.lastAckSeq + 1, this.lastAckSeq + this.txWindowMax, seq)) {
                if (waitStart == -1L) {
                    waitStart = System.currentTimeMillis();
                }
                try {
                    this.sendQLock.wait(180000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.sendQ == null) {
                    throw new IOException("Broken pipe.");
                }
                if (this.txWindowMax != 0 || System.currentTimeMillis() - waitStart < 180000L) continue;
                p.setDirtyFlag(true);
                this.wire.sendPacket(p);
                waitStart = -1L;
            }
            this.sendQ.addElement(p);
            if (p.getPacketType() == 5) {
                this.txDataDisabled = true;
                this.connCloseSent = true;
                this.txConnCloseSeq = seq;
            }
        }
        p.setTxTime(System.currentTimeMillis());
        this.startRetransmitTimer(p.getSequence());
        this.wire.sendPacket(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retransmitPacket(int seq, boolean fromTimer) {
        ExtHttpTunnelPacket p = null;
        boolean doSend = false;
        Object object = this.sendQLock;
        synchronized (object) {
            int last;
            if (this.sendQ == null) {
                return;
            }
            if (this.sendQ.size() == 0) {
                return;
            }
            int first = ((HttpTunnelPacket)this.sendQ.elementAt(0)).getSequence();
            if (!this.checkRange(first, last = first + this.sendQ.size() - 1, seq)) {
                return;
            }
            p = (ExtHttpTunnelPacket)this.sendQ.elementAt(seq - first);
            p.setDirtyFlag(true);
            if (first == seq) {
                doSend = true;
            }
        }
        if (fromTimer) {
            this.startRetransmitTimer(p.getSequence());
        }
        if (doSend) {
            int count = p.getRetransmitCount();
            p.setRetransmitCount(count + 1);
            this.wire.sendPacket(p);
            if (fromTimer && p.getRetransmitCount() > 1) {
                this.RTO <<= 1;
                if (this.RTO > 180000L) {
                    this.RTO = 180000L;
                }
            }
            if (fromTimer) {
                ++this.nRetransmit;
            } else {
                ++this.nFastRetransmit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAck(HttpTunnelPacket p) {
        int seq = p.getSequence();
        Object object = this.sendQLock;
        synchronized (object) {
            if (this.sendQ == null) {
                return;
            }
            if (this.connCloseSent && this.txConnCloseSeq == seq) {
                this.txShutdown();
                this.wire.shutdown(this.connId);
                return;
            }
            if (this.sendQ.size() > 0) {
                int last;
                int first = ((HttpTunnelPacket)this.sendQ.elementAt(0)).getSequence();
                if (this.checkRange(first, last = first + this.sendQ.size() - 1, seq)) {
                    ExtHttpTunnelPacket tmp;
                    do {
                        tmp = (ExtHttpTunnelPacket)this.sendQ.elementAt(0);
                        this.sendQ.removeElementAt(0);
                        this.stopRetransmitTimer(tmp.getSequence());
                    } while (tmp.getSequence() != seq);
                    if (!tmp.getDirtyFlag()) {
                        this.updateRTO(tmp);
                    }
                    this.dupAckCount = 0;
                    this.RTO = this.measuredRTO;
                } else if (seq == first - 1) {
                    ++this.dupAckCount;
                    if (this.dupAckCount == 3) {
                        this.retransmitPacket(first, false);
                    }
                }
            }
            this.lastAckSeq = seq;
            this.txWindowMax = p.getWinsize();
            this.sendQLock.notifyAll();
        }
    }

    private void updateRTO(ExtHttpTunnelPacket p) {
        this.measuredRTO >>= 1;
        long RTT = System.currentTimeMillis() - p.getTxTime();
        long SRTT = (this.measuredRTO << 3) - this.measuredRTO + RTT >>> 3;
        this.measuredRTO = SRTT << 1;
        if (this.measuredRTO < 1000L) {
            this.measuredRTO = 1000L;
        }
    }

    public int readData(byte[] buffer) throws IOException {
        return this.readData(buffer, 0, buffer.length);
    }

    private void discardPackets(int n) {
        System.arraycopy(this.recvQ, n, this.recvQ, 0, this.recvQ.length - n);
        for (int i = this.recvQ.length - n; i < this.recvQ.length; ++i) {
            this.recvQ[i] = null;
        }
        this.rxWindowMax += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readData(byte[] buffer, int off, int maxlen) throws IOException {
        int copied = 0;
        boolean endOfStream = false;
        boolean windowMoved = false;
        Object object = this.recvQLock;
        synchronized (object) {
            while (true) {
                if (this.recvQ == null) {
                    if (this.connCloseReceived) {
                        throw new IOException("Connection reset by peer.");
                    }
                    throw new IOException("Connection closed.");
                }
                if (this.recvQ[0] != null) {
                    int packetType = this.recvQ[0].getPacketType();
                    if (packetType == 4 || packetType == 5) break;
                    this.discardPackets(1);
                    windowMoved = true;
                    continue;
                }
                try {
                    this.recvQLock.wait();
                }
                catch (Exception packetType) {}
            }
            int n = 0;
            while (n < this.recvQ.length && this.recvQ[n] != null && copied < maxlen) {
                HttpTunnelPacket p = this.recvQ[n];
                if (p.getPacketType() == 5) {
                    endOfStream = true;
                    ++n;
                    continue;
                }
                if (p.getPacketType() == 10) {
                    ++n;
                    continue;
                }
                int len = p.getPacketDataSize() - this.readOffset;
                if (len > maxlen - copied) {
                    len = maxlen - copied;
                }
                if (buffer != null) {
                    System.arraycopy(p.getPacketBody(), this.readOffset, buffer, off, len);
                }
                this.readOffset += len;
                off += len;
                copied += len;
                if (this.readOffset != p.getPacketDataSize()) continue;
                this.readOffset = 0;
                ++n;
            }
            if (endOfStream) {
                this.rxShutdown();
            } else {
                if (n > 0) {
                    this.discardPackets(n);
                    windowMoved = true;
                }
                if (windowMoved && this.sendWindowUpdate) {
                    this.sendAck();
                }
            }
        }
        return copied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.recvQLock;
        synchronized (object) {
            int ret = 0;
            if (this.recvQ == null || this.recvQ[0] == null) {
                return 0;
            }
            if (this.recvQ[0].getPacketType() == 4) {
                ret += this.recvQ[0].getPacketDataSize() - this.readOffset;
            }
            for (int n = 1; n < this.recvQ.length && this.recvQ[n] != null; ++n) {
                if (this.recvQ[n].getPacketType() != 4) continue;
                ret += this.recvQ[n].getPacketDataSize();
            }
            return ret;
        }
    }

    public void writeData(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return;
        }
        ExtHttpTunnelPacket p = new ExtHttpTunnelPacket();
        p.setPacketType(4);
        p.setPacketBody(data);
        p.setConnId(this.connId);
        p.setWinsize(0);
        p.setChecksum(0);
        this.sendData(p);
    }

    private void flushAndClose() {
        this.nextRecvSeq = this.rxConnCloseSeq + 1;
        this.sendAck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConn() throws IOException {
        boolean sendClosePkt = true;
        Object object = this.recvQLock;
        synchronized (object) {
            if (this.connCloseReceived) {
                this.flushAndClose();
                sendClosePkt = false;
            }
        }
        object = this.sendQLock;
        synchronized (object) {
            this.rxShutdown();
            if (sendClosePkt) {
                ExtHttpTunnelPacket p = new ExtHttpTunnelPacket();
                p.setPacketType(5);
                p.setPacketBody(null);
                p.setConnId(this.connId);
                p.setWinsize(0);
                p.setChecksum(0);
                this.sendData(p);
            }
            long waitStart = System.currentTimeMillis();
            while (this.sendQ != null && this.sendQ.size() > 1) {
                try {
                    this.sendQLock.wait(CLOSE_WAIT_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.sendQ != null) {
                    this.sendQLock.notifyAll();
                }
                if (System.currentTimeMillis() - waitStart <= CLOSE_WAIT_TIMEOUT) continue;
            }
        }
    }

    public int getConnId() {
        return this.connId;
    }

    public int getPullPeriod() {
        return this.pullPeriod;
    }

    public void setPullPeriod(int pullPeriod) throws IOException {
        if (this.pullPeriod == pullPeriod) {
            return;
        }
        this.pullPeriod = pullPeriod;
        ExtHttpTunnelPacket p = new ExtHttpTunnelPacket();
        p.setPacketType(10);
        p.setConnId(this.connId);
        p.setWinsize(0);
        p.setChecksum(0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(1);
            dos.writeInt(pullPeriod);
            dos.flush();
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] buf = bos.toByteArray();
        p.setPacketBody(buf);
        this.sendData(p);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) throws IOException {
        if (this.connectionTimeout == connectionTimeout) {
            return;
        }
        this.connectionTimeout = connectionTimeout;
        ExtHttpTunnelPacket p = new ExtHttpTunnelPacket();
        p.setPacketType(10);
        p.setConnId(this.connId);
        p.setWinsize(0);
        p.setChecksum(0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(2);
            dos.writeInt(connectionTimeout);
            dos.flush();
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] buf = bos.toByteArray();
        p.setPacketBody(buf);
        this.sendData(p);
    }

    public void handleConnOption(HttpTunnelPacket p) {
        byte[] buf = p.getPacketBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int optname = dis.readInt();
            switch (optname) {
                case 1: {
                    this.pullPeriod = dis.readInt();
                    break;
                }
                case 2: {
                    this.connectionTimeout = dis.readInt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receiveData(p, false);
    }

    public void handleClose(HttpTunnelPacket p) {
        this.txShutdown();
        this.receiveData(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAbort(HttpTunnelPacket p) {
        Object object = this.recvQLock;
        synchronized (object) {
            if (this.connAbortReceived) {
                return;
            }
            this.connAbortReceived = true;
            p.setPacketType(5);
            p.setSequence(this.nextRecvSeq);
            this.handleClose(p);
            this.wire.shutdown(this.connId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rxShutdown() {
        Object object = this.recvQLock;
        synchronized (object) {
            this.recvQ = null;
            this.recvQLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txShutdown() {
        Object object = this.sendQLock;
        synchronized (object) {
            this.stopRetransmitTimers();
            this.sendQ = null;
            this.sendQLock.notifyAll();
        }
    }

    public Vector getStats() {
        if (this.sendQ == null && this.recvQ == null) {
            return null;
        }
        Vector<String> s = new Vector<String>();
        s.addElement("connId = " + this.connId);
        s.addElement("RX.nextRecvSeq = " + this.nextRecvSeq);
        s.addElement("RX.rxWindowMax = " + this.rxWindowMax);
        s.addElement("RX.rxConnCloseSeq = " + this.rxConnCloseSeq);
        s.addElement("sendWindowUpdate = " + this.sendWindowUpdate);
        s.addElement("connCloseReceived = " + this.connCloseReceived);
        s.addElement("connAbortReceived = " + this.connAbortReceived);
        s.addElement("TX.lastAckSeq = " + this.lastAckSeq);
        s.addElement("TX.nextSendSeq = " + this.nextSendSeq);
        s.addElement("TX.txWindowMax = " + this.txWindowMax);
        s.addElement("TX.dupAckCount = " + this.dupAckCount);
        s.addElement("TX.txConnCloseSeq = " + this.txConnCloseSeq);
        s.addElement("txDataDisabled = " + this.txDataDisabled);
        s.addElement("connCloseSent = " + this.connCloseSent);
        s.addElement("RTO = " + this.RTO);
        s.addElement("measuredRTO = " + this.measuredRTO);
        s.addElement("TX.nRetransmit = " + this.nRetransmit);
        s.addElement("TX.nFastRetransmit = " + this.nFastRetransmit);
        return s;
    }

    public Hashtable getDebugState() {
        Hashtable ht = this.wire.getDebugState();
        ht.put("connId", String.valueOf(this.connId));
        ht.put("RX.nextRecvSeq", String.valueOf(this.nextRecvSeq));
        ht.put("RX.rxWindowMax", String.valueOf(this.rxWindowMax));
        ht.put("RX.rxConnCloseSeq", String.valueOf(this.rxConnCloseSeq));
        ht.put("sendWindowUpdate", String.valueOf(this.sendWindowUpdate));
        ht.put("connCloseReceived", String.valueOf(this.connCloseReceived));
        ht.put("connAbortReceived", String.valueOf(this.connAbortReceived));
        ht.put("TX.lastAckSeq", String.valueOf(this.lastAckSeq));
        ht.put("TX.nextSendSeq", String.valueOf(this.nextSendSeq));
        ht.put("TX.txWindowMax", String.valueOf(this.txWindowMax));
        ht.put("TX.dupAckCount", String.valueOf(this.dupAckCount));
        ht.put("TX.txConnCloseSeq", String.valueOf(this.txConnCloseSeq));
        ht.put("txDataDisabled", String.valueOf(this.txDataDisabled));
        ht.put("connCloseSent", String.valueOf(this.connCloseSent));
        ht.put("RTO", String.valueOf(this.RTO));
        ht.put("measuredRTO", String.valueOf(this.measuredRTO));
        ht.put("TX.nRetransmit", String.valueOf(this.nRetransmit));
        ht.put("TX.nFastRetransmit", String.valueOf(this.nFastRetransmit));
        return ht;
    }
}

