/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.auth.jaas;

import com.sun.messaging.jmq.auth.jaas.MQBasicPermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class MQBasicPermission
extends Permission {
    private static final long serialVersionUID = 7965671047666454007L;
    private transient boolean wildcard;

    public MQBasicPermission(String name) {
        super(name);
        this.init(name);
    }

    private void init(String name) {
        if (name == null) {
            throw new NullPointerException("name null");
        }
        int len = name.length();
        if (len == 0) {
            throw new IllegalArgumentException("name empty");
        }
        if (len == 1 && name.equals("*")) {
            this.wildcard = true;
        } else {
            this.validateName(name);
        }
    }

    public abstract void validateName(String var1) throws IllegalArgumentException;

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof MQBasicPermission)) {
            return false;
        }
        if (p.getClass() != this.getClass()) {
            return false;
        }
        MQBasicPermission that = (MQBasicPermission)p;
        if (this.wildcard) {
            return true;
        }
        if (that.wildcard) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MQBasicPermission)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MQBasicPermission p = (MQBasicPermission)obj;
        return this.getName().equals(p.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new MQBasicPermissionCollection();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }
}

